/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel;

import java.util.Arrays;
import java.util.List;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.ObservableProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.SourcePrinter;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel.CsmElement;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel.CsmNone;

public class CsmConditional
implements CsmElement {
    private final Condition condition;
    private final List<ObservableProperty> properties;
    private final CsmElement thenElement;
    private final CsmElement elseElement;

    public Condition getCondition() {
        return this.condition;
    }

    public ObservableProperty getProperty() {
        if (this.properties.size() > 1) {
            throw new IllegalStateException();
        }
        return this.properties.get(0);
    }

    public List<ObservableProperty> getProperties() {
        return this.properties;
    }

    public CsmElement getThenElement() {
        return this.thenElement;
    }

    public CsmElement getElseElement() {
        return this.elseElement;
    }

    public CsmConditional(ObservableProperty property, Condition condition, CsmElement thenElement, CsmElement elseElement) {
        this.properties = Arrays.asList(property);
        this.condition = condition;
        this.thenElement = thenElement;
        this.elseElement = elseElement;
    }

    public CsmConditional(List<ObservableProperty> properties, Condition condition, CsmElement thenElement, CsmElement elseElement) {
        if (properties.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.properties = properties;
        this.condition = condition;
        this.thenElement = thenElement;
        this.elseElement = elseElement;
    }

    public CsmConditional(ObservableProperty property, Condition condition, CsmElement thenElement) {
        this(property, condition, thenElement, (CsmElement)new CsmNone());
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        boolean test = false;
        for (ObservableProperty prop : this.properties) {
            test = test || this.condition.evaluate(node, prop);
        }
        if (test) {
            this.thenElement.prettyPrint(node, printer);
        } else {
            this.elseElement.prettyPrint(node, printer);
        }
    }

    public static enum Condition {
        IS_EMPTY{

            @Override
            boolean evaluate(Node node, ObservableProperty property) {
                NodeList<? extends Node> value = property.getValueAsMultipleReference(node);
                return value == null || value.isEmpty();
            }
        }
        ,
        IS_NOT_EMPTY{

            @Override
            boolean evaluate(Node node, ObservableProperty property) {
                NodeList<? extends Node> value = property.getValueAsMultipleReference(node);
                return value != null && !value.isEmpty();
            }
        }
        ,
        IS_PRESENT{

            @Override
            boolean evaluate(Node node, ObservableProperty property) {
                return !property.isNullOrNotPresent(node);
            }
        }
        ,
        FLAG{

            @Override
            boolean evaluate(Node node, ObservableProperty property) {
                return property.getValueAsBooleanAttribute(node);
            }
        };


        abstract boolean evaluate(Node var1, ObservableProperty var2);
    }
}

