/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.FieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.Parameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayAccessExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayInitializerExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AssignExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BinaryExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BooleanLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.CastExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.CharLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ClassExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ConditionalExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.DoubleLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.EnclosedExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.FieldAccessExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.InstanceOfExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.IntegerLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LongLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodReferenceExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NameExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NullLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.StringLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.SuperExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ThisExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.TypeExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.UnaryExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.VariableDeclarationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.BlockStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ExpressionStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ReturnStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.ClassOrInterfaceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Navigator;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Solver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.FunctionalInterfaceLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.InferenceContext;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.Value;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.LazyType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.NullType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.promotion.ConditionalExprHandler;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedArrayType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedVoidType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.DefaultVisitorAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.promotion.ConditionalExprResolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.LeastUpperBoundLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Log;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Pair;

public class TypeExtractor
extends DefaultVisitorAdapter {
    private static final String JAVA_LANG_STRING = String.class.getCanonicalName();
    private final ResolvedType stringReferenceType;
    private TypeSolver typeSolver;
    private JavaParserFacade facade;

    public TypeExtractor(TypeSolver typeSolver, JavaParserFacade facade) {
        this.typeSolver = typeSolver;
        this.facade = facade;
        this.stringReferenceType = new LazyType((Function<Void, ResolvedType> & Serializable)v -> new ReferenceTypeImpl(typeSolver.solveType(JAVA_LANG_STRING)));
    }

    @Override
    public ResolvedType visit(VariableDeclarator node, Boolean solveLambdas) {
        if (Navigator.demandParentNode(node) instanceof FieldDeclaration) {
            return this.facade.convertToUsage(node.getType());
        }
        if (Navigator.demandParentNode(node) instanceof VariableDeclarationExpr) {
            return this.facade.convertToUsage(node.getType());
        }
        throw new UnsupportedOperationException(Navigator.demandParentNode(node).getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(Parameter node, Boolean solveLambdas) {
        if (node.getType().isUnknownType()) {
            throw new IllegalStateException("Parameter has unknown type: " + node);
        }
        return this.facade.convertToUsage(node.getType());
    }

    @Override
    public ResolvedType visit(ArrayAccessExpr node, Boolean solveLambdas) {
        ResolvedType arrayUsageType = node.getName().accept(this, solveLambdas);
        if (arrayUsageType.isArray()) {
            return ((ResolvedArrayType)arrayUsageType).getComponentType();
        }
        return arrayUsageType;
    }

    @Override
    public ResolvedType visit(ArrayCreationExpr node, Boolean solveLambdas) {
        ResolvedType res = this.facade.convertToUsage(node.getElementType(), JavaParserFactory.getContext(node, this.typeSolver));
        for (int i = 0; i < node.getLevels().size(); ++i) {
            res = new ResolvedArrayType(res);
        }
        return res;
    }

    @Override
    public ResolvedType visit(ArrayInitializerExpr node, Boolean solveLambdas) {
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(AssignExpr node, Boolean solveLambdas) {
        return node.getTarget().accept(this, solveLambdas);
    }

    @Override
    public ResolvedType visit(BinaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MULTIPLY: 
            case REMAINDER: 
            case BINARY_AND: 
            case BINARY_OR: 
            case XOR: {
                return this.facade.getBinaryTypeConcrete(node.getLeft(), node.getRight(), solveLambdas, node.getOperator());
            }
            case LESS_EQUALS: 
            case LESS: 
            case GREATER: 
            case GREATER_EQUALS: 
            case EQUALS: 
            case NOT_EQUALS: 
            case OR: 
            case AND: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case SIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LEFT_SHIFT: {
                ResolvedType rt = node.getLeft().accept(this, solveLambdas);
                return ResolvedPrimitiveType.unp(rt);
            }
        }
        throw new UnsupportedOperationException("Operator " + node.getOperator().name());
    }

    @Override
    public ResolvedType visit(CastExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage(node.getType(), JavaParserFactory.getContext(node, this.typeSolver));
    }

    @Override
    public ResolvedType visit(ClassExpr node, Boolean solveLambdas) {
        ResolvedType jssType = this.facade.convertToUsage(node.getType());
        return new ReferenceTypeImpl(this.typeSolver.solveType(Class.class.getCanonicalName()), (List<ResolvedType>)ImmutableList.of((Object)jssType));
    }

    @Override
    public ResolvedType visit(ConditionalExpr node, Boolean solveLambdas) {
        ResolvedType thenExpr = node.getThenExpr().accept(this, solveLambdas);
        ResolvedType elseExpr = node.getElseExpr().accept(this, solveLambdas);
        ConditionalExprHandler rce = ConditionalExprResolver.getConditionExprHandler(thenExpr, elseExpr);
        try {
            return rce.resolveType();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return node.getThenExpr().accept(this, solveLambdas);
        }
    }

    private boolean isCompatible(ResolvedType resolvedType, ResolvedPrimitiveType primitiveType) {
        return resolvedType.isPrimitive() && resolvedType.asPrimitive().equals(primitiveType) || resolvedType.isReferenceType() && resolvedType.asReferenceType().isUnboxableTo(primitiveType);
    }

    @Override
    public ResolvedType visit(EnclosedExpr node, Boolean solveLambdas) {
        return node.getInner().accept(this, solveLambdas);
    }

    private ResolvedType solveDotExpressionType(ResolvedReferenceTypeDeclaration parentType, FieldAccessExpr node) {
        if (parentType.isEnum() && parentType.asEnum().hasEnumConstant(node.getName().getId())) {
            return parentType.asEnum().getEnumConstant(node.getName().getId()).getType();
        }
        if (parentType.hasField(node.getName().getId())) {
            return parentType.getField(node.getName().getId()).getType();
        }
        if (parentType.hasInternalType(node.getName().getId())) {
            return new ReferenceTypeImpl(parentType.getInternalType(node.getName().getId()));
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(FieldAccessExpr node, Boolean solveLambdas) {
        Optional<Object> value;
        block10: {
            SymbolReference<ResolvedReferenceTypeDeclaration> sr;
            if (node.getScope() instanceof NameExpr || node.getScope() instanceof FieldAccessExpr) {
                Expression staticValue = node.getScope();
                SymbolReference<ResolvedTypeDeclaration> typeAccessedStatically = JavaParserFactory.getContext(node, this.typeSolver).solveType(staticValue.toString());
                if (typeAccessedStatically.isSolved()) {
                    return this.solveDotExpressionType(typeAccessedStatically.getCorrespondingDeclaration().asReferenceType(), node);
                }
            } else if (node.getScope() instanceof ThisExpr) {
                ResolvedTypeDeclaration correspondingDeclaration;
                SymbolReference<ResolvedTypeDeclaration> solve = this.facade.solve((ThisExpr)node.getScope());
                if (solve.isSolved() && (correspondingDeclaration = solve.getCorrespondingDeclaration()) instanceof ResolvedReferenceTypeDeclaration) {
                    return this.solveDotExpressionType(correspondingDeclaration.asReferenceType(), node);
                }
            } else if (node.getScope().toString().indexOf(46) > 0 && (sr = this.typeSolver.tryToSolveType(node.getScope().toString())).isSolved()) {
                return this.solveDotExpressionType(sr.getCorrespondingDeclaration(), node);
            }
            value = Optional.empty();
            try {
                value = this.createSolver().solveSymbolAsValue(node.getName().getId(), node);
            }
            catch (UnsolvedSymbolException use) {
                SymbolReference<ResolvedReferenceTypeDeclaration> sref = this.typeSolver.tryToSolveType(node.toString());
                if (!sref.isSolved()) break block10;
                return new ReferenceTypeImpl(sref.getCorrespondingDeclaration());
            }
        }
        if (value.isPresent()) {
            return ((Value)value.get()).getType();
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(InstanceOfExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(StringLiteralExpr node, Boolean solveLambdas) {
        return this.stringReferenceType;
    }

    @Override
    public ResolvedType visit(IntegerLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.INT;
    }

    @Override
    public ResolvedType visit(LongLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.LONG;
    }

    @Override
    public ResolvedType visit(CharLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.CHAR;
    }

    @Override
    public ResolvedType visit(DoubleLiteralExpr node, Boolean solveLambdas) {
        if (node.getValue().toLowerCase().endsWith("f")) {
            return ResolvedPrimitiveType.FLOAT;
        }
        return ResolvedPrimitiveType.DOUBLE;
    }

    @Override
    public ResolvedType visit(BooleanLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(NullLiteralExpr node, Boolean solveLambdas) {
        return NullType.INSTANCE;
    }

    @Override
    public ResolvedType visit(MethodCallExpr node, Boolean solveLambdas) {
        Log.trace("getType on method call %s", (Supplier<Object> & Serializable)() -> node);
        MethodUsage ref = this.facade.solveMethodAsUsage(node);
        Log.trace("getType on method call %s resolved to %s", (Supplier<Object> & Serializable)() -> node, (Supplier<Object> & Serializable)() -> ref);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = (Supplier<Object> & Serializable)() -> node;
        supplierArray[1] = ref::returnType;
        Log.trace("getType on method call %s return type is %s", supplierArray);
        return ref.returnType();
    }

    @Override
    public ResolvedType visit(NameExpr node, Boolean solveLambdas) {
        Log.trace("getType on name expr %s", (Supplier<Object> & Serializable)() -> node);
        Optional<Value> value = this.createSolver().solveSymbolAsValue(node.getName().getId(), node);
        if (!value.isPresent()) {
            throw new UnsolvedSymbolException("Solving " + node, node.getName().getId());
        }
        return value.get().getType();
    }

    @Override
    public ResolvedType visit(TypeExpr node, Boolean solveLambdas) {
        Log.trace("getType on type expr %s", (Supplier<Object> & Serializable)() -> node);
        if (!(node.getType() instanceof ClassOrInterfaceType)) {
            throw new UnsupportedOperationException(node.getType().getClass().getCanonicalName());
        }
        ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)node.getType();
        String nameWithScope = classOrInterfaceType.getNameWithScope();
        SymbolReference<ResolvedTypeDeclaration> typeDeclarationSymbolReference = JavaParserFactory.getContext(classOrInterfaceType, this.typeSolver).solveType(nameWithScope);
        if (typeDeclarationSymbolReference.isSolved()) {
            return new ReferenceTypeImpl(typeDeclarationSymbolReference.getCorrespondingDeclaration().asReferenceType());
        }
        Optional<Value> value = this.createSolver().solveSymbolAsValue(nameWithScope, node);
        if (value.isPresent()) {
            return value.get().getType();
        }
        throw new UnsolvedSymbolException("Solving " + node, classOrInterfaceType.getName().getId());
    }

    @Override
    public ResolvedType visit(ObjectCreationExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage(node.getType());
    }

    @Override
    public ResolvedType visit(ThisExpr node, Boolean solveLambdas) {
        block3: {
            if (node.getTypeName().isPresent()) {
                String className = node.getTypeName().get().asString();
                try {
                    return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr(node, className)));
                }
                catch (IllegalStateException e) {
                    Optional cu = node.findAncestor(CompilationUnit.class);
                    SymbolReference<ResolvedReferenceTypeDeclaration> clazz = this.typeSolver.tryToSolveType(className);
                    if (!clazz.isSolved()) break block3;
                    return new ReferenceTypeImpl(clazz.getCorrespondingDeclaration());
                }
            }
        }
        return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr(node)));
    }

    @Override
    public ResolvedType visit(SuperExpr node, Boolean solveLambdas) {
        if (node.getTypeName().isPresent()) {
            String className = node.getTypeName().get().asString();
            SymbolReference<ResolvedTypeDeclaration> resolvedTypeNameRef = JavaParserFactory.getContext(node, this.typeSolver).solveType(className);
            if (resolvedTypeNameRef.isSolved()) {
                ResolvedTypeDeclaration resolvedTypeName = resolvedTypeNameRef.getCorrespondingDeclaration();
                if (resolvedTypeName.isInterface()) {
                    return new ReferenceTypeImpl(resolvedTypeName.asInterface());
                }
                if (resolvedTypeName.isClass()) {
                    return resolvedTypeName.asClass().getSuperClass().orElseThrow((Supplier<RuntimeException> & Serializable)() -> new RuntimeException("super class unexpectedly empty"));
                }
                throw new UnsupportedOperationException(node.getClass().getCanonicalName());
            }
            throw new UnsolvedSymbolException(className);
        }
        ResolvedReferenceTypeDeclaration typeOfNode = this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr(node));
        if (typeOfNode instanceof ResolvedClassDeclaration) {
            return ((ResolvedClassDeclaration)typeOfNode).getSuperClass().orElseThrow((Supplier<RuntimeException> & Serializable)() -> new RuntimeException("super class unexpectedly empty"));
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(UnaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case MINUS: 
            case PLUS: {
                return ResolvedPrimitiveType.unp(node.getExpression().accept(this, solveLambdas));
            }
            case LOGICAL_COMPLEMENT: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: 
            case BITWISE_COMPLEMENT: {
                return node.getExpression().accept(this, solveLambdas);
            }
        }
        throw new UnsupportedOperationException(node.getOperator().name());
    }

    @Override
    public ResolvedType visit(VariableDeclarationExpr node, Boolean solveLambdas) {
        if (node.getVariables().size() != 1) {
            throw new UnsupportedOperationException("TypeExtractor supports only one variable declaration in a variable declaration expression");
        }
        return this.facade.convertToUsage(((VariableDeclarator)node.getVariables().get(0)).getType());
    }

    @Override
    public ResolvedType visit(LambdaExpr node, Boolean solveLambdas) {
        Node parentNode = Navigator.demandParentNode(node, Expression.IS_NOT_ENCLOSED_EXPR);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)parentNode;
            int pos = TypeExtractor.getParamPos(node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(parentNode.toString(), callExpr.getName().getId());
            }
            Log.trace("getType on lambda expr %s", (Supplier<Object> & Serializable)() -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
            ResolvedType result = refMethod.getCorrespondingDeclaration().getParam(pos).getType();
            if (solveLambdas.booleanValue()) {
                if (callExpr.hasScope()) {
                    ResolvedType scopeType;
                    Expression scope = callExpr.getScope().get();
                    boolean staticCall = false;
                    if (scope instanceof NameExpr) {
                        NameExpr nameExpr = (NameExpr)scope;
                        try {
                            SymbolReference<ResolvedTypeDeclaration> type = JavaParserFactory.getContext(nameExpr, this.typeSolver).solveType(nameExpr.getName().getId());
                            if (type.isSolved()) {
                                staticCall = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!staticCall && (scopeType = this.facade.getType(scope)).isReferenceType()) {
                        result = scopeType.asReferenceType().useThisTypeParametersOnTheGivenType(result);
                    }
                }
                result = this.resolveLambda(node, result);
            }
            return result;
        }
        if (Navigator.demandParentNode(node) instanceof VariableDeclarator) {
            VariableDeclarator decExpr = (VariableDeclarator)Navigator.demandParentNode(node);
            ResolvedType result = decExpr.getType().resolve();
            if (solveLambdas.booleanValue()) {
                result = this.resolveLambda(node, result);
            }
            return result;
        }
        if (Navigator.demandParentNode(node) instanceof AssignExpr) {
            AssignExpr assExpr = (AssignExpr)Navigator.demandParentNode(node);
            ResolvedType result = assExpr.calculateResolvedType();
            if (solveLambdas.booleanValue()) {
                result = this.resolveLambda(node, result);
            }
            return result;
        }
        throw new UnsupportedOperationException("The type of a lambda expr depends on the position and its return value");
    }

    private ResolvedType resolveLambda(LambdaExpr node, ResolvedType result) {
        Context ctx = JavaParserFactory.getContext(node, this.typeSolver);
        Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(result = result.solveGenericTypes(ctx));
        if (functionalMethod.isPresent()) {
            ResolvedType actualType;
            LambdaExpr lambdaExpr = node;
            InferenceContext lambdaCtx = new InferenceContext(this.typeSolver);
            InferenceContext funcInterfaceCtx = new InferenceContext(this.typeSolver);
            ResolvedReferenceType functionalInterfaceType = ReferenceTypeImpl.undeterminedParameters(functionalMethod.get().getDeclaration().declaringType());
            lambdaCtx.addPair(result, functionalInterfaceType);
            if (lambdaExpr.getBody() instanceof ExpressionStmt) {
                actualType = this.facade.getType(((ExpressionStmt)lambdaExpr.getBody()).getExpression());
            } else if (lambdaExpr.getBody() instanceof BlockStmt) {
                BlockStmt blockStmt = (BlockStmt)lambdaExpr.getBody();
                List<ReturnStmt> returnStmts = blockStmt.findAll(ReturnStmt.class);
                if (returnStmts.size() > 0) {
                    Set<ResolvedType> resolvedTypes = returnStmts.stream().map((Function<ReturnStmt, ResolvedType> & Serializable)returnStmt -> returnStmt.getExpression().map((Function<Expression, ResolvedType> & Serializable)e -> this.facade.getType((Node)e)).orElse(ResolvedVoidType.INSTANCE)).collect(Collectors.toSet());
                    actualType = LeastUpperBoundLogic.of().lub(resolvedTypes);
                } else {
                    actualType = ResolvedVoidType.INSTANCE;
                }
            } else {
                throw new UnsupportedOperationException("Cannot resolve the type of lambda expression body " + lambdaExpr.getBody());
            }
            ResolvedType formalType = functionalMethod.get().returnType();
            funcInterfaceCtx.addPair(formalType, actualType);
            ResolvedType functionalTypeWithReturn = funcInterfaceCtx.resolve(funcInterfaceCtx.addSingle(functionalInterfaceType));
            if (!(formalType instanceof ResolvedVoidType)) {
                lambdaCtx.addPair(result, functionalTypeWithReturn);
                result = lambdaCtx.resolve(lambdaCtx.addSingle(result));
            }
        }
        return result;
    }

    @Override
    public ResolvedType visit(MethodReferenceExpr node, Boolean solveLambdas) {
        if ("new".equals(node.getIdentifier())) {
            return node.getScope().calculateResolvedType();
        }
        Node parentNode = Navigator.demandParentNode(node);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)parentNode;
            int pos = TypeExtractor.getParamPos(node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr, false);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(parentNode.toString(), callExpr.getName().getId());
            }
            Log.trace("getType on method reference expr %s", (Supplier<Object> & Serializable)() -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
            if (solveLambdas.booleanValue()) {
                MethodUsage usage = this.facade.solveMethodAsUsage(callExpr);
                ResolvedType result = usage.getParamType(pos);
                Context ctx = JavaParserFactory.getContext(node, this.typeSolver);
                Optional<MethodUsage> functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod(result = result.solveGenericTypes(ctx));
                if (functionalMethodOpt.isPresent()) {
                    MethodUsage functionalMethod = functionalMethodOpt.get();
                    for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> typeParamDecl : result.asReferenceType().getTypeParametersMap()) {
                        functionalMethod = functionalMethod.replaceTypeParameter((ResolvedTypeParameterDeclaration)typeParamDecl.a, (ResolvedType)typeParamDecl.b);
                    }
                    for (int i = 0; i < functionalMethod.getNoParams(); ++i) {
                        ResolvedType type = functionalMethod.getParamType(i);
                        if (!type.isWildcard()) continue;
                        ResolvedType boundedType = type.asWildcard().getBoundedType();
                        functionalMethod = functionalMethod.replaceParamType(i, boundedType);
                    }
                    ResolvedType actualType = this.facade.toMethodUsage(node, functionalMethod.getParamTypes()).returnType();
                    ResolvedType formalType = functionalMethod.returnType();
                    InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                    inferenceContext.addPair(formalType, actualType);
                    result = inferenceContext.resolve(inferenceContext.addSingle(result));
                }
                return result;
            }
            ResolvedMethodDeclaration rmd = refMethod.getCorrespondingDeclaration();
            if (rmd.hasVariadicParameter() && pos >= rmd.getNumberOfParams() - 1) {
                return rmd.getLastParam().getType().asArrayType().getComponentType();
            }
            return rmd.getParam(pos).getType();
        }
        throw new UnsupportedOperationException("The type of a method reference expr depends on the position and its return value");
    }

    @Override
    public ResolvedType visit(FieldDeclaration node, Boolean solveLambdas) {
        if (node.getVariables().size() == 1) {
            return ((VariableDeclarator)node.getVariables().get(0)).accept(this, solveLambdas);
        }
        throw new IllegalArgumentException("Cannot resolve the type of a field with multiple variable declarations. Pick one");
    }

    private static int getParamPos(Expression node) {
        Node parentNode = Navigator.demandParentNode(node, Expression.IS_NOT_ENCLOSED_EXPR);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr call = (MethodCallExpr)parentNode;
            return call.getArgumentPosition(node, Expression.EXCLUDE_ENCLOSED_EXPR);
        }
        throw new IllegalArgumentException();
    }

    protected Solver createSolver() {
        return new SymbolSolver(this.typeSolver);
    }
}

