/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.MethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.PatternExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithStatements;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.Statement;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.SymbolDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.Value;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.BlockStmtContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;

public class StatementContext<N extends Statement>
extends AbstractJavaParserContext<N> {
    public StatementContext(N wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    public static SymbolReference<? extends ResolvedValueDeclaration> solveInBlock(String name, TypeSolver typeSolver, Statement stmt) {
        int i;
        Optional<Node> optionalParentNode = stmt.getParentNode();
        if (!optionalParentNode.isPresent()) {
            return SymbolReference.unsolved();
        }
        Node parentOfWrappedNode = optionalParentNode.get();
        if (!(parentOfWrappedNode instanceof NodeWithStatements)) {
            throw new IllegalArgumentException();
        }
        NodeWithStatements blockStmt = (NodeWithStatements)((Object)parentOfWrappedNode);
        int position = -1;
        for (i = 0; i < blockStmt.getStatements().size(); ++i) {
            if (!((Statement)blockStmt.getStatements().get(i)).equals(stmt)) continue;
            position = i;
        }
        if (position == -1) {
            throw new RuntimeException();
        }
        for (i = position - 1; i >= 0; --i) {
            SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator((Node)blockStmt.getStatements().get(i), typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = StatementContext.solveWith(symbolDeclarator, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return JavaParserFactory.getContext(parentOfWrappedNode, typeSolver).solveSymbol(name);
    }

    public static Optional<Value> solveInBlockAsValue(String name, TypeSolver typeSolver, Statement stmt) {
        int i;
        Optional<Node> optionalParentNode = stmt.getParentNode();
        if (!optionalParentNode.isPresent()) {
            return Optional.empty();
        }
        Node parentOfWrappedNode = optionalParentNode.get();
        if (!(parentOfWrappedNode instanceof NodeWithStatements)) {
            throw new IllegalArgumentException();
        }
        NodeWithStatements blockStmt = (NodeWithStatements)((Object)parentOfWrappedNode);
        int position = -1;
        for (i = 0; i < blockStmt.getStatements().size(); ++i) {
            if (!((Statement)blockStmt.getStatements().get(i)).equals(stmt)) continue;
            position = i;
        }
        if (position == -1) {
            throw new RuntimeException();
        }
        for (i = position - 1; i >= 0; --i) {
            SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator((Node)blockStmt.getStatements().get(i), typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = StatementContext.solveWith(symbolDeclarator, name);
            if (!symbolReference.isSolved()) continue;
            return Optional.of(Value.from(symbolReference.getCorrespondingDeclaration()));
        }
        return JavaParserFactory.getContext(parentOfWrappedNode, typeSolver).solveSymbolAsValue(name);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name) {
        SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator(this.wrappedNode, this.typeSolver);
        Optional<Value> symbolReference = this.solveWithAsValue(symbolDeclarator, name);
        if (symbolReference.isPresent()) {
            return symbolReference;
        }
        if (!this.getParent().isPresent()) {
            return Optional.empty();
        }
        Context parentContext = this.getParent().get();
        Optional<Node> optionalParentNode = ((Statement)this.wrappedNode).getParentNode();
        if (!optionalParentNode.isPresent()) {
            return Optional.empty();
        }
        Node parentOfWrappedNode = optionalParentNode.get();
        if (parentOfWrappedNode instanceof MethodDeclaration) {
            return parentContext.solveSymbolAsValue(name);
        }
        if (parentOfWrappedNode instanceof LambdaExpr) {
            return parentContext.solveSymbolAsValue(name);
        }
        if (!(parentOfWrappedNode instanceof NodeWithStatements)) {
            return parentContext.solveSymbolAsValue(name);
        }
        NodeWithStatements nodeWithStmt = (NodeWithStatements)((Object)parentOfWrappedNode);
        int position = -1;
        for (int i = 0; i < nodeWithStmt.getStatements().size(); ++i) {
            if (!((Statement)nodeWithStmt.getStatements().get(i)).equals(this.wrappedNode)) continue;
            position = i;
        }
        if (position == -1) {
            throw new RuntimeException();
        }
        for (int statementIndex = position - 1; statementIndex >= 0; --statementIndex) {
            Statement statement = (Statement)nodeWithStmt.getStatements().get(statementIndex);
            symbolDeclarator = JavaParserFactory.getSymbolDeclarator(statement, this.typeSolver);
            symbolReference = this.solveWithAsValue(symbolDeclarator, name);
            if (!symbolReference.isPresent()) continue;
            return symbolReference;
        }
        return parentContext.getParent().map((Function<Context, Optional> & Serializable)context -> context.solveSymbolAsValue(name)).orElse(Optional.empty());
    }

    @Override
    protected Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        return super.solveWithAsValue(symbolDeclarator, name);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        return this.solveSymbol(name, true);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, boolean iterateAdjacentStmts) {
        SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator(this.wrappedNode, this.typeSolver);
        SymbolReference<ResolvedValueDeclaration> symbolReference = StatementContext.solveWith(symbolDeclarator, name);
        if (symbolReference.isSolved()) {
            return symbolReference;
        }
        List<PatternExpr> patternExprs = this.patternExprsExposedFromChildren();
        for (int i = 0; i < patternExprs.size(); ++i) {
            PatternExpr patternExpr = patternExprs.get(i);
            if (!patternExpr.getNameAsString().equals(name)) continue;
            return SymbolReference.solved(JavaParserSymbolDeclaration.patternVar(patternExpr, this.typeSolver));
        }
        Optional<Node> optionalParentNode = ((Statement)this.wrappedNode).getParentNode();
        if (!optionalParentNode.isPresent()) {
            return SymbolReference.unsolved();
        }
        Node parentOfWrappedNode = optionalParentNode.get();
        if (parentOfWrappedNode instanceof MethodDeclaration) {
            return this.solveSymbolInParentContext(name);
        }
        if (parentOfWrappedNode instanceof ConstructorDeclaration) {
            return this.solveSymbolInParentContext(name);
        }
        if (parentOfWrappedNode instanceof LambdaExpr) {
            return this.solveSymbolInParentContext(name);
        }
        if (parentOfWrappedNode instanceof NodeWithStatements) {
            if (!iterateAdjacentStmts) {
                return SymbolReference.unsolved();
            }
            NodeWithStatements nodeWithStmt = (NodeWithStatements)((Object)parentOfWrappedNode);
            int position = nodeWithStmt.getStatements().indexOf(this.wrappedNode);
            if (position == -1) {
                throw new IllegalStateException("This node is not a statement within the current NodeWithStatements");
            }
            ListIterator<Statement> statementListIterator = nodeWithStmt.getStatements().listIterator(position);
            while (statementListIterator.hasPrevious()) {
                Context prevContext = JavaParserFactory.getContext(statementListIterator.previous(), this.typeSolver);
                if (prevContext instanceof BlockStmtContext || !(symbolReference = prevContext instanceof StatementContext ? ((StatementContext)prevContext).solveSymbol(name, false) : prevContext.solveSymbol(name)).isSolved()) continue;
                return symbolReference;
            }
        }
        return this.solveSymbolInParentContext(name);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return this.solveMethodInParentContext(name, argumentsTypes, false);
    }

    @Override
    public List<PatternExpr> patternExprsExposedFromChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<PatternExpr> negatedPatternExprsExposedFromChildren() {
        return Collections.emptyList();
    }
}

