/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;
import org.javamodularity.moduleplugin.JavaProjectHelper;

class ModuleInfoTestHelper {
    private static final Logger LOGGER = Logging.getLogger(ModuleInfoTestHelper.class);

    ModuleInfoTestHelper() {
    }

    static void mutateArgs(Project project, boolean excludeOpens, Consumer<String> consumer) {
        JavaProjectHelper helper = new JavaProjectHelper(project);
        String moduleName = helper.moduleName();
        SourceSet testSourceSet = helper.testSourceSet();
        FileTree files = testSourceSet.getAllSource().matching((Action & Serializable)f -> f.include(new String[]{"module-info.test"}));
        if (files.isEmpty()) {
            LOGGER.info("File 'module-info.test' is not present in {}", (Object)project);
            return;
        }
        Path moduleInfoTestPath = files.getSingleFile().toPath();
        LOGGER.info("Using lines of '{}' to patch module {}...", (Object)moduleInfoTestPath, (Object)moduleName);
        try (Stream lines = NioFileInterceptors.intercept_lines((Path)moduleInfoTestPath, (String)"org.javamodularity.moduleplugin.tasks.ModuleInfoTestHelper");){
            ModuleInfoTestHelper.consumeLines(lines, excludeOpens, consumer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Reading " + moduleInfoTestPath + " failed", e);
        }
    }

    static void consumeLines(Stream<String> s, boolean excludeOpens, Consumer<String> consumer) {
        List<String> lines = s.map(String::trim).filter((Predicate<String> & Serializable)line -> !line.isBlank()).filter((Predicate<String> & Serializable)line -> !line.startsWith("//")).collect(Collectors.toList());
        if (excludeOpens) {
            ModuleInfoTestHelper.excludeOpens(lines);
        }
        lines.stream().peek((Consumer<String> & Serializable)line -> LOGGER.debug("  {}", line)).forEach(consumer);
    }

    private static void excludeOpens(List<String> lines) {
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!next.equals("--add-opens")) continue;
            it.remove();
            if (!it.hasNext()) continue;
            String opens = it.next();
            LOGGER.debug("  Excluding --add-opens {}", (Object)opens);
            it.remove();
        }
    }
}

