/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.views;

import java.util.Optional;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;

public class ViewLoaderResult {
    private final Parent view;
    private final Object controller;
    private ResourceBundle bundle;

    public ViewLoaderResult(Parent view, Object controller, ResourceBundle bundle) {
        this.view = view;
        this.controller = controller;
        this.bundle = bundle;
    }

    public Optional<Node> getViewWithoutRootContainer() {
        return this.getView().getChildrenUnmodifiable().stream().findFirst();
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public Parent getView() {
        return this.view;
    }

    public Object getController() {
        return this.controller;
    }

    public void setAsContent(DialogPane dialogPane) {
        dialogPane.setContent((Node)this.view);
    }

    public <T> void setAsDialogPane(Dialog<T> dialog) {
        if (!(this.view instanceof DialogPane)) {
            throw new IllegalStateException("View " + this.view.getClass().getName() + " has to derive from DialogPane");
        }
        dialog.setDialogPane((DialogPane)this.view);
    }
}

