/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LaTeXIndenter {
    public static final int DEFAULT_INDENT_WIDTH = 2;
    public static final int DEFAULT_MAX_INDENT_LEVEL = 10;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String BEGIN = "\\begin";
    private static final String END = "\\end";
    private static final Pattern BEGIN_PATTERN = Pattern.compile("\\\\begin\\s*+\\{(.+?)\\}");
    private static final Pattern END_PATTERN = Pattern.compile("\\\\end\\s*+\\{(.+?)\\}");
    private final Writer outputWriter;
    private int indentWidth;
    private int maxIndentLevel;
    private boolean compactingBlankLines;
    private int blankLineCount;
    private int indentLevel;
    private boolean verbatimMode;
    private ParsingState parsingState;

    public LaTeXIndenter(Writer outputWriter) {
        this.outputWriter = outputWriter;
        this.indentWidth = 2;
        this.maxIndentLevel = 10;
        this.compactingBlankLines = true;
        this.reset();
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public void setIndentWidth(int indentWidth) {
        if (indentWidth < 0) {
            throw new IllegalArgumentException("indentWidth must be non-negative");
        }
        this.indentWidth = indentWidth;
    }

    public int getMaxIndentLevel() {
        return this.maxIndentLevel;
    }

    public void setMaxIndentLevel(int maxIndentLevel) {
        if (maxIndentLevel < 0) {
            throw new IllegalArgumentException("maxIndentLevel must be non-negative");
        }
        this.maxIndentLevel = maxIndentLevel;
    }

    public boolean isCompactingBlankLines() {
        return this.compactingBlankLines;
    }

    public void setCompactingBlankLines(boolean condenseBlankLines) {
        this.compactingBlankLines = condenseBlankLines;
    }

    public void reset() {
        this.indentLevel = 0;
        this.verbatimMode = false;
        this.blankLineCount = 0;
        this.parsingState = ParsingState.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Reader inputReader) throws IOException {
        this.reset();
        BufferedReader reader = inputReader instanceof BufferedReader ? (BufferedReader)inputReader : new BufferedReader(inputReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.handleLine(line);
            }
        }
        finally {
            inputReader.close();
        }
    }

    private void handleLine(String line) throws IOException {
        line = line.replace(LINE_SEPARATOR, "");
        if (!this.verbatimMode) {
            line = line.trim();
        }
        boolean isBlankLine = !this.verbatimMode && line.length() == 0;
        switch (this.parsingState) {
            case DEFAULT: {
                if (isBlankLine) {
                    this.parsingState = ParsingState.EMPTY_LINES;
                    ++this.blankLineCount;
                    break;
                }
                this.handleLineInDefaultState(line);
                break;
            }
            case EMPTY_LINES: {
                if (isBlankLine) {
                    ++this.blankLineCount;
                    break;
                }
                this.outputWriter.write(LINE_SEPARATOR);
                if (!this.compactingBlankLines) {
                    for (int i = 1; i < this.blankLineCount; ++i) {
                        this.outputWriter.write(LINE_SEPARATOR);
                    }
                }
                this.blankLineCount = 0;
                this.parsingState = ParsingState.DEFAULT;
                this.handleLineInDefaultState(line);
                break;
            }
            case BEGIN_DECLARATION: {
                if (isBlankLine) break;
                this.parsingState = ParsingState.DEFAULT;
                this.handleLineInDefaultState(BEGIN + line);
                break;
            }
            case END_DECLARATION: {
                if (isBlankLine) break;
                this.parsingState = ParsingState.DEFAULT;
                this.handleLineInDefaultState(END + line);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected switch case " + (Object)((Object)this.parsingState));
            }
        }
    }

    private void handleLineInDefaultState(String line) throws IOException {
        if (line.endsWith(BEGIN)) {
            this.handleLineFragmentInDefaultState(line.substring(0, line.length() - BEGIN.length()));
            this.parsingState = ParsingState.BEGIN_DECLARATION;
        } else if (line.endsWith(END)) {
            this.handleLineFragmentInDefaultState(line.substring(0, line.length() - END.length()));
            this.parsingState = ParsingState.END_DECLARATION;
        } else {
            this.handleLineFragmentInDefaultState(line);
        }
    }

    private void handleLineFragmentInDefaultState(String line) throws IOException {
        boolean initialUnindent = false;
        if (!this.verbatimMode) {
            if (line.startsWith(END)) {
                initialUnindent = true;
                --this.indentLevel;
            }
            this.createIndent(this.indentLevel);
        }
        this.outputWriter.write(line);
        this.outputWriter.write(LINE_SEPARATOR);
        Matcher matcher = END_PATTERN.matcher(line);
        while (matcher.find()) {
            if (!this.verbatimMode) {
                --this.indentLevel;
                continue;
            }
            if (!matcher.group(1).equals("verbatim")) continue;
            this.verbatimMode = false;
        }
        if (initialUnindent) {
            ++this.indentLevel;
        }
        matcher = BEGIN_PATTERN.matcher(line);
        while (matcher.find()) {
            if (this.verbatimMode) continue;
            if (matcher.group(1).equals("verbatim")) {
                this.verbatimMode = true;
                continue;
            }
            ++this.indentLevel;
        }
    }

    private void createIndent(int level) throws IOException {
        if (level > this.maxIndentLevel) {
            level = this.maxIndentLevel;
        }
        int toIndent = level * this.indentWidth;
        for (int i = 0; i < toIndent; ++i) {
            this.outputWriter.write(32);
        }
    }

    private static enum ParsingState {
        DEFAULT,
        EMPTY_LINES,
        BEGIN_DECLARATION,
        END_DECLARATION;

    }
}

