/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.DOMPostProcessor;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public abstract class MathMLPostProcessor
implements DOMPostProcessor {
    @Override
    public final Document postProcessDOM(Document workDocument, DOMOutputOptions options, StylesheetManager stylesheetManager) {
        Document resultDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        new DocumentWalker(workDocument, resultDocument).run();
        return resultDocument;
    }

    protected abstract void handleMathMLIsland(Element var1, Document var2, Node var3, int var4);

    private class DocumentWalker {
        private int mathmlCounter;
        private final Document inputDocument;
        private final Document outputDocument;
        private Node inputNode;
        private Node outputParentNode;

        public DocumentWalker(Document inputDocument, Document outputDocument) {
            this.inputDocument = inputDocument;
            this.outputDocument = outputDocument;
        }

        public void run() {
            this.outputParentNode = this.outputDocument;
            this.inputNode = this.inputDocument.getFirstChild();
            this.mathmlCounter = 0;
            while (this.inputNode != null) {
                if (MathMLUtilities.isMathMLElement(this.inputNode, "math")) {
                    MathMLPostProcessor.this.handleMathMLIsland((Element)this.inputNode, this.outputDocument, this.outputParentNode, this.mathmlCounter++);
                } else {
                    Node outputNode = this.outputDocument.adoptNode(this.inputNode.cloneNode(false));
                    this.outputParentNode.appendChild(outputNode);
                    if (this.inputNode.hasChildNodes()) {
                        this.inputNode = this.inputNode.getFirstChild();
                        this.outputParentNode = outputNode;
                        continue;
                    }
                }
                Node nextSibling = this.inputNode.getNextSibling();
                while (nextSibling == null) {
                    this.inputNode = this.inputNode.getParentNode();
                    if (this.inputNode == null) break;
                    nextSibling = this.inputNode.getNextSibling();
                    this.outputParentNode = this.outputParentNode.getParentNode();
                }
                this.inputNode = nextSibling;
            }
        }
    }
}

