/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public class ASN1Integer
implements ASN1TaggedObject {
    private ASN1Header a;
    private byte[] b;

    public ASN1Integer(BigInteger bigInteger) {
        this.a(bigInteger);
    }

    public ASN1Integer(BigInt bigInt) {
        this.a(bigInt);
    }

    public ASN1Integer(long l) {
        BigInt bigInt = BigInt.valueOf(l);
        this.a(bigInt);
        bigInt.erase();
    }

    public ASN1Integer(InputStream inputStream) throws IOException {
        this.a(ASN1Integer.inputByteArrayValue(inputStream));
    }

    public void erase() {
        if (this.b != null) {
            Utils.setArray(this.b, (byte)0);
        }
    }

    public void finalize() {
        this.erase();
    }

    private void a(BigInteger bigInteger) {
        this.b = bigInteger.toByteArray();
        this.a = new ASN1Header(2, 0, 0, ASN1Integer.b(bigInteger));
    }

    private void a(BigInt bigInt) {
        this.b = bigInt.toByteArray();
        this.a = new ASN1Header(2, 0, 0, ASN1Integer.b(bigInt));
    }

    private void a(byte[] byArray) {
        this.b = byArray;
        this.a = new ASN1Header(2, 0, 0, ASN1Integer.b(byArray));
    }

    @Override
    public ASN1Header getHeader() {
        return this.a;
    }

    public BigInteger getValue() {
        return new BigInteger(this.b);
    }

    public BigInt getBigIntValue() {
        return new BigInt(this.b);
    }

    public int intValue() {
        BigInt bigInt = new BigInt(this.b);
        int n = bigInt.intValue();
        bigInt.erase();
        return n;
    }

    public long longValue() {
        BigInt bigInt = new BigInt(this.b);
        long l = bigInt.longValue();
        bigInt.erase();
        return l;
    }

    public boolean equals(int n) {
        return this.intValue() == n;
    }

    public String toString() {
        BigInt bigInt = new BigInt(this.b);
        String string = "INTEGER " + bigInt.toString();
        bigInt.erase();
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(ASN1Integer.inputByteArrayValue(inputStream));
    }

    public static byte[] inputByteArrayValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return aSN1Header.readBody(inputStream);
    }

    public static BigInteger inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return new BigInteger(aSN1Header.readBody(inputStream));
    }

    public static BigInt inputBigIntValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return new BigInt(aSN1Header.readBody(inputStream));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        outputStream.write(this.b);
    }

    @Override
    public int length() {
        return this.a.totalLength();
    }

    public static void outputValue(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        ASN1Integer.a(outputStream, bigInteger, 2, 0);
    }

    private static void a(OutputStream outputStream, BigInt bigInt) throws IOException {
        ASN1Integer.a(outputStream, bigInt, 2, 0);
    }

    public static void outputValue(OutputStream outputStream, int n) throws IOException {
        BigInt bigInt = BigInt.valueOf(n);
        ASN1Integer.a(outputStream, bigInt);
        bigInt.erase();
    }

    public static void outputValueWithTag(OutputStream outputStream, BigInteger bigInteger, int n) throws IOException {
        ASN1Integer.a(outputStream, bigInteger, n, 128);
    }

    private static int b(BigInteger bigInteger) {
        return bigInteger.bitLength() / 8 + 1;
    }

    private static int b(BigInt bigInt) {
        return bigInt.bitLength() / 8 + 1;
    }

    private static int b(byte[] byArray) {
        BigInt bigInt = new BigInt(byArray);
        int n = bigInt.bitLength() / 8 + 1;
        bigInt.erase();
        return n;
    }

    private static void a(OutputStream outputStream, BigInteger bigInteger, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, ASN1Integer.b(bigInteger));
        outputStream.write(bigInteger.toByteArray());
    }

    private static void a(OutputStream outputStream, BigInt bigInt, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, ASN1Integer.b(bigInt));
        outputStream.write(bigInt.toByteArray());
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

