/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.ImmutablePropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListImmutableSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ImmutableListPropertyField<M, E, T extends ObservableList<E>, R extends Property<T>>
implements ImmutablePropertyField<T, M, R> {
    private final ListGetter<M, E> getter;
    private final ListImmutableSetter<M, E> immutableSetter;
    private List<E> defaultValue;
    private final ListProperty<E> targetProperty;

    public ImmutableListPropertyField(SideEffect updateFunction, ListGetter<M, E> getter, ListImmutableSetter<M, E> immutableSetter, Supplier<ListProperty<E>> propertySupplier) {
        this(updateFunction, getter, immutableSetter, propertySupplier, Collections.emptyList());
    }

    public ImmutableListPropertyField(SideEffect updateFunction, ListGetter<M, E> getter, ListImmutableSetter<M, E> immutableSetter, Supplier<ListProperty<E>> propertySupplier, List<E> defaultValue) {
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.immutableSetter = immutableSetter;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableArrayList());
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
    }

    @Override
    public M commitImmutable(M wrappedObject) {
        return this.immutableSetter.apply(wrappedObject, (List<E>)this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        this.targetProperty.setAll((Collection)this.getter.apply((Object)wrappedObject));
    }

    @Override
    public void resetToDefault() {
        this.targetProperty.setAll(this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new ArrayList(this.getter.apply((Object)wrappedObject));
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        ListProperty<E> wrapperValue;
        Object modelValue = this.getter.apply((Object)wrappedObject);
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty);
    }
}

