/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.beans.NamedArg;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;

public class StyleClassedTextArea
extends StyledTextArea<Collection<String>, Collection<String>> {
    public StyleClassedTextArea(@NamedArg(value="document") EditableStyledDocument<Collection<String>, String, Collection<String>> document, @NamedArg(value="preserveStyle") boolean preserveStyle) {
        super(Collections.emptyList(), (TextFlow paragraph, PS styleClasses) -> paragraph.getStyleClass().addAll(styleClasses), Collections.emptyList(), (? super TextExt text, S styleClasses) -> text.getStyleClass().addAll(styleClasses), document, preserveStyle);
        this.setStyleCodecs(Codec.collectionCodec(Codec.STRING_CODEC), Codec.styledTextCodec(Codec.collectionCodec(Codec.STRING_CODEC)));
    }

    public StyleClassedTextArea(@NamedArg(value="preserveStyle") boolean preserveStyle) {
        this(new SimpleEditableStyledDocument<Collection<String>, Collection<String>>(Collections.emptyList(), Collections.emptyList()), preserveStyle);
    }

    public StyleClassedTextArea() {
        this(true);
    }

    @Override
    public void append(String text, String styleClass) {
        this.insert(this.getLength(), text, styleClass);
    }

    @Override
    public void insert(int position, String text, String styleClass) {
        this.replace(position, position, text, Collections.singleton(styleClass));
    }

    @Override
    public void replace(int start, int end, String text, String styleClass) {
        this.replace(start, end, text, Collections.singleton(styleClass));
    }

    public void setStyleClass(int from, int to, String styleClass) {
        this.setStyle(from, to, Collections.singletonList(styleClass));
    }

    public void foldParagraphs(int startPar, int endPar) {
        this.foldParagraphs(startPar, endPar, this.getAddFoldStyle());
    }

    public void foldSelectedParagraphs() {
        this.foldSelectedParagraphs(this.getAddFoldStyle());
    }

    public void foldText(int start, int end) {
        this.fold(start, end, this.getAddFoldStyle());
    }

    public boolean isFolded(int paragraph) {
        return this.getFoldStyleCheck().test((Collection)this.getParagraph(paragraph).getParagraphStyle());
    }

    public void unfoldParagraphs(int startingFromPar) {
        this.unfoldParagraphs(startingFromPar, this.getFoldStyleCheck(), this.getRemoveFoldStyle());
    }

    public void unfoldText(int startingFromPos) {
        startingFromPos = this.offsetToPosition(startingFromPos, TwoDimensional.Bias.Backward).getMajor();
        this.unfoldParagraphs(startingFromPos, this.getFoldStyleCheck(), this.getRemoveFoldStyle());
    }

    protected Predicate<Collection<String>> getFoldStyleCheck() {
        return styleList -> styleList != null && styleList.contains("collapse");
    }

    protected UnaryOperator<Collection<String>> getAddFoldStyle() {
        return styleList -> {
            styleList = new ArrayList<String>((Collection<String>)styleList);
            styleList.add("collapse");
            return styleList;
        };
    }

    protected UnaryOperator<Collection<String>> getRemoveFoldStyle() {
        return styleList -> {
            styleList = new ArrayList(styleList);
            styleList.remove("collapse");
            return styleList;
        };
    }
}

