/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

public class MinMaxAvgFloat {
    private float min = Float.MAX_VALUE;
    private float max = Float.MIN_VALUE;
    private float total = 0.0f;

    public void add(float value) {
        this.total += value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void add(MinMaxAvgFloat other) {
        this.total += other.total;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    public void diff(float start, float end) {
        this.add(end - start);
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getTotal() {
        return this.total;
    }

    public float getAvg(float count) {
        return count == 0.0f ? 0.0f : this.total / count;
    }
}

