/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.skins.TimePickerSkin;
import java.time.LocalTime;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;

public class TimePicker
extends CustomComboBox<LocalTime> {
    private final ReadOnlyBooleanWrapper adjusted = new ReadOnlyBooleanWrapper((Object)this, "adjusted");
    private final ObjectProperty<LocalTime> earliestTime = new SimpleObjectProperty((Object)this, "earliestTime", (Object)LocalTime.MIN);
    private final ObjectProperty<LocalTime> latestTime = new SimpleObjectProperty((Object)this, "latestTime", (Object)LocalTime.MAX);
    private final ObjectProperty<Node> hoursSeparator = new SimpleObjectProperty((Object)this, "separator");
    private final BooleanProperty showPopupTriggerButton = new SimpleBooleanProperty((Object)this, "showPopupTriggerButton", true);
    private boolean adjustmentInProgress;
    private final ObjectProperty<LocalTime> time = new SimpleObjectProperty((Object)this, "time");
    private final IntegerProperty stepRateInMinutes = new SimpleIntegerProperty((Object)this, "stepRateInMinutes", 1);
    private final ObjectProperty<ClockType> clockType = new SimpleObjectProperty((Object)this, "clockType", (Object)ClockType.TWENTY_FOUR_HOUR_CLOCK);
    private final BooleanProperty linkingFields = new SimpleBooleanProperty((Object)this, "linkingFields", true);
    private final BooleanProperty rollover = new SimpleBooleanProperty((Object)this, "rollOver", true);
    private final ObjectProperty<Consumer<TimePicker>> onShowPopup = new SimpleObjectProperty((Object)this, "onShowPopup");
    private final ObjectProperty<Format> format = new SimpleObjectProperty((Object)this, "format", (Object)Format.HOURS_MINUTES);
    private final ObjectProperty<Node> minutesSeparator = new SimpleObjectProperty((Object)this, "minuteSeparator");
    private final ObjectProperty<Node> secondsSeparator = new SimpleObjectProperty((Object)this, "secondsSeparator");

    public TimePicker() {
        this.getStyleClass().setAll((Object[])new String[]{"time-picker", "text-input"});
        this.setFocusTraversable(false);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.hoursSeparatorProperty().addListener(it -> {
            if (this.getHoursSeparator() == null) {
                throw new IllegalArgumentException("hour separator can not be null");
            }
        });
        this.minutesSeparatorProperty().addListener(it -> {
            if (this.getMinutesSeparator() == null) {
                throw new IllegalArgumentException("minutes separator can not be null");
            }
        });
        this.secondsSeparatorProperty().addListener(it -> {
            if (this.getSecondsSeparator() == null) {
                throw new IllegalArgumentException("seconds separator can not be null");
            }
        });
        Label hourSeparator = new Label(":");
        hourSeparator.getStyleClass().add((Object)"separator");
        this.setHoursSeparator((Node)hourSeparator);
        Label minutesSeparator = new Label(":");
        minutesSeparator.getStyleClass().add((Object)"separator");
        this.setMinutesSeparator((Node)minutesSeparator);
        Label secondsSeparator = new Label(".");
        secondsSeparator.getStyleClass().add((Object)"separator");
        this.setSecondsSeparator((Node)secondsSeparator);
        this.setTime(LocalTime.now());
        this.earliestTimeProperty().addListener(it -> {
            LocalTime earliestTime = this.getEarliestTime();
            if (earliestTime.isAfter(this.getLatestTime())) {
                throw new IllegalArgumentException("earliest time can not be after the latest time, earliest = " + earliestTime + ", latest time = " + this.getLatestTime());
            }
            this.adjust();
        });
        this.latestTimeProperty().addListener(it -> {
            LocalTime latestTime = this.getLatestTime();
            if (latestTime.isBefore(this.getEarliestTime())) {
                throw new IllegalArgumentException("latest time can not be before the earliest time, latest = " + latestTime + ", earliest = " + this.getEarliestTime());
            }
            this.adjust();
        });
        this.stepRateInMinutesProperty().addListener(it -> {
            int stepRateInMinutes = this.getStepRateInMinutes();
            if (stepRateInMinutes < 1) {
                throw new IllegalArgumentException("step rate can not be smaller than 0 minutes but was " + stepRateInMinutes);
            }
            if (stepRateInMinutes > 60) {
                throw new IllegalArgumentException("step rate can not be larger than 60 minutes but was " + stepRateInMinutes);
            }
            this.adjust();
        });
        this.setOnKeyPressed(evt -> {
            if (evt.getCode().equals((Object)KeyCode.F4) || evt.getCode().equals((Object)KeyCode.ENTER)) {
                this.getOnShowPopup().accept(this);
            }
        });
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded()) {
                if (change.getKey().equals("ADJUST_TIME")) {
                    this.adjust();
                    this.getProperties().remove((Object)"ADJUST_TIME");
                } else if (change.getKey().equals("CLEAR_ADJUSTED_TIME")) {
                    this.adjusted.set(false);
                    this.getProperties().remove((Object)"CLEAR_ADJUSTED_TIME");
                } else if (change.getKey().equals("NEW_TIME")) {
                    this.adjustmentInProgress = true;
                    try {
                        this.setTime((LocalTime)change.getValueAdded());
                    }
                    finally {
                        this.getProperties().remove((Object)"NEW_TIME");
                        this.adjustmentInProgress = false;
                    }
                }
            }
        };
        this.getProperties().addListener(propertiesListener);
        this.timeProperty().addListener(it -> {
            if (!this.adjustmentInProgress) {
                this.adjusted.set(false);
            }
        });
        this.setOnShowPopup(picker -> this.show());
    }

    public final boolean isAdjusted() {
        return this.adjusted.get();
    }

    public final ReadOnlyBooleanProperty adjustedProperty() {
        return this.adjusted.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new TimePickerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(TimePicker.class.getResource("time-picker.css")).toExternalForm();
    }

    public final LocalTime getEarliestTime() {
        return (LocalTime)this.earliestTime.get();
    }

    public final ObjectProperty<LocalTime> earliestTimeProperty() {
        return this.earliestTime;
    }

    public final void setEarliestTime(LocalTime earliestTime) {
        this.earliestTime.set((Object)earliestTime);
    }

    public final LocalTime getLatestTime() {
        return (LocalTime)this.latestTime.get();
    }

    public final ObjectProperty<LocalTime> latestTimeProperty() {
        return this.latestTime;
    }

    public final void setLatestTime(LocalTime latestTime) {
        this.latestTime.set((Object)latestTime);
    }

    @Deprecated
    public final Node getSeparator() {
        return (Node)this.hoursSeparator.get();
    }

    @Deprecated
    public final ObjectProperty<Node> separatorProperty() {
        return this.hoursSeparator;
    }

    @Deprecated
    public final void setSeparator(Node separator) {
        this.hoursSeparator.set((Object)separator);
    }

    public final Node getHoursSeparator() {
        return (Node)this.hoursSeparator.get();
    }

    public final ObjectProperty<Node> hoursSeparatorProperty() {
        return this.hoursSeparator;
    }

    public final void setHoursSeparator(Node separator) {
        this.hoursSeparator.set((Object)separator);
    }

    public final boolean isShowPopupTriggerButton() {
        return this.showPopupTriggerButton.get();
    }

    public final BooleanProperty showPopupTriggerButtonProperty() {
        return this.showPopupTriggerButton;
    }

    public final void setShowPopupTriggerButton(boolean showPopupTriggerButton) {
        this.showPopupTriggerButton.set(showPopupTriggerButton);
    }

    public final void adjust() {
        this.adjustmentInProgress = true;
        try {
            boolean adjusted;
            boolean bl = adjusted = this.adjustViaTimeBounds() || this.adjustViaStepRate();
            if (adjusted) {
                this.adjusted.set(true);
            }
        }
        finally {
            this.adjustmentInProgress = false;
        }
    }

    private boolean adjustViaTimeBounds() {
        LocalTime time = this.getTime();
        if (time != null) {
            boolean adjusted;
            LocalTime earliestTime = this.getEarliestTime();
            LocalTime latestTime = this.getLatestTime();
            int hour = time.getHour();
            int minute = time.getMinute();
            int second = time.getSecond();
            int nano = time.getNano();
            LocalTime newTime = LocalTime.of(hour, minute, second, nano);
            if (time.isBefore(earliestTime)) {
                if (hour < earliestTime.getHour()) {
                    newTime = newTime.withHour(earliestTime.getHour());
                }
                if (newTime.isBefore(earliestTime)) {
                    newTime = newTime.withMinute(earliestTime.getMinute());
                }
                if (newTime.isBefore(latestTime)) {
                    newTime = newTime.withSecond(earliestTime.getSecond());
                }
                if (newTime.isBefore(latestTime)) {
                    newTime = newTime.withNano(earliestTime.getNano());
                }
            } else if (time.isAfter(latestTime)) {
                if (hour > latestTime.getHour()) {
                    newTime = newTime.withHour(latestTime.getHour());
                }
                if (newTime.isAfter(latestTime)) {
                    newTime = newTime.withMinute(latestTime.getMinute());
                }
                if (newTime.isAfter(latestTime)) {
                    newTime = newTime.withSecond(latestTime.getSecond());
                }
                if (newTime.isAfter(latestTime)) {
                    newTime = newTime.withNano(latestTime.getNano());
                }
            }
            boolean bl = adjusted = newTime.getHour() != time.getHour() || newTime.getMinute() != time.getMinute() || newTime.getSecond() != time.getSecond() || newTime.getNano() != time.getNano();
            if (adjusted) {
                this.setTime(newTime);
            }
            return adjusted;
        }
        return false;
    }

    private boolean adjustViaStepRate() {
        LocalTime time = this.getTime();
        if (time != null) {
            LocalTime adjustedTime = this.getAdjustedTime(time);
            if (adjustedTime.getHour() != time.getHour() || adjustedTime.getMinute() != time.getMinute()) {
                this.setTime(adjustedTime);
            }
            return time.getHour() != adjustedTime.getHour() || time.getMinute() != adjustedTime.getMinute();
        }
        return false;
    }

    private LocalTime getAdjustedTime(LocalTime time) {
        int hour = time.getHour();
        int unadjustedMinutes = time.getMinute();
        int lowerAdjustment = unadjustedMinutes - time.getMinute() % this.getStepRateInMinutes();
        int higherAdjustment = lowerAdjustment + this.getStepRateInMinutes();
        LocalTime adjustedTime = LocalTime.of(hour, lowerAdjustment);
        if (Math.abs(lowerAdjustment - unadjustedMinutes) > Math.abs(higherAdjustment - unadjustedMinutes)) {
            if (higherAdjustment > 59) {
                higherAdjustment = lowerAdjustment;
            }
            adjustedTime = LocalTime.of(hour, higherAdjustment);
        }
        return adjustedTime;
    }

    public final LocalTime getTime() {
        return (LocalTime)this.time.get();
    }

    public final ObjectProperty<LocalTime> timeProperty() {
        return this.time;
    }

    public final void setTime(LocalTime time) {
        if (null == this.getFormat() || time == null) {
            this.time.set((Object)time);
        } else {
            switch (this.getFormat()) {
                case HOURS_MINUTES: {
                    LocalTime adj = time.withSecond(0);
                    adj = adj.withNano(0);
                    this.time.set((Object)adj);
                    break;
                }
                case HOURS_MINUTES_SECONDS: {
                    this.time.set((Object)time.withNano(0));
                    break;
                }
                default: {
                    this.time.set((Object)time);
                }
            }
        }
    }

    public final int getStepRateInMinutes() {
        return this.stepRateInMinutes.get();
    }

    public final IntegerProperty stepRateInMinutesProperty() {
        return this.stepRateInMinutes;
    }

    public final void setStepRateInMinutes(int stepRateInMinutes) {
        this.stepRateInMinutes.set(stepRateInMinutes);
    }

    public final ClockType getClockType() {
        return (ClockType)((Object)this.clockType.get());
    }

    public final ObjectProperty<ClockType> clockTypeProperty() {
        return this.clockType;
    }

    public final void setClockType(ClockType clockType) {
        this.clockType.set((Object)clockType);
    }

    public final boolean isLinkingFields() {
        return this.linkingFields.get();
    }

    public final BooleanProperty linkingFieldsProperty() {
        return this.linkingFields;
    }

    public final void setLinkingFields(boolean linkingFields) {
        this.linkingFields.set(linkingFields);
    }

    public final boolean isRollover() {
        return this.rollover.get();
    }

    public final BooleanProperty rolloverProperty() {
        return this.rollover;
    }

    public final void setRollover(boolean rollover) {
        this.rollover.set(rollover);
    }

    public final Consumer<TimePicker> getOnShowPopup() {
        return (Consumer)this.onShowPopup.get();
    }

    public final ObjectProperty<Consumer<TimePicker>> onShowPopupProperty() {
        return this.onShowPopup;
    }

    public final void setOnShowPopup(Consumer<TimePicker> onShowPopup) {
        this.onShowPopup.set(onShowPopup);
    }

    public final ObjectProperty<Format> formatProperty() {
        return this.format;
    }

    public final Format getFormat() {
        return (Format)((Object)this.format.get());
    }

    public final void setFormat(Format timeUnit) {
        this.format.set((Object)timeUnit);
    }

    public final Node getMinutesSeparator() {
        return (Node)this.minutesSeparator.get();
    }

    public final ObjectProperty<Node> minutesSeparatorProperty() {
        return this.minutesSeparator;
    }

    public final void setMinutesSeparator(Node separator) {
        this.minutesSeparator.set((Object)separator);
    }

    public final Node getSecondsSeparator() {
        return (Node)this.secondsSeparator.get();
    }

    public final ObjectProperty<Node> secondsSeparatorProperty() {
        return this.secondsSeparator;
    }

    public final void setSecondsSeparator(Node separator) {
        this.secondsSeparator.set((Object)separator);
    }

    public static enum ClockType {
        TWENTY_FOUR_HOUR_CLOCK,
        TWELVE_HOUR_CLOCK;

    }

    public static enum Format {
        HOURS_MINUTES,
        HOURS_MINUTES_SECONDS,
        HOURS_MINUTES_SECONDS_MILLIS;

    }
}

