/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.binding;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.binding.ObjectBinding;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public class GeneralAggregatedListBinding<T, S, U, R>
extends ObjectBinding<R> {
    private final Function<T, ObservableList<S>> itemToListFunction;
    private final ObservableList<T> source;
    private final Function<List<S>, U> aggregationFunction;
    private final Function<Stream<U>, R> finalAggregationFunction;
    private final ListChangeListener<Object> nestedListChangeListener = change -> {
        while (change.next()) {
            if (!change.wasAdded() && !change.wasRemoved()) continue;
            this.invalidate();
        }
    };
    private final WeakListChangeListener<Object> weakNestedListChangeListener = new WeakListChangeListener(this.nestedListChangeListener);
    private final ListChangeListener<T> sourceListChangeListener = change -> {
        while (change.next()) {
            if (change.wasRemoved()) {
                change.getRemoved().forEach(this::convertToListAndSafeRemoveListener);
            }
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::convertToListAndSafeAddListener);
            }
            this.invalidate();
        }
    };
    private final WeakListChangeListener<T> weakSourceListChangeListener = new WeakListChangeListener(this.sourceListChangeListener);

    public GeneralAggregatedListBinding(ObservableList<T> source, Function<T, ObservableList<S>> itemToListFunction, Function<List<S>, U> aggregationFunction, Function<Stream<U>, R> finalAggregationFunction) {
        this.source = Objects.requireNonNull(source, "Source list cannot be null");
        this.itemToListFunction = Objects.requireNonNull(itemToListFunction, "Item-to-list function cannot be null");
        this.aggregationFunction = Objects.requireNonNull(aggregationFunction, "Aggregation function cannot be null");
        this.finalAggregationFunction = Objects.requireNonNull(finalAggregationFunction, "Final aggregation function cannot be null");
        this.source.stream().map(itemToListFunction).forEach(this::safeAddListener);
        this.source.addListener(this.weakSourceListChangeListener);
    }

    private void convertToListAndSafeAddListener(T item) {
        ObservableList<S> list = this.itemToListFunction.apply(item);
        this.safeAddListener(list);
    }

    private void safeAddListener(ObservableList<S> list) {
        if (list != null) {
            list.addListener(this.weakNestedListChangeListener);
        }
    }

    private void convertToListAndSafeRemoveListener(T item) {
        ObservableList<S> list = this.itemToListFunction.apply(item);
        this.safeRemoveListener(list);
    }

    private void safeRemoveListener(ObservableList<S> list) {
        if (list != null) {
            list.removeListener(this.weakNestedListChangeListener);
        }
    }

    protected R computeValue() {
        return this.finalAggregationFunction.apply(this.source.stream().map(this.itemToListFunction).map(this.aggregationFunction));
    }

    public void dispose() {
        this.source.stream().map(this.itemToListFunction).forEach(this::safeRemoveListener);
        this.source.removeListener(this.weakSourceListChangeListener);
    }
}

