/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.daterange;

import com.dlsc.gemsfx.CalendarView;
import com.dlsc.gemsfx.daterange.DateRange;
import com.dlsc.gemsfx.daterange.DateRangePreset;
import com.dlsc.gemsfx.skins.DateRangeViewSkin;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class DateRangeView
extends Control {
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horizontal");
    private CalendarView startCalendarView;
    private CalendarView endCalendarView;
    private final CalendarView.SelectionModel selectionModel;
    private ObjectProperty<Orientation> orientation;
    private final StringProperty toText = new SimpleStringProperty((Object)this, "toText", "TO");
    private final StringProperty cancelText = new SimpleStringProperty((Object)this, "cancelText", "CANCEL");
    private final StringProperty applyText = new SimpleStringProperty((Object)this, "applyText", "APPLY");
    private final StringProperty presetTitle = new SimpleStringProperty((Object)this, "presetsTitle", "QUICK SELECT");
    private final ObjectProperty<Side> presetsLocation = new SimpleObjectProperty<Side>((Object)this, "presetsLocation", Side.LEFT){

        public void set(Side side) {
            if (!Objects.equals(side, Side.LEFT) && !Objects.equals(side, Side.RIGHT)) {
                throw new IllegalArgumentException("only sides LEFT and RIGHT are supported");
            }
            super.set((Object)side);
        }
    };
    private final BooleanProperty showPresets = new SimpleBooleanProperty((Object)this, "showQuickSelect", true);
    private final ObjectProperty<Runnable> onClose = new SimpleObjectProperty((Object)this, "onClose", () -> System.out.println("closing"));
    private final ObjectProperty<DateRange> value = new SimpleObjectProperty((Object)this, "value");
    private final BooleanProperty showCancelAndApplyButton = new SimpleBooleanProperty((Object)this, "showCancelAndApplyButton", true);
    private final ObservableList<DateRangePreset> presets = FXCollections.observableArrayList();

    public DateRangeView() {
        this.getStyleClass().add((Object)"date-range-view");
        this.setFocusTraversable(false);
        this.selectionModel = new CalendarView.SelectionModel();
        this.selectionModel.setSelectionMode(CalendarView.SelectionModel.SelectionMode.DATE_RANGE);
        this.startCalendarView = this.getStartCalendarView();
        this.startCalendarView.setSelectionModel(this.selectionModel);
        this.endCalendarView = this.getEndCalendarView();
        this.endCalendarView.setSelectionModel(this.selectionModel);
        DateRangePreset todayRange = this.createTodayRange();
        this.getPresets().addAll((Object[])new DateRangePreset[]{todayRange, this.createYesterdayPreset(), this.createThisWeekPreset(), this.createThisMonthPreset(), this.createLastMonthPreset()});
        this.setValue(todayRange.getDateRangeSupplier().get());
    }

    protected Skin<?> createDefaultSkin() {
        return new DateRangeViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(DateRangeView.class.getResource("date-range-view.css")).toExternalForm();
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set((Object)value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)this.orientation.get();
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.HORIZONTAL){

                public void invalidated() {
                    boolean isVertical = this.get() == Orientation.VERTICAL;
                    DateRangeView.this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, isVertical);
                    DateRangeView.this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, !isVertical);
                }

                public CssMetaData<DateRangeView, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                public Object getBean() {
                    return DateRangeView.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final CalendarView.SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public CalendarView getStartCalendarView() {
        if (this.startCalendarView == null) {
            this.startCalendarView = this.createCalendar();
            this.startCalendarView.setYearMonth(YearMonth.now());
        }
        return this.startCalendarView;
    }

    public CalendarView getEndCalendarView() {
        if (this.endCalendarView == null) {
            this.endCalendarView = this.createCalendar();
            this.endCalendarView.setYearMonth(YearMonth.now().plusMonths(1L));
        }
        return this.endCalendarView;
    }

    private CalendarView createCalendar() {
        CalendarView calendar = new CalendarView();
        calendar.setShowDaysOfPreviousOrNextMonth(true);
        calendar.setShowToday(false);
        calendar.setMarkSelectedDaysOfPreviousOrNextMonth(false);
        return calendar;
    }

    public final String getToText() {
        return (String)this.toText.get();
    }

    public final StringProperty toTextProperty() {
        return this.toText;
    }

    public final void setToText(String toText) {
        this.toText.set((Object)toText);
    }

    public final String getCancelText() {
        return (String)this.cancelText.get();
    }

    public final StringProperty cancelTextProperty() {
        return this.cancelText;
    }

    public final void setCancelText(String cancelText) {
        this.cancelText.set((Object)cancelText);
    }

    public final String getApplyText() {
        return (String)this.applyText.get();
    }

    public final StringProperty applyTextProperty() {
        return this.applyText;
    }

    public final void setApplyText(String applyText) {
        this.applyText.set((Object)applyText);
    }

    public String getPresetTitle() {
        return (String)this.presetTitle.get();
    }

    public StringProperty presetTitleProperty() {
        return this.presetTitle;
    }

    public void setPresetTitle(String presetTitle) {
        this.presetTitle.set((Object)presetTitle);
    }

    public final Side getPresetsLocation() {
        return (Side)this.presetsLocation.get();
    }

    public final ObjectProperty<Side> presetsLocationProperty() {
        return this.presetsLocation;
    }

    public final void setPresetsLocation(Side presetsLocation) {
        this.presetsLocation.set((Object)presetsLocation);
    }

    public final boolean isShowPresets() {
        return this.showPresets.get();
    }

    public final BooleanProperty showPresetsProperty() {
        return this.showPresets;
    }

    public final void setShowPresets(boolean showPresets) {
        this.showPresets.set(showPresets);
    }

    public final Runnable getOnClose() {
        return (Runnable)this.onClose.get();
    }

    public final ObjectProperty<Runnable> onCloseProperty() {
        return this.onClose;
    }

    public final void setOnClose(Runnable onClose) {
        this.onClose.set((Object)onClose);
    }

    public final DateRange getValue() {
        return (DateRange)this.value.get();
    }

    public final ObjectProperty<DateRange> valueProperty() {
        return this.value;
    }

    public final void setValue(DateRange value) {
        this.value.set((Object)value);
    }

    public final boolean isShowCancelAndApplyButton() {
        return this.showCancelAndApplyButton.get();
    }

    public final BooleanProperty showCancelAndApplyButtonProperty() {
        return this.showCancelAndApplyButton;
    }

    public final void setShowCancelAndApplyButton(boolean showCancelAndApplyButton) {
        this.showCancelAndApplyButton.set(showCancelAndApplyButton);
    }

    public final ObservableList<DateRangePreset> getPresets() {
        return this.presets;
    }

    private DateRangePreset createTodayRange() {
        return new DateRangePreset("Today", () -> new DateRange("Today", LocalDate.now()));
    }

    private DateRangePreset createYesterdayPreset() {
        return new DateRangePreset("Yesterday", () -> new DateRange("Yesterday", LocalDate.now().minusDays(1L)));
    }

    private DateRangePreset createThisWeekPreset() {
        return new DateRangePreset("This Week", () -> {
            TemporalField fieldISO = WeekFields.of(Locale.getDefault()).dayOfWeek();
            return new DateRange("This Week", LocalDate.now().with(fieldISO, 1L), LocalDate.now().with(fieldISO, 1L).plusDays(6L));
        });
    }

    private DateRangePreset createThisMonthPreset() {
        return new DateRangePreset("This Month", () -> {
            LocalDate start = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
            LocalDate end = start.with(TemporalAdjusters.lastDayOfMonth());
            return new DateRange("This Month", start, end);
        });
    }

    private DateRangePreset createLastMonthPreset() {
        return new DateRangePreset("Last Month", () -> {
            LocalDate start = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).minusMonths(1L);
            LocalDate end = start.with(TemporalAdjusters.lastDayOfMonth());
            return new DateRange("Last Month", start, end);
        });
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return DateRangeView.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<DateRangeView, Orientation> ORIENTATION = new CssMetaData<DateRangeView, Orientation>("-fx-orientation", (StyleConverter)new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            public Orientation getInitialValue(DateRangeView node) {
                return node.getOrientation();
            }

            public boolean isSettable(DateRangeView n) {
                return n.orientation == null || !n.orientation.isBound();
            }

            public StyleableProperty<Orientation> getStyleableProperty(DateRangeView n) {
                return (StyleableProperty)n.orientationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<DateRangeView, Orientation>> styleables = new ArrayList<CssMetaData<DateRangeView, Orientation>>(Control.getClassCssMetaData());
            styleables.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

