/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.TimePicker;
import com.dlsc.gemsfx.skins.TimeField;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.commons.lang3.StringUtils;

public abstract class DigitsField
extends TimeField {
    private TimeField nextField;
    private TimeField previousField;
    private int numberOfDigits;
    private final StringProperty typedText = new SimpleStringProperty((Object)this, "typedText");
    private final IntegerProperty stepRate = new SimpleIntegerProperty((Object)this, "stepRate", 1);
    private final ObjectProperty<Integer> value = new SimpleObjectProperty((Object)this, "value");
    private final IntegerProperty minimumValue = new SimpleIntegerProperty((Object)this, "minimumValue", 0);
    private final IntegerProperty maximumValue = new SimpleIntegerProperty((Object)this, "maximumValue");

    public DigitsField(TimePicker timePicker, boolean fillDigits) {
        this(timePicker, fillDigits, 2);
    }

    public DigitsField(TimePicker timePicker, boolean fillDigits, int numberOfDigits) {
        super(timePicker);
        this.numberOfDigits = numberOfDigits;
        this.getStyleClass().add((Object)"digits-field");
        this.setAlignment(Pos.CENTER);
        this.setOnMouseClicked(evt -> this.requestFocus());
        this.minimumValueProperty().addListener(it -> this.constrainValue());
        this.maximumValueProperty().addListener(it -> this.constrainValue());
        this.setFocusTraversable(true);
        this.setAlignment(Pos.CENTER);
        this.valueProperty().addListener(it -> {
            Integer value = this.getValue();
            if (value == null) {
                this.setTypedText("");
            } else {
                String oldText = this.getTypedText();
                Object newText = Integer.toString(value);
                if (oldText != null && oldText.length() == 2 && ((String)newText).length() == 1) {
                    newText = "0" + (String)newText;
                }
                this.setTypedText((String)newText);
            }
        });
        this.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            Integer value = this.getValue();
            if (value == null) {
                if (this.isFocused()) {
                    return "";
                }
                return "--";
            }
            if (value < 10 && (fillDigits || this.getTypedText().length() > 1)) {
                if (numberOfDigits == 2) {
                    return "0" + value;
                }
                if (numberOfDigits == 3) {
                    return "00" + value;
                }
            } else if (value < 100 && numberOfDigits == 3 && (fillDigits || this.getTypedText().length() > 1)) {
                return "0" + value;
            }
            return Integer.toString(value);
        }, (Observable[])new Observable[]{this.valueProperty(), this.focusedProperty()}));
        this.focusedProperty().addListener(it -> {
            if (this.isFocused()) {
                String text = this.getText();
                if (text.equals("--")) {
                    this.setTypedText("");
                } else {
                    this.setTypedText(text);
                }
            } else {
                this.constrainValue();
            }
        });
        timePicker.adjustedProperty().addListener(it -> {
            if (timePicker.isAdjusted()) {
                this.setTypedText("");
            }
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().isArrowKey()) {
                this.handleArrowKey((KeyEvent)evt);
            } else {
                boolean handled = false;
                if (evt.getCode().isDigitKey()) {
                    this.handleDigit((KeyEvent)evt);
                    handled = true;
                } else if (evt.getCode().equals((Object)KeyCode.BACK_SPACE)) {
                    this.handleBackspace();
                    handled = true;
                } else if (evt.getCode().equals((Object)KeyCode.SPACE) && this.nextField != null) {
                    this.nextField.requestFocus();
                }
                if (handled) {
                    if (StringUtils.isBlank((CharSequence)this.typedText.getValueSafe()) || this.typedText.getValueSafe().isEmpty()) {
                        this.setValue(null);
                    } else {
                        this.setValue(Integer.parseInt(this.getTypedText()));
                    }
                    if (this.getTypedText().length() == numberOfDigits && this.nextField != null) {
                        this.nextField.requestFocus();
                    }
                }
            }
        });
    }

    private void setTypedText(String text) {
        this.typedText.set((Object)text);
    }

    private String getTypedText() {
        return (String)this.typedText.get();
    }

    private void handleBackspace() {
        if (StringUtils.isNotBlank((CharSequence)this.getTypedText())) {
            this.setTypedText(this.getTypedText().substring(0, this.getTypedText().length() - 1));
        }
    }

    private void handleDigit(KeyEvent evt) {
        if (this.getTypedText().length() == this.numberOfDigits) {
            this.setTypedText("");
        }
        switch (evt.getText()) {
            case "0": 
            case "1": 
            case "2": 
            case "3": 
            case "4": 
            case "5": 
            case "6": 
            case "7": 
            case "8": 
            case "9": {
                this.setTypedText(this.getTypedText() + evt.getText());
                break;
            }
        }
    }

    private void handleArrowKey(KeyEvent evt) {
        if (evt.getCode().equals((Object)KeyCode.DOWN)) {
            this.decrement();
            this.getTimePicker().getProperties().put((Object)"ADJUST_TIME", (Object)"ADJUST_TIME");
        } else if (evt.getCode().equals((Object)KeyCode.UP)) {
            this.increment();
            this.getTimePicker().getProperties().put((Object)"ADJUST_TIME", (Object)"ADJUST_TIME");
        } else if (evt.getCode().equals((Object)KeyCode.RIGHT)) {
            if (this.nextField != null) {
                this.nextField.requestFocus();
            }
        } else if (evt.getCode().equals((Object)KeyCode.LEFT) && this.previousField != null) {
            this.previousField.requestFocus();
        }
        evt.consume();
    }

    @Override
    void decrement() {
        Integer value = this.getValue();
        if (value != null) {
            int newValue = value - this.getStepRate();
            if (newValue < this.getMinimumValue()) {
                TimePicker timePicker = this.getTimePicker();
                if (timePicker.isRollover()) {
                    this.setValue(this.getMaximumValue() - this.getMaximumValue() % this.getStepRate());
                    if (timePicker.isLinkingFields() && this.previousField != null) {
                        this.previousField.decrement();
                    }
                } else {
                    this.setValue(this.getMinimumValue());
                }
            } else {
                this.setValue(newValue);
            }
        } else {
            this.setValue(0);
        }
    }

    @Override
    void increment() {
        Integer value = this.getValue();
        if (value != null) {
            int newValue = value + this.getStepRate();
            if (newValue > this.getMaximumValue()) {
                TimePicker timePicker = this.getTimePicker();
                if (timePicker.isRollover()) {
                    this.setValue(this.getMinimumValue());
                    if (timePicker.isLinkingFields() && this.previousField != null) {
                        this.previousField.increment();
                    }
                } else {
                    this.setValue(this.getMaximumValue());
                }
            } else {
                this.setValue(newValue);
            }
        } else {
            this.setValue(0);
        }
    }

    final void setNextField(TimeField field) {
        this.nextField = field;
    }

    final void setPreviousField(TimeField field) {
        this.previousField = field;
    }

    public final int getStepRate() {
        return this.stepRate.get();
    }

    public final IntegerProperty stepRateProperty() {
        return this.stepRate;
    }

    public final void setStepRate(int stepRate) {
        this.stepRate.set(stepRate);
    }

    private void constrainValue() {
        Integer value = this.getValue();
        if (value != null) {
            if (value < this.getMinimumValue()) {
                this.setValue(this.getMinimumValue());
                return;
            }
            if (value > this.getMaximumValue()) {
                this.setValue(this.getMaximumValue());
                return;
            }
        }
    }

    public final ObjectProperty<Integer> valueProperty() {
        return this.value;
    }

    public final Integer getValue() {
        return (Integer)this.valueProperty().get();
    }

    public final void setValue(Integer value) {
        this.valueProperty().set((Object)value);
    }

    public final IntegerProperty minimumValueProperty() {
        return this.minimumValue;
    }

    public final Integer getMinimumValue() {
        return this.minimumValueProperty().get();
    }

    public final void setMinimumValue(Integer minimumValue) {
        this.minimumValueProperty().set(minimumValue.intValue());
    }

    public final IntegerProperty maximumValueProperty() {
        return this.maximumValue;
    }

    public final Integer getMaximumValue() {
        return this.maximumValueProperty().get();
    }

    public final void setMaximumValue(Integer maximumValue) {
        this.maximumValueProperty().set(maximumValue.intValue());
    }
}

