/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.skin.VirtualFlow;

public class VirtualFlowUtil {
    public static void bindVirtualFlows(Control control1, Control control2) {
        AtomicReference<InvalidationListener> skinListener = new AtomicReference<InvalidationListener>();
        AtomicBoolean isBound = new AtomicBoolean(false);
        Runnable maybeBind = () -> {
            if (isBound.get()) {
                return;
            }
            VirtualFlow leftFlow = (VirtualFlow)control1.lookup("VirtualFlow");
            VirtualFlow rightFlow = (VirtualFlow)control2.lookup("VirtualFlow");
            if (leftFlow != null && rightFlow != null) {
                VirtualFlowUtil.doRealBidirectionalBinding(leftFlow, rightFlow);
                control1.skinProperty().removeListener((InvalidationListener)skinListener.get());
                control2.skinProperty().removeListener((InvalidationListener)skinListener.get());
                isBound.set(true);
            }
        };
        skinListener.set(it -> maybeBind.run());
        control1.skinProperty().addListener((InvalidationListener)skinListener.get());
        control2.skinProperty().addListener((InvalidationListener)skinListener.get());
        maybeBind.run();
    }

    private static void doRealBidirectionalBinding(VirtualFlow<?> leftFlow, VirtualFlow<?> rightFlow) {
        AtomicBoolean isUpdating = new AtomicBoolean(false);
        VirtualFlowUtil.doRealBinding(isUpdating, leftFlow, rightFlow);
        VirtualFlowUtil.doRealBinding(isUpdating, rightFlow, leftFlow);
    }

    private static void doRealBinding(AtomicBoolean isUpdating, VirtualFlow<?> flow1, VirtualFlow<?> flow2) {
        AtomicReference<Object> lastCell = new AtomicReference<Object>(null);
        Runnable doUpdate = () -> {
            if (isUpdating.get()) {
                return;
            }
            isUpdating.set(true);
            VirtualFlowUtil.addPostLayoutAction(flow1.getScene(), () -> {
                try {
                    VirtualFlowUtil.updatePosition(flow1, flow2);
                }
                finally {
                    isUpdating.set(false);
                }
            });
        };
        ChangeListener doUpdateListener = (obs, oldVal, newVal) -> doUpdate.run();
        Runnable updateCellListener = () -> {
            IndexedCell newCell;
            if (lastCell.get() != null) {
                ((Cell)lastCell.get()).layoutYProperty().removeListener(doUpdateListener);
            }
            if ((newCell = flow1.getLastVisibleCell()) != null) {
                newCell.layoutYProperty().addListener(doUpdateListener);
            }
            lastCell.set(newCell);
        };
        flow1.positionProperty().addListener((obs, oldVal, newVal) -> {
            updateCellListener.run();
            doUpdate.run();
        });
    }

    private static void updatePosition(VirtualFlow<?> fromFlow, VirtualFlow<?> toFlow) {
        VirtualFlowPosition pos2 = VirtualFlowUtil.getVFlowPosition(fromFlow);
        VirtualFlowUtil.setVFlowPosition(toFlow, pos2);
    }

    private static VirtualFlowPosition getVFlowPosition(VirtualFlow<?> flow) {
        flow.applyCss();
        flow.layout();
        IndexedCell cell = flow.getFirstVisibleCell();
        int index = cell.getIndex();
        double offset = -cell.getLayoutY();
        return new VirtualFlowPosition(index, offset);
    }

    private static void setVFlowPosition(VirtualFlow<?> flow, VirtualFlowPosition pos) {
        try {
            flow.scrollToTop(pos.index);
            flow.layout();
            flow.scrollPixels(pos.offset);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void addPostLayoutAction(Scene scene, Runnable action) {
        AtomicReference<Runnable> listener = new AtomicReference<Runnable>();
        listener.set(() -> {
            scene.removePostLayoutPulseListener((Runnable)listener.get());
            action.run();
        });
        scene.addPostLayoutPulseListener((Runnable)listener.get());
    }

    private static class VirtualFlowPosition {
        private int index;
        private double offset;

        public VirtualFlowPosition(int index, double offset) {
            this.index = index;
            this.offset = offset;
        }

        public String toString() {
            return "VBosPosition{index=" + this.index + ", offset=" + this.offset + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VirtualFlowPosition that = (VirtualFlowPosition)o;
            return this.index == that.index && Double.compare(that.offset, this.offset) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.index, this.offset);
        }
    }
}

