/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.javamodularity.moduleplugin.internal.TaskOption;

public enum TestEngine {
    JUNIT_4("junit", "junit", "junit", "junit", new TaskOption[0]),
    JUNIT_5_API("org.junit.jupiter", ".*", "org.junit.jupiter.api", "org.junit.platform.commons", new TaskOption[0]),
    JUNIT_5("org.junit.jupiter", "junit-platform-commons", "org.junit.jupiter.api", "org.junit.jupiter.api", new TaskOption[0]),
    JUNIT_5_PARAMS("org.junit.jupiter", "junit-jupiter-params", "org.junit.jupiter.params", "org.junit.platform.commons", new TaskOption[0]),
    JUNIT_PLATFORM_COMMONS("org.junit.platform", "junit-platform-commons", "org.junit.platform.commons", "ALL-UNNAMED", new TaskOption("--add-exports", "org.junit.platform.commons/org.junit.platform.commons.util=ALL-UNNAMED"), new TaskOption("--add-exports", "org.junit.platform.commons/org.junit.platform.commons.logging=ALL-UNNAMED")),
    JUNIT_JUPITER_ENGINE("org.junit.jupiter", "junit-jupiter-engine", "org.junit.jupiter.engine", "ALL-UNNAMED", new TaskOption[0]),
    JUNIT_PLATFORM_ENGINE("org.junit.platform", "junit-platform-engine", "org.junit.platform.engine", "ALL-UNNAMED", new TaskOption("--add-exports", "org.junit.platform.engine/org.junit.platform.engine.support.filter=org.junit.jupiter.engine,ALL-UNNAMED")),
    TESTNG("org.testng", "testng", "org.testng", "org.testng", new TaskOption[0]),
    ASSERTJ("org.assertj", "assertj-core", "org.assertj.core", "org.assertj.core", new TaskOption[0]),
    TRUTH("com.google.truth", "truth", "truth", "truth", new TaskOption[0]),
    MOCKITO("org.mockito", "mockito-core", "org.mockito", "org.mockito", new TaskOption[0]),
    EASYMOCK("org.easymock", "easymock", "org.easymock", "org.easymock", new TaskOption[0]),
    SPOCK("org.spockframework", "spock-core", "org.spockframework.core", "org.spockframework.core", new TaskOption("--add-exports", "org.junit.platform.commons/org.junit.platform.commons.util=org.spockframework.core,ALL-UNNAMED"), new TaskOption("--add-exports", "org.junit.platform.commons/org.junit.platform.commons.logging=org.spockframework.core,ALL-UNNAMED"), new TaskOption("--add-exports", "org.junit.platform.engine/org.junit.platform.engine.support.filter=org.junit.jupiter.engine,ALL-UNNAMED"));

    private static final Logger LOGGER;
    private final String groupId;
    private final String artifactId;
    public final String moduleName;
    public final String addOpens;
    public final List<TaskOption> additionalTaskOptions;
    private static List<String> CONFIGURATION_NAMES;

    private TestEngine(String groupId, String artifactId, String moduleName, String addOpens, TaskOption ... additionalTaskOptions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.moduleName = moduleName;
        this.addOpens = addOpens;
        this.additionalTaskOptions = Arrays.asList(additionalTaskOptions);
    }

    public static Collection<TestEngine> selectMultiple(Project project, Set<File> files) {
        ConfigurationContainer configurations = project.getConfigurations();
        Set<TestEngine> engines = CONFIGURATION_NAMES.stream().map(arg_0 -> ((ConfigurationContainer)configurations).findByName(arg_0)).filter(Objects::nonNull).flatMap(cfg -> TestEngine.getModuleIdentifiers(cfg, files)).flatMap(d -> TestEngine.select(d)).collect(Collectors.toSet());
        LOGGER.info("Selected test engines: " + engines);
        return engines;
    }

    private static Stream<GroupArtifact> getModuleIdentifiers(Configuration origCfg, Set<File> files) {
        Configuration cfg = origCfg.copyRecursive();
        cfg.setCanBeResolved(true);
        try {
            cfg.resolve();
            Set flmDeps = cfg.getResolvedConfiguration().getFirstLevelModuleDependencies();
            return flmDeps.stream().flatMap(dep -> Stream.concat(TestEngine.getAllDeps(dep).stream(), Stream.of(dep))).filter(dep -> TestEngine.isDependencyPresent(dep, files)).map(dep -> GroupArtifact.fromModuleIdentifier(dep.getModule().getId().getModule()));
        }
        catch (ResolveException e) {
            LOGGER.debug("Cannot resolve transitive dependencies of configuration " + cfg.getName(), (Throwable)e);
            LOGGER.info("Using direct dependencies of configuration {}.", (Object)origCfg.getName());
            return origCfg.getDependencies().stream().map(dep -> new GroupArtifact(dep.getGroup(), dep.getName()));
        }
    }

    private static boolean isDependencyPresent(ResolvedDependency dep, Set<File> files) {
        return dep.getModuleArtifacts().stream().map(ResolvedArtifact::getFile).anyMatch(files::contains);
    }

    private static Set<ResolvedDependency> getAllDeps(ResolvedDependency dep) {
        HashSet<ResolvedDependency> deps = new HashSet<ResolvedDependency>();
        TestEngine.addChildren(dep, deps);
        return deps;
    }

    private static void addChildren(ResolvedDependency dep, Set<ResolvedDependency> deps) {
        deps.add(dep);
        dep.getChildren().forEach(d -> {
            if (!deps.contains(d)) {
                TestEngine.addChildren(d, deps);
            }
        });
    }

    private static Stream<TestEngine> select(GroupArtifact ga) {
        LOGGER.info("TestEngine.select({}:{}", (Object)ga.groupId, (Object)ga.artifactId);
        return Arrays.stream(TestEngine.values()).filter(engine -> ga.groupId != null && ga.artifactId != null && ga.groupId.matches(engine.groupId) && ga.artifactId.matches(engine.artifactId));
    }

    static {
        LOGGER = Logging.getLogger(TestEngine.class);
        CONFIGURATION_NAMES = List.of("api", "compile", "compileClasspath", "compileOnly", "implementation", "runtime", "runtimeClasspath", "runtimeOnly", "testApi", "testCompile", "testCompileClasspath", "testCompileOnly", "testImplementation", "testRuntime", "testRuntimeClasspath", "testRuntimeOnly", "testFixturesApi", "testFixturesCompile", "testFixturesCompileClasspath", "testFixturesCompileOnly", "testFixturesCompileOnlyApi", "testFixturesImplementation", "testFixturesRuntime", "testFixturesRuntimeClasspath", "testFixturesRuntimeOnly");
    }

    private static class GroupArtifact {
        final String groupId;
        final String artifactId;

        private GroupArtifact(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        static GroupArtifact fromModuleIdentifier(ModuleIdentifier mi) {
            LOGGER.info("fromModuleIdentifier({}:{})", (Object)mi.getGroup(), (Object)mi.getName());
            return new GroupArtifact(mi.getGroup(), mi.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupArtifact that = (GroupArtifact)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId);
        }
    }
}

