/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.extensions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.javamodularity.moduleplugin.JavaProjectHelper;
import org.javamodularity.moduleplugin.internal.StreamHelper;
import org.javamodularity.moduleplugin.internal.TaskOption;
import org.javamodularity.moduleplugin.tasks.MergeClassesHelper;

public abstract class ModuleOptions {
    private static final Logger LOGGER = Logging.getLogger(ModuleOptions.class);
    private final Project project;
    private List<String> addModules = new ArrayList<String>();
    private Map<String, String> addReads = new LinkedHashMap<String, String>();
    private Map<String, String> addExports = new LinkedHashMap<String, String>();

    protected ModuleOptions(Project project) {
        this.project = project;
    }

    public List<String> getAddModules() {
        return this.addModules;
    }

    public void setAddModules(List<String> addModules) {
        this.addModules = addModules;
    }

    public Map<String, String> getAddReads() {
        return this.addReads;
    }

    public void setAddReads(Map<String, String> addReads) {
        this.addReads = addReads;
    }

    public Map<String, String> getAddExports() {
        return this.addExports;
    }

    public void setAddExports(Map<String, String> addExports) {
        this.addExports = addExports;
    }

    public void mutateArgs(List<String> args) {
        this.buildFullOptionStreamLogged().forEach(o -> o.mutateArgs(args));
    }

    public Stream<TaskOption> buildFullOptionStreamLogged() {
        LOGGER.debug("Updating module '{}' with...", (Object)this.helper().moduleName());
        return this.buildFullOptionStream().peek(option -> LOGGER.debug("  {} {}", (Object)option.getFlag(), (Object)option.getValue()));
    }

    protected Stream<TaskOption> buildFullOptionStream() {
        return StreamHelper.concat(this.addModulesOption().stream(), this.addReadsOptionStream(), this.addExportsOptionStream());
    }

    private Optional<TaskOption> addModulesOption() {
        if (this.addModules.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TaskOption("--add-modules", String.join((CharSequence)",", this.addModules)));
    }

    private Stream<TaskOption> addReadsOptionStream() {
        return this.buildOptionStream("--add-reads", this.addReads);
    }

    private Stream<TaskOption> addExportsOptionStream() {
        return this.buildOptionStream("--add-exports", this.addExports);
    }

    protected final Stream<TaskOption> buildOptionStream(String flag, Map<String, String> map) {
        if (map.isEmpty()) {
            return Stream.empty();
        }
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).map(value -> new TaskOption(flag, (String)value));
    }

    protected final JavaProjectHelper helper() {
        return new JavaProjectHelper(this.project);
    }

    protected final MergeClassesHelper mergeClassesHelper() {
        return new MergeClassesHelper(this.project);
    }
}

