/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.other.StatementProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={Connection.class, XAConnection.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ConnectionProxy
implements LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
XAConnection,
LogicalObject {
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();

    UniversalPooledConnection getUPC() {
        Object c = this.getCreator();
        return c instanceof Creator ? ((Creator)c).getUPC() : ((ConnectionProxy)c).getUPC();
    }

    UniversalConnectionPool getUCP() {
        Object c = this.getCreator();
        return c instanceof Creator ? ((Creator)c).getUCP() : ((ConnectionProxy)c).getUCP();
    }

    @GetDelegate
    protected abstract Connection getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    @Pre
    @Methods(signatures={@Signature(name="addConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="addStatementEventListener", args={StatementEventListener.class}), @Signature(name="removeConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="removeStatementEventListener", args={StatementEventListener.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void preNoThrow(Method m, Object receiver, Object ... args) {
        try {
            this.pre(m, receiver, args);
        }
        catch (SQLException e) {
            throw new ProxyException(e);
        }
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        this.getUPC().heartbeat();
        if (this.closed.get()) {
            String msg = UCPErrorHandler.findSQLMessage(31, null);
            throw new SQLRecoverableException(msg, null, 31);
        }
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            try {
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogThrowing(null, null, null, null, ucpe);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="createStatement", args={}), @Signature(name="createStatement", args={int.class, int.class}), @Signature(name="createStatement", args={int.class, int.class, int.class})})
    protected Statement post(Method m, Statement result) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(result);
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, Properties.class})})
    protected CallableStatement post(Method m, CallableStatement result) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(result);
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class})})
    protected PreparedStatement post(Method m, PreparedStatement result) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(result);
        return result;
    }

    @Post
    protected Object postRest(Method m, Object result) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(result);
        return result;
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoid(Method m, SQLException e) throws SQLException {
        this.onError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method m, SQLException e) throws SQLException {
        this.getUPC().heartbeat();
        this.handleSQRecoverableException(e);
        throw e;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.getUPC().heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    protected void handleSQRecoverableException(SQLException e) throws SQLException {
        if (e instanceof SQLRecoverableException && !this.actuallyReturned.get()) {
            try {
                for (StatementProxy stmt : this.statementsToClose.toList()) {
                    stmt.close();
                }
                this.statementsToClose.clear();
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogThrowing(null, null, null, null, ucpe);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        UniversalConnectionPool ucp = this.getUCP();
        UniversalPooledConnection upc = this.getUPC();
        upc.heartbeat();
        if (this.closed.get()) {
            return;
        }
        try {
            for (StatementProxy stmt : this.statementsToClose.toList()) {
                stmt.close();
            }
            this.statementsToClose.clear();
            this.closed.set(true);
            ucp.returnConnection(upc);
            this.actuallyReturned.set(true);
            upc.heartbeat();
        }
        catch (UniversalConnectionPoolException e) {
            Throwable cause = e.getCause();
            if (null == cause) {
                throw new SQLException(e);
            }
            Throwable cause2 = cause.getCause();
            if (null == cause2 || !(cause2 instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)cause2;
        }
    }

    public boolean isValid(int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(timeout);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getUPC().isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        this.getUPC().heartbeat();
        try {
            this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e) {
            throw new SQLException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        try {
            props = this.getUPC().getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        try {
            props = this.getUPC().getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        return this.getUPC().isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ConnectionProxy ? ((ConnectionProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    protected void saveStatementProxy(Object result) {
        if (result instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)result;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }
}

