/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.token;

import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.token.Token;

public class TextToken
extends Token {
    private final String text;
    private final Type type;

    public TextToken(String text, Type type) {
        this(text, type, 0);
    }

    public TextToken(String text, Type type, int formattingAttributes) {
        this(text, type, formattingAttributes, false);
    }

    public TextToken(String text, Type type, int formattingAttributes, boolean firstField) {
        super(formattingAttributes, firstField);
        this.text = text;
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.text;
    }

    public TextToken copyWithText(String text) {
        return new TextToken(text, this.getType(), this.getFormattingAttributes(), this.isFirstField());
    }

    @Override
    public TextToken copyWithFirstField(boolean firstField) {
        return new TextToken(this.getText(), this.getType(), this.getFormattingAttributes(), firstField);
    }

    @Override
    public Token wrapFormattingAttributes(int otherFormattingAttributes) {
        int fa = FormattingAttributes.merge(otherFormattingAttributes, this.getFormattingAttributes());
        return new TextToken(this.getText(), this.getType(), fa, this.isFirstField());
    }

    public static enum Type {
        TEXT,
        OPEN_QUOTE,
        CLOSE_QUOTE,
        PREFIX,
        SUFFIX,
        DELIMITER,
        URL,
        DOI;

    }
}

