// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lookoutequipment_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lookoutequipment"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Creates a retraining scheduler with manual promote mode
//

func ExampleLookoutEquipment_CreateRetrainingScheduler_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.CreateRetrainingSchedulerInput{
		ClientToken:         aws.String("sample-client-token"),
		LookbackWindow:      aws.String("P360D"),
		ModelName:           aws.String("sample-model"),
		PromoteMode:         aws.String("MANUAL"),
		RetrainingFrequency: aws.String("P1M"),
	}

	result, err := svc.CreateRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creates a retraining scheduler with a specific start date
//

func ExampleLookoutEquipment_CreateRetrainingScheduler_shared01() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.CreateRetrainingSchedulerInput{
		ClientToken:         aws.String("sample-client-token"),
		LookbackWindow:      aws.String("P360D"),
		ModelName:           aws.String("sample-model"),
		RetrainingFrequency: aws.String("P1M"),
		RetrainingStartDate: parseTime("2006-01-02T15:04:05.999999999Z", "2024-01-01T00:00:00Z"),
	}

	result, err := svc.CreateRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Deletes a retraining scheduler
//

func ExampleLookoutEquipment_DeleteRetrainingScheduler_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.DeleteRetrainingSchedulerInput{
		ModelName: aws.String("sample-model"),
	}

	result, err := svc.DeleteRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describes a retraining scheduler
//

func ExampleLookoutEquipment_DescribeRetrainingScheduler_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.DescribeRetrainingSchedulerInput{
		ModelName: aws.String("sample-model"),
	}

	result, err := svc.DescribeRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Listing retraining schedulers
//

func ExampleLookoutEquipment_ListRetrainingSchedulers_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.ListRetrainingSchedulersInput{
		MaxResults: aws.Int64(50),
	}

	result, err := svc.ListRetrainingSchedulers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Starts a retraining scheduler
//

func ExampleLookoutEquipment_StartRetrainingScheduler_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.StartRetrainingSchedulerInput{
		ModelName: aws.String("sample-model"),
	}

	result, err := svc.StartRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Stops a retraining scheduler
//

func ExampleLookoutEquipment_StopRetrainingScheduler_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.StopRetrainingSchedulerInput{
		ModelName: aws.String("sample-model"),
	}

	result, err := svc.StopRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updates a model
//

func ExampleLookoutEquipment_UpdateModel_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.UpdateModelInput{
		LabelsInputConfiguration: &lookoutequipment.LabelsInputConfiguration{
			LabelGroupName: aws.String("sample-label-group"),
		},
		ModelName: aws.String("sample-model"),
	}

	result, err := svc.UpdateModel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updates a retraining scheduler
//

func ExampleLookoutEquipment_UpdateRetrainingScheduler_shared00() {
	svc := lookoutequipment.New(session.New())
	input := &lookoutequipment.UpdateRetrainingSchedulerInput{
		ModelName:           aws.String("sample-model"),
		RetrainingFrequency: aws.String("P1Y"),
		RetrainingStartDate: parseTime("2006-01-02T15:04:05.999999999Z", "2024-01-01T00:00:00Z"),
	}

	result, err := svc.UpdateRetrainingScheduler(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lookoutequipment.ErrCodeValidationException:
				fmt.Println(lookoutequipment.ErrCodeValidationException, aerr.Error())
			case lookoutequipment.ErrCodeResourceNotFoundException:
				fmt.Println(lookoutequipment.ErrCodeResourceNotFoundException, aerr.Error())
			case lookoutequipment.ErrCodeConflictException:
				fmt.Println(lookoutequipment.ErrCodeConflictException, aerr.Error())
			case lookoutequipment.ErrCodeThrottlingException:
				fmt.Println(lookoutequipment.ErrCodeThrottlingException, aerr.Error())
			case lookoutequipment.ErrCodeAccessDeniedException:
				fmt.Println(lookoutequipment.ErrCodeAccessDeniedException, aerr.Error())
			case lookoutequipment.ErrCodeInternalServerException:
				fmt.Println(lookoutequipment.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
