//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkcontrollerclass?language=objc)
pub const kIONetworkControllerClass: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkController\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiovendor?language=objc)
pub const kIOVendor: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOVendor\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomodel?language=objc)
pub const kIOModel: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOModel\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiorevision?language=objc)
pub const kIORevision: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IORevision\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiofeatures?language=objc)
pub const kIOFeatures: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOFeatures\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumdictionary?language=objc)
pub const kIOMediumDictionary: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMediumDictionary\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiodefaultmedium?language=objc)
pub const kIODefaultMedium: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IODefaultMedium\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioselectedmedium?language=objc)
pub const kIOSelectedMedium: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOSelectedMedium\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioactivemedium?language=objc)
pub const kIOActiveMedium: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOActiveMedium\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiolinkspeed?language=objc)
pub const kIOLinkSpeed: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOLinkSpeed\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiolinkstatus?language=objc)
pub const kIOLinkStatus: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOLinkStatus\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiolinkdata?language=objc)
pub const kIOLinkData: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOLinkData\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfilters?language=objc)
pub const kIOPacketFilters: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOPacketFilters\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomacaddress?language=objc)
pub const kIOMACAddress: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMACAddress\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomaxpacketsize?language=objc)
pub const kIOMaxPacketSize: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMaxPacketSize\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiominpacketsize?language=objc)
pub const kIOMinPacketSize: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMinPacketSize\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfiltergroup?language=objc)
pub const kIONetworkFilterGroup: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkFilterGroup\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetcontrollerclass?language=objc)
pub const kIOEthernetControllerClass: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOEthernetController\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetaddresssize?language=objc)
pub const kIOEthernetAddressSize: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetmaxpacketsize?language=objc)
pub const kIOEthernetMaxPacketSize: c_uint = 1518;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetminpacketsize?language=objc)
pub const kIOEthernetMinPacketSize: c_uint = 64;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetcrcsize?language=objc)
pub const kIOEthernetCRCSize: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetwakeonlanfiltergroup?language=objc)
pub const kIOEthernetWakeOnLANFilterGroup: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOEthernetWakeOnLANFilterGroup\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetdisabledwakeonlanfiltergroup?language=objc)
pub const kIOEthernetDisabledWakeOnLANFilterGroup: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOEthernetDisabledWakeOnLANFilterGroup\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdatabasicaccesstypes?language=objc)
pub const kIONetworkDataBasicAccessTypes: c_uint =
    kIONetworkDataAccessTypeRead | kIONetworkDataAccessTypeSerialize;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdatabytes?language=objc)
pub const kIONetworkDataBytes: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Data\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdataaccesstypes?language=objc)
pub const kIONetworkDataAccessTypes: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Access Types\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdatasize?language=objc)
pub const kIONetworkDataSize: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Size\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkstackusercommandkey?language=objc)
pub const kIONetworkStackUserCommandKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkStackUserCommand\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkstackusercommand?language=objc)
pub const kIONetworkStackUserCommand: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkStackUserCommand\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetinterfaceclass?language=objc)
pub const kIOEthernetInterfaceClass: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOEthernetInterface\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioactivepacketfilters?language=objc)
pub const kIOActivePacketFilters: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOActivePacketFilters\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiorequiredpacketfilters?language=objc)
pub const kIORequiredPacketFilters: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IORequiredPacketFilters\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomulticastaddresslist?language=objc)
pub const kIOMulticastAddressList: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMulticastAddressList\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomulticastfilterdata?language=objc)
pub const kIOMulticastFilterData: &CStr = kIOMulticastAddressList;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkinterfaceclass?language=objc)
pub const kIONetworkInterfaceClass: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkInterface\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdata?language=objc)
pub const kIONetworkData: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkData\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiointerfacetype?language=objc)
pub const kIOInterfaceType: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOInterfaceType\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomaxtransferunit?language=objc)
pub const kIOMaxTransferUnit: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMaxTransferUnit\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediaaddresslength?language=objc)
pub const kIOMediaAddressLength: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMediaAddressLength\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediaheaderlength?language=objc)
pub const kIOMediaHeaderLength: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOMediaHeaderLength\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiointerfaceflags?language=objc)
pub const kIOInterfaceFlags: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOInterfaceFlags\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiointerfaceextraflags?language=objc)
pub const kIOInterfaceExtraFlags: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOInterfaceExtraFlags\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiointerfaceunit?language=objc)
pub const kIOInterfaceUnit: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOInterfaceUnit\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiointerfacestate?language=objc)
pub const kIOInterfaceState: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOInterfaceState\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiointerfacenameprefix?language=objc)
pub const kIOInterfaceNamePrefix: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOInterfaceNamePrefix\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioprimaryinterface?language=objc)
pub const kIOPrimaryInterface: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOPrimaryInterface\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiobuiltin?language=objc)
pub const kIOBuiltin: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOBuiltin\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiolocation?language=objc)
pub const kIOLocation: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"IOLocation\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworknobsdattachkey?language=objc)
pub const kIONetworkNoBSDAttachKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkNoBSDAttach\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkstatskey?language=objc)
pub const kIONetworkStatsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IONetworkStatsKey\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiooutputqueuestatskey?language=objc)
pub const kIOOutputQueueStatsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOOutputQueueStatsKey\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetstatskey?language=objc)
pub const kIOEthernetStatsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IOEthernetStatsKey\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumtype?language=objc)
pub const kIOMediumType: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Type\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumflags?language=objc)
pub const kIOMediumFlags: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Flags\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumspeed?language=objc)
pub const kIOMediumSpeed: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Speed\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumindex?language=objc)
pub const kIOMediumIndex: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Index\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkuserclienttypeid?language=objc)
pub const kIONetworkUserClientTypeID: c_uint = 0xff000001;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionuctype?language=objc)
pub const kIONUCType: c_uint = 0xff000001;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfilterunicast?language=objc)
pub const kIOPacketFilterUnicast: c_uint = 0x1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfilterbroadcast?language=objc)
pub const kIOPacketFilterBroadcast: c_uint = 0x2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfiltermulticast?language=objc)
pub const kIOPacketFilterMulticast: c_uint = 0x10;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfiltermulticastall?language=objc)
pub const kIOPacketFilterMulticastAll: c_uint = 0x20;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfilterpromiscuous?language=objc)
pub const kIOPacketFilterPromiscuous: c_uint = 0x100;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopacketfilterpromiscuousall?language=objc)
pub const kIOPacketFilterPromiscuousAll: c_uint = 0x200;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturenobsdwait?language=objc)
pub const kIONetworkFeatureNoBSDWait: c_uint = 0x001;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturehardwarevlan?language=objc)
pub const kIONetworkFeatureHardwareVlan: c_uint = 0x002;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturesoftwarevlan?language=objc)
pub const kIONetworkFeatureSoftwareVlan: c_uint = 0x004;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturemultipages?language=objc)
pub const kIONetworkFeatureMultiPages: c_uint = 0x008;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturetsoipv4?language=objc)
pub const kIONetworkFeatureTSOIPv4: c_uint = 0x010;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturetsoipv6?language=objc)
pub const kIONetworkFeatureTSOIPv6: c_uint = 0x020;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturetransmitcompletionstatus?language=objc)
pub const kIONetworkFeatureTransmitCompletionStatus: c_uint = 0x040;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturehwtimestamp?language=objc)
pub const kIONetworkFeatureHWTimeStamp: c_uint = 0x080;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeatureswtimestamp?language=objc)
pub const kIONetworkFeatureSWTimeStamp: c_uint = 0x100;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkfeaturelro?language=objc)
pub const kIONetworkFeatureLRO: c_uint = 0x200;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetwakeonmagicpacket?language=objc)
pub const kIOEthernetWakeOnMagicPacket: c_uint = 0x00000001;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kioethernetwakeonpacketaddressmatch?language=objc)
pub const kIOEthernetWakeOnPacketAddressMatch: c_uint = 0x00000002;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdataaccesstyperead?language=objc)
pub const kIONetworkDataAccessTypeRead: c_uint = 0x01;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdataaccesstypewrite?language=objc)
pub const kIONetworkDataAccessTypeWrite: c_uint = 0x02;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdataaccesstypereset?language=objc)
pub const kIONetworkDataAccessTypeReset: c_uint = 0x04;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdataaccesstypeserialize?language=objc)
pub const kIONetworkDataAccessTypeSerialize: c_uint = 0x08;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdataaccesstypemask?language=objc)
pub const kIONetworkDataAccessTypeMask: c_uint = 0xff;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdatabuffertypeinternal?language=objc)
pub const kIONetworkDataBufferTypeInternal: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdatabuffertypeexternal?language=objc)
pub const kIONetworkDataBufferTypeExternal: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkdatabuffertypenone?language=objc)
pub const kIONetworkDataBufferTypeNone: c_uint = 2;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkstackregisterinterfacewithunit?language=objc)
pub const kIONetworkStackRegisterInterfaceWithUnit: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkstackregisterinterfacewithlowestunit?language=objc)
pub const kIONetworkStackRegisterInterfaceWithLowestUnit: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkstackregisterinterfaceall?language=objc)
pub const kIONetworkStackRegisterInterfaceAll: c_uint = 2;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkinterfaceregisteredstate?language=objc)
pub const kIONetworkInterfaceRegisteredState: c_uint = 0x1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkinterfaceopenedstate?language=objc)
pub const kIONetworkInterfaceOpenedState: c_uint = 0x2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworkinterfacedisabledstate?language=objc)
pub const kIONetworkInterfaceDisabledState: c_uint = 0x4;

/// Generic network statistics structure.
/// Field: inputPackets count input packets.
/// Field: inputErrors count input errors.
/// Field: outputPackets count output packets.
/// Field: outputErrors count output errors.
/// Field: collisions count collisions on CDMA networks.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/ionetworkstats?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IONetworkStats {
    pub inputPackets: u32,
    pub inputErrors: u32,
    pub outputPackets: u32,
    pub outputErrors: u32,
    pub collisions: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IONetworkStats {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IONetworkStats {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Statistics recorded by IOOutputQueue objects.
/// Field: capacity queue capacity.
/// Field: size current size of the queue.
/// Field: peakSize peak size of the queue.
/// Field: dropCount number of packets dropped.
/// Field: outputCount number of output packets.
/// Field: retryCount number of retries.
/// Field: stallCount number of queue stalls.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iooutputqueuestats?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOOutputQueueStats {
    pub capacity: u32,
    pub size: u32,
    pub peakSize: u32,
    pub dropCount: u32,
    pub outputCount: u32,
    pub retryCount: u32,
    pub stallCount: u32,
    pub reserved: [u32; 4],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOOutputQueueStats {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[u32; 4]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOOutputQueueStats {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Ethernet MIB statistics structure.
/// Field: alignmentErrors            dot3StatsAlignmentErrors.
/// Field: fcsErrors                  dot3StatsFCSErrors.
/// Field: singleCollisionFrames      dot3StatsSingleCollisionFrames.
/// Field: multipleCollisionFrames    dot3StatsMultipleCollisionFrames.
/// Field: sqeTestErrors              dot3StatsSQETestErrors.
/// Field: deferredTransmissions      dot3StatsDeferredTransmissions.
/// Field: lateCollisions             dot3StatsLateCollisions.
/// Field: excessiveCollisions        dot3StatsExcessiveCollisions.
/// Field: internalMacTransmitErrors  dot3StatsInternalMacTransmitErrors.
/// Field: carrierSenseErrors         dot3StatsCarrierSenseErrors.
/// Field: frameTooLongs              dot3StatsFrameTooLongs.
/// Field: internalMacReceiveErrors   dot3StatsInternalMacReceiveErrors.
/// Field: etherChipSet               dot3StatsEtherChipSet.
/// Field: missedFrames               dot3StatsMissedFrames (not in RFC1650).
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iodot3statsentry?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IODot3StatsEntry {
    pub alignmentErrors: u32,
    pub fcsErrors: u32,
    pub singleCollisionFrames: u32,
    pub multipleCollisionFrames: u32,
    pub sqeTestErrors: u32,
    pub deferredTransmissions: u32,
    pub lateCollisions: u32,
    pub excessiveCollisions: u32,
    pub internalMacTransmitErrors: u32,
    pub carrierSenseErrors: u32,
    pub frameTooLongs: u32,
    pub internalMacReceiveErrors: u32,
    pub etherChipSet: u32,
    pub missedFrames: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IODot3StatsEntry {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IODot3StatsEntry {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Collision statistics structure.
/// Field: collFrequencies            dot3StatsCollFrequencies.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iodot3collentry?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IODot3CollEntry {
    pub collFrequencies: [u32; 16],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IODot3CollEntry {
    const ENCODING: Encoding = Encoding::Struct("?", &[<[u32; 16]>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IODot3CollEntry {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Extra receiver statistics not defined by RFC1650.
/// Field: overruns            receiver overruns.
/// Field: watchdogTimeouts    watchdog timer expirations.
/// Field: frameTooShorts      runt frames.
/// Field: collisionErrors     frames damages by late collision.
/// Field: phyErrors           PHY receive errors.
/// Field: timeouts            receiver timeouts.
/// Field: interrupts          receiver interrupts.
/// Field: resets              receiver resets.
/// Field: resourceErrors      receiver resource shortages.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iodot3rxextraentry?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IODot3RxExtraEntry {
    pub overruns: u32,
    pub watchdogTimeouts: u32,
    pub frameTooShorts: u32,
    pub collisionErrors: u32,
    pub phyErrors: u32,
    pub timeouts: u32,
    pub interrupts: u32,
    pub resets: u32,
    pub resourceErrors: u32,
    pub reserved: [u32; 4],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IODot3RxExtraEntry {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[u32; 4]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IODot3RxExtraEntry {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Extra transmitter statistics not defined by RFC1650.
/// Field: underruns           transmit underruns.
/// Field: jabbers             jabber events.
/// Field: phyErrors           PHY transmit errors.
/// Field: timeouts            transmitter timeouts.
/// Field: interrupts          transmitter interrupts.
/// Field: resets              transmitter resets.
/// Field: resourceErrors      transmitter resource shortages.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iodot3txextraentry?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IODot3TxExtraEntry {
    pub underruns: u32,
    pub jabbers: u32,
    pub phyErrors: u32,
    pub timeouts: u32,
    pub interrupts: u32,
    pub resets: u32,
    pub resourceErrors: u32,
    pub reserved: [u32; 4],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IODot3TxExtraEntry {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[u32; 4]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IODot3TxExtraEntry {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Aggregate Ethernet statistics structure.
/// Field: dot3StatsEntry      IODot3StatsEntry statistics group.
/// Field: dot3CollEntry       IODot3CollEntry statistics group.
/// Field: dot3RxExtraEntry    IODot3RxExtraEntry statistics group.
/// Field: dot3TxExtraEntry    IODot3TxExtraEntry statistics group.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/ioethernetstats?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOEthernetStats {
    pub dot3StatsEntry: IODot3StatsEntry,
    pub dot3CollEntry: IODot3CollEntry,
    pub dot3RxExtraEntry: IODot3RxExtraEntry,
    pub dot3TxExtraEntry: IODot3TxExtraEntry,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOEthernetStats {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <IODot3StatsEntry>::ENCODING,
            <IODot3CollEntry>::ENCODING,
            <IODot3RxExtraEntry>::ENCODING,
            <IODot3TxExtraEntry>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOEthernetStats {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A 32-bit value divided into fields which describes
/// a single medium type.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iomediumtype?language=objc)
pub type IOMediumType = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet?language=objc)
pub const kIOMediumEthernet: c_uint = 32;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernetauto?language=objc)
pub const kIOMediumEthernetAuto: c_uint = 32;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernetmanual?language=objc)
pub const kIOMediumEthernetManual: c_uint = 33;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernetnone?language=objc)
pub const kIOMediumEthernetNone: c_uint = 34;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10baset?language=objc)
pub const kIOMediumEthernet10BaseT: c_uint = 35;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10base2?language=objc)
pub const kIOMediumEthernet10Base2: c_uint = 36;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10base5?language=objc)
pub const kIOMediumEthernet10Base5: c_uint = 37;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet100basetx?language=objc)
pub const kIOMediumEthernet100BaseTX: c_uint = 38;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet100basefx?language=objc)
pub const kIOMediumEthernet100BaseFX: c_uint = 39;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet100baset4?language=objc)
pub const kIOMediumEthernet100BaseT4: c_uint = 40;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet100basevg?language=objc)
pub const kIOMediumEthernet100BaseVG: c_uint = 41;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet100baset2?language=objc)
pub const kIOMediumEthernet100BaseT2: c_uint = 42;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet1000basesx?language=objc)
pub const kIOMediumEthernet1000BaseSX: c_uint = 43;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10basestp?language=objc)
pub const kIOMediumEthernet10BaseSTP: c_uint = 44;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10basefl?language=objc)
pub const kIOMediumEthernet10BaseFL: c_uint = 45;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet1000baselx?language=objc)
pub const kIOMediumEthernet1000BaseLX: c_uint = 46;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet1000basecx?language=objc)
pub const kIOMediumEthernet1000BaseCX: c_uint = 47;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet1000basetx?language=objc)
pub const kIOMediumEthernet1000BaseTX: c_uint = 48;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet1000baset?language=objc)
pub const kIOMediumEthernet1000BaseT: c_uint = 48;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernethomepna1?language=objc)
pub const kIOMediumEthernetHomePNA1: c_uint = 49;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10gbasesr?language=objc)
pub const kIOMediumEthernet10GBaseSR: c_uint = 50;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10gbaselr?language=objc)
pub const kIOMediumEthernet10GBaseLR: c_uint = 51;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10gbasecx4?language=objc)
pub const kIOMediumEthernet10GBaseCX4: c_uint = 52;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet10gbaset?language=objc)
pub const kIOMediumEthernet10GBaseT: c_uint = 53;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet2500baset?language=objc)
pub const kIOMediumEthernet2500BaseT: c_uint = 54;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumethernet5000baset?language=objc)
pub const kIOMediumEthernet5000BaseT: c_uint = 55;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211?language=objc)
pub const kIOMediumIEEE80211: c_uint = 128;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211auto?language=objc)
pub const kIOMediumIEEE80211Auto: c_uint = 128;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211manual?language=objc)
pub const kIOMediumIEEE80211Manual: c_uint = 129;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211none?language=objc)
pub const kIOMediumIEEE80211None: c_uint = 130;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211fh1?language=objc)
pub const kIOMediumIEEE80211FH1: c_uint = 131;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211fh2?language=objc)
pub const kIOMediumIEEE80211FH2: c_uint = 132;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211ds2?language=objc)
pub const kIOMediumIEEE80211DS2: c_uint = 133;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211ds5?language=objc)
pub const kIOMediumIEEE80211DS5: c_uint = 134;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211ds11?language=objc)
pub const kIOMediumIEEE80211DS11: c_uint = 135;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211ds1?language=objc)
pub const kIOMediumIEEE80211DS1: c_uint = 136;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumieee80211optionadhoc?language=objc)
pub const kIOMediumIEEE80211OptionAdhoc: c_uint = 256;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionfullduplex?language=objc)
pub const kIOMediumOptionFullDuplex: c_uint = 1048576;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionhalfduplex?language=objc)
pub const kIOMediumOptionHalfDuplex: c_uint = 2097152;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionflowcontrol?language=objc)
pub const kIOMediumOptionFlowControl: c_uint = 4194304;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptioneee?language=objc)
pub const kIOMediumOptionEEE: c_uint = 8388608;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionflag0?language=objc)
pub const kIOMediumOptionFlag0: c_uint = 16777216;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionflag1?language=objc)
pub const kIOMediumOptionFlag1: c_uint = 33554432;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionflag2?language=objc)
pub const kIOMediumOptionFlag2: c_uint = 67108864;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiomediumoptionloopback?language=objc)
pub const kIOMediumOptionLoopback: c_uint = 134217728;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworklinkvalid?language=objc)
pub const kIONetworkLinkValid: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworklinkactive?language=objc)
pub const kIONetworkLinkActive: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworklinknonetworkchange?language=objc)
pub const kIONetworkLinkNoNetworkChange: c_uint = 4;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionucresetnetworkdataindex?language=objc)
pub const kIONUCResetNetworkDataIndex: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionucwritenetworkdataindex?language=objc)
pub const kIONUCWriteNetworkDataIndex: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionucreadnetworkdataindex?language=objc)
pub const kIONUCReadNetworkDataIndex: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionucgetnetworkdatacapacityindex?language=objc)
pub const kIONUCGetNetworkDataCapacityIndex: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionucgetnetworkdatahandleindex?language=objc)
pub const kIONUCGetNetworkDataHandleIndex: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionuclastindex?language=objc)
pub const kIONUCLastIndex: c_uint = 5;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iondhandle?language=objc)
pub type IONDHandle = u32;

extern "C-unwind" {
    /// Open a connection to an IONetworkInterface object.
    /// An IONetworkUserClient object is created to manage the connection.
    ///
    /// # Safety
    ///
    /// `con` must be a valid pointer.
    #[cfg(feature = "libc")]
    pub fn IONetworkOpen(obj: io_object_t, con: *mut io_connect_t) -> IOReturn;
}

/// Close the connection to an IONetworkInterface object.
#[cfg(feature = "libc")]
#[inline]
pub extern "C-unwind" fn IONetworkClose(con: io_connect_t) -> IOReturn {
    extern "C-unwind" {
        fn IONetworkClose(con: io_connect_t) -> IOReturn;
    }
    unsafe { IONetworkClose(con) }
}

extern "C-unwind" {
    /// Write to the buffer of a network data object.
    ///
    /// Parameter `conObj`: The connection object.
    ///
    /// Parameter `dataHandle`: The handle of a network data object.
    ///
    /// Parameter `srcBuf`: The data to write is taken from this buffer.
    ///
    /// Parameter `inSize`: The size of the source buffer.
    ///
    /// Returns: kIOReturnSuccess on success, or an error code otherwise.
    ///
    /// # Safety
    ///
    /// `src_buf` must be a valid pointer.
    #[cfg(feature = "libc")]
    pub fn IONetworkWriteData(
        con_obj: io_connect_t,
        data_handle: IONDHandle,
        src_buf: *mut u8,
        in_size: u32,
    ) -> IOReturn;
}

extern "C-unwind" {
    /// Read the buffer of a network data object.
    ///
    /// Parameter `conObj`: The connection object.
    ///
    /// Parameter `dataHandle`: The handle of a network data object.
    ///
    /// Parameter `destBuf`: The buffer where the data read shall be written to.
    ///
    /// Parameter `inOutSizeP`: Pointer to an integer that the caller must initialize
    /// to contain the size of the buffer. This function will overwrite
    /// it with the actual number of bytes written to the buffer.
    ///
    /// Returns: kIOReturnSuccess on success, or an error code otherwise.
    ///
    /// # Safety
    ///
    /// - `dest_buf` must be a valid pointer.
    /// - `in_out_size_p` must be a valid pointer.
    #[cfg(feature = "libc")]
    pub fn IONetworkReadData(
        con_obj: io_connect_t,
        data_handle: IONDHandle,
        dest_buf: *mut u8,
        in_out_size_p: *mut u32,
    ) -> IOReturn;
}

/// Fill the buffer of a network data object with zeroes.
///
/// Parameter `conObject`: The connection object.
///
/// Parameter `dataHandle`: The handle of a network data object.
///
/// Returns: kIOReturnSuccess on success, or an error code otherwise.
#[cfg(feature = "libc")]
#[inline]
pub extern "C-unwind" fn IONetworkResetData(
    con_object: io_connect_t,
    data_handle: IONDHandle,
) -> IOReturn {
    extern "C-unwind" {
        fn IONetworkResetData(con_object: io_connect_t, data_handle: IONDHandle) -> IOReturn;
    }
    unsafe { IONetworkResetData(con_object, data_handle) }
}

extern "C-unwind" {
    /// Get the capacity (in bytes) of a network data object.
    ///
    /// Parameter `conObject`: The connection object.
    ///
    /// Parameter `dataHandle`: The handle of a network data object.
    ///
    /// Parameter `capacityP`: Upon success, the capacity is written to this address.
    ///
    /// Returns: kIOReturnSuccess on success, or an error code otherwise.
    ///
    /// # Safety
    ///
    /// `capacity_p` must be a valid pointer.
    #[cfg(feature = "libc")]
    pub fn IONetworkGetDataCapacity(
        con_object: io_connect_t,
        data_handle: IONDHandle,
        capacity_p: *mut u32,
    ) -> IOReturn;
}

extern "C-unwind" {
    /// Get the handle of a network data object with the given name.
    ///
    /// Parameter `conObject`: The connection object.
    ///
    /// Parameter `dataName`: The name of the network data object.
    ///
    /// Parameter `dataHandleP`: Upon success, the handle is written to this address.
    ///
    /// Returns: kIOReturnSuccess on success, or an error code otherwise.
    ///
    /// # Safety
    ///
    /// - `data_name` must be a valid pointer.
    /// - `data_handle_p` must be a valid pointer.
    #[cfg(feature = "libc")]
    pub fn IONetworkGetDataHandle(
        con_object: io_connect_t,
        data_name: *const c_char,
        data_handle_p: *mut IONDHandle,
    ) -> IOReturn;
}

extern "C-unwind" {
    /// Set the packet filters for a given filter group.
    ///
    /// A network controller may support a number of packets filters
    /// that can accept or reject a type of packet seen on the network. A filter
    /// group identifies a set of related filters, such as all filters that will
    /// allow a packet to pass upstream based on the destination address encoded
    /// within the packet. This function allows an user-space program to set the
    /// filtering performed by a given filter group.
    ///
    /// Parameter `connect`: The connection object returned from IONetworkOpen().
    ///
    /// Parameter `filterGroup`: The name of the packet filter group.
    ///
    /// Parameter `filtersMask`: A mask of filters to set.
    ///
    /// Parameter `options`: No options are currently defined.
    ///
    /// Returns: An IOReturn error code.
    ///
    /// # Safety
    ///
    /// `filter_group` Array TODO.
    #[cfg(feature = "libc")]
    pub fn IONetworkSetPacketFiltersMask(
        connect: io_connect_t,
        filter_group: io_name_t,
        filters_mask: u32,
        options: IOOptionBits,
    ) -> IOReturn;
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kionetworksupportedpacketfilters?language=objc)
pub const kIONetworkSupportedPacketFilters: c_uint = 0x0001;

extern "C-unwind" {
    /// Get the packet filters for a given filter group.
    ///
    /// A network controller may support a number of packets filters
    /// that can accept or reject a type of packet seen on the network. A filter
    /// group identifies a set of related filters, such as all filters that will
    /// allow a packet to pass upstream based on the destination address encoded
    /// within the packet. This function allows an user-space program to get the
    /// filtering performed by a given filter group.
    ///
    /// Parameter `connect`: The connection object returned from IONetworkOpen().
    ///
    /// Parameter `filterGroup`: The name of the packet filter group.
    ///
    /// Parameter `filtersMask`: Pointer to the return value containing a mask of
    /// packet filters.
    ///
    /// Parameter `options`: kIONetworkSupportedPacketFilters may be set to fetch the
    /// filters that are supported by the hardware.
    ///
    /// Returns: An IOReturn error code.
    ///
    /// # Safety
    ///
    /// - `filter_group` Array TODO.
    /// - `filters_mask` must be a valid pointer.
    #[cfg(feature = "libc")]
    pub fn IONetworkGetPacketFiltersMask(
        connect: io_connect_t,
        filter_group: io_name_t,
        filters_mask: *mut u32,
        options: IOOptionBits,
    ) -> IOReturn;
}
