/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;

public class ExponentialBackoff<S extends Signal> {
    private static final int CAP_FACTOR = 100;
    private static final long SLOT_TIME = 25L;
    private final Random random = new Random();
    private final S signal;
    private final long slotTime;
    private final int timeoutMs;
    private CountdownTimer timer;

    public static ExponentialBackoff<Signal> of(int amount, TimeUnit unit) {
        return ExponentialBackoff.of(amount, unit, Signal.SLEEP);
    }

    public static <T extends Signal> ExponentialBackoff<T> of(int amount, TimeUnit unit, T signal) {
        return new ExponentialBackoff<T>((int)TimeUnit.MILLISECONDS.convert(amount, unit), signal, 25L);
    }

    public static ExponentialBackoff<Signal> of(int amount, TimeUnit unit, int slotTime, TimeUnit slotTimeUnit) {
        return new ExponentialBackoff<Signal>((int)TimeUnit.MILLISECONDS.convert(amount, unit), Signal.SLEEP, TimeUnit.MILLISECONDS.convert(slotTime, slotTimeUnit));
    }

    private ExponentialBackoff(int timeoutMs, S signal, long slotTime) {
        this.timeoutMs = timeoutMs;
        this.signal = signal;
        this.slotTime = slotTime;
        this.restartTimer();
    }

    public void restartTimer() {
        this.timer = Time.startCountdownTimer(this.timeoutMs);
    }

    public <T> T retryUntil(Query<T> query) throws IOException, InterruptedException {
        Result<T> result;
        int iteration = 0;
        while (!(result = query.run()).isSuccessful() && !this.timer.hasExpired()) {
            boolean signaled;
            if (!(signaled = this.signal.await(this.backoffPeriodFor(++iteration)))) continue;
            iteration = 0;
        }
        return result.getValue();
    }

    long backoffPeriodFor(int iteration) {
        return (long)this.random.nextInt(Math.min(iteration, 100)) * this.slotTime;
    }

    public CountdownTimer getTimer() {
        return this.timer;
    }

    public S getSignal() {
        return this.signal;
    }

    public static interface Signal {
        public static final Signal SLEEP = new Signal(){

            @Override
            public boolean await(long period) throws InterruptedException {
                Thread.sleep(period);
                return false;
            }
        };

        public boolean await(long var1) throws InterruptedException;
    }

    public static interface Query<T> {
        public Result<T> run() throws IOException, InterruptedException;
    }

    public static abstract class Result<T> {
        public abstract boolean isSuccessful();

        public abstract T getValue();

        public static <T> Result<T> successful(final T value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            return new Result<T>(){

                @Override
                public boolean isSuccessful() {
                    return true;
                }

                @Override
                public T getValue() {
                    return value;
                }
            };
        }

        public static <T> Result<T> notSuccessful(final T value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            return new Result<T>(){

                @Override
                public boolean isSuccessful() {
                    return false;
                }

                @Override
                public T getValue() {
                    return value;
                }
            };
        }
    }
}

