/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.services;

import javax.inject.Inject;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.InPlaceClasspathBuilder;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForAgent;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForLegacy;
import org.gradle.internal.classpath.types.GradleCoreInstrumentationTypeRegistry;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.vfs.FileSystemAccess;

public abstract class InjectedInstrumentationServices {
    private final Lazy<ClasspathElementTransformFactoryForAgent> transformFactory = Lazy.locking().of(() -> new ClasspathElementTransformFactoryForAgent(new InPlaceClasspathBuilder(), this.getClasspathWalker()));
    private final Lazy<ClasspathElementTransformFactoryForLegacy> legacyTransformFactory = Lazy.locking().of(() -> new ClasspathElementTransformFactoryForLegacy(new InPlaceClasspathBuilder(), this.getClasspathWalker()));

    @Inject
    public abstract ClasspathWalker getClasspathWalker();

    @Inject
    public abstract FileSystemAccess getFileSystemAccess();

    @Inject
    public abstract GradleCoreInstrumentationTypeRegistry getGradleCoreInstrumentationTypeRegistry();

    @Inject
    public abstract GlobalCacheLocations getGlobalCacheLocations();

    @Inject
    public abstract StringInterner getStringInterner();

    public ClasspathElementTransformFactory getTransformFactory(boolean isAgentSupported) {
        return isAgentSupported ? (ClasspathElementTransformFactory)this.transformFactory.get() : (ClasspathElementTransformFactory)this.legacyTransformFactory.get();
    }
}

