#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.samba.sh.in,v 1.5 2006/12/21 02:27:25 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:
# This contains all of the functions specific to the user sub-system.

smbhostadd() {
	[ -z "${modulename}" ] && modulename="smbhostadd"
	unset OPTION OPTARG OPTIND
	while getopts "r:" OPTION; do
		case "${OPTION}" in
			r) HOSTRID="${OPTARG}";;
			*) print_usage ${modulename} ; exit 1;;
		esac
		#p) POSIXACCOUNT="yes";;
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename} 
		exit 2
	else
		NAME="${1%\$}"
	fi

	if [ -n "${HOSTRID}" ]; then
		echo "${HOSTRID}" | ${GREP} -qs "^[[:digit:]]*$"
		if [ "$?" -ne 0 ]; then
			echo "${modulename}: Invalid numeric argument \"${HOSTRID}\""
			exit 3
		fi
		search_smbhost "sambaSID" "${SAMBADOMAINSID}-${HOSTRID}"
		if [ "$?" -eq 0 ]; then
			echo "${modulename}: uid ${HOSTRID} is not unique"
			exit 4
		fi
	else
		HOSTRID="${SAMBAHOSTRIDMIN}"
		while [ "${HOSTRID}" -le "${SAMBAHOSTRIDMAX}" ]; do
			search_smbhost "sambaSID" "${SAMBADOMAINSID}-${HOSTRID}"
			[ "$?" -ne 0 ] && break
			let HOSTRID="${HOSTRID} + 1"
		done
	fi

	append "dn: uid=${NAME}\$,${SAMBAHOST_BASEDN}"
	append "changetype: add"
	append "objectClass: sambaSidEntry"
	append "objectClass: sambaSamAccount"
	append "uid: ${NAME}\$"
	append "sambaSID: ${SAMBADOMAINSID}-${HOSTRID}"
	append "sambaAcctFlags: [W          ]"
	LMPASS="$(${MKPASSWD} -l ${NAME}\$)"
	NTPASS="$(${MKPASSWD} -n ${NAME}\$)"
	append "sambaLMPassword: ${LMPASS}"
	append "sambaNTPassword: ${NTPASS}"

	# from IDEALX scripts
	append "sambaPrimaryGroupSID: ${SAMBADOMAINSID}-0"
	append "sambaBadPasswordCount: 0"
	append "sambaBadPasswordTime: 0"

	let CANCHANGE="$(${DATE} -u +%s)"
	let MUSTCHANGE="${CANCHANGE} + 1814400"
	# leave password rotation alone for now
	# all of the following are UNIX timestamps
	append "sambaPwdCanChange: 0"
	append "sambaPwdMustChange: 0"
	append "sambaPwdLastSet: 0"
	append "sambaLogonTime: 0"
	append "sambaLogoffTime: 2147483647"
	append "sambaKickoffTime: 2147483647"
	append "\n\n"

	runmodify
}

smbhostdel() {
	[ -z "${modulename}" ] && modulename="smbhostdel"
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		NAME="${1%\$}"
	fi
	NAME_DOLLAR="${NAME}\$"
	search_smbhost "uid" "${NAME_DOLLAR}"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: Machine \"${NAME}\" does not exist"
		exit 6
	fi
	append_dn_delete "uid=${NAME_DOLLAR},${SAMBAHOST_BASEDN}"
	runmodify
}
