/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.AttributeImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;

final class AttributeEnumeration
implements AxisEnumeration {
    private ElementImpl element;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;
    private int last = -1;

    public AttributeEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (nodeImpl.getNodeType() == 1) {
            this.element = (ElementImpl)nodeImpl;
            AttributeCollection attributeCollection = this.element.getAttributeList();
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest nameTest = (NameTest)nodeTest;
                this.index = attributeCollection.getIndexByFingerprint(nameTest.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = new AttributeImpl(this.element, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attributeCollection.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasMoreElements() {
        return this.next != null;
    }

    public NodeInfo nextElement() {
        NodeInfo nodeInfo = this.next;
        this.advance();
        return nodeInfo;
    }

    private void advance() {
        do {
            if (this.index < this.length) {
                this.next = new AttributeImpl(this.element, this.index);
                ++this.index;
                continue;
            }
            this.next = null;
            return;
        } while (!this.nodeTest.matches(this.next));
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return true;
    }

    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        AttributeEnumeration attributeEnumeration = new AttributeEnumeration(this.element, this.nodeTest);
        this.last = 0;
        while (attributeEnumeration.hasMoreElements()) {
            attributeEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

