# Copyright 2022-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
PYPI_VERIFY_REPO=https://github.com/mgeier/insipid-sphinx-theme
PYTHON_COMPAT=( python3_{11..13} pypy3_11 )

inherit distutils-r1 pypi

DESCRIPTION="Insipid Sphinx theme"
HOMEPAGE="
	https://pypi.org/project/insipid-sphinx-theme/
	https://github.com/mgeier/insipid-sphinx-theme/
"

LICENSE="BSD-2"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="
	>=dev-python/jinja2-2.11[${PYTHON_USEDEP}]
	>=dev-python/sphinx-5[${PYTHON_USEDEP}]
	>=dev-python/docutils-0.18[${PYTHON_USEDEP}]
"
BDEPEND="
	dev-python/setuptools-scm[${PYTHON_USEDEP}]
"

DOCS=( {CONTRIBUTING,NEWS,README}.rst )

# needs sphinx_last_updated_by_git
#distutils_enable_sphinx "doc"
