// Ripped from https://github.com/Ch0pin/medusa/ and modified to fit Androguard packets

colorLog('[+] LOADING SOCKETS/SOCKETS.JS',{c: Color.Red});

var socket = Java.use('java.net.Socket');

socket.$init.overloads[2].implementation = function(socketImpl){
    agPacket({hostname: socketImpl.address.getHostName(), port: port}).send();
    return this.$init(host, port);
}

socket.$init.overloads[3].implementation = function(inetAddress, port){
    agPacket({hostname: inetAddress.getHostName(), port: port}).send();
    return this.$init(inetAddress,port);
}

socket.$init.overloads[4].implementation = function(host, port){
    agPacket({hostname: host, port: port}).send();
    return this.$init(host,port);
}

socket.$init.overloads[5].implementation = function(host, port, stream){
    agPacket({hostname: host, port: port}).send();
    return this.$init(host, port, stream);
}

socket.$init.overloads[6].implementation = function(inetAddress, port, localAddress, localPort){
    agPacket({hostname: inetAddress.getHostName(), port: port}).send();
    return this.$init(inetAddress, port, localAddress, localPort);
}

socket.$init.overloads[7].implementation = function(inetAddress, port, socketAddress, stream){
    agPacket({hostname: inetAddress.getHostName(), port: port}).send();
    return this.$init(inetAddress, port, socketAddress, stream);
}

socket.$init.overloads[8].implementation = function(inetAddress, port, localAddress, localPort){
    agPacket({hostname: inetAddress.getHostName(), port: port}).send();
    return this.$init(inetAddress, port, localAddress, localPort);
}

socket.bind.implementation = function(localAddress){
    agPacket({hostname: localAddress.toString()}).send();
    this.bind.call(this, localAddress);
}

// Socket.connect(endPoint)
socket.connect.overload("java.net.SocketAddress").implementation = function(endPoint){
    agPacket({endpoint: endPoint.toString()}).send();
    this.connect.overload("java.net.SocketAddress").call(this, endPoint);
}

// Socket.connect(endPoint, timeout)
socket.connect.overload("java.net.SocketAddress", "int").implementation = function(endPoint, tmout){
    agPacket({endpoint: endPoint.toString()}).send();
    this.connect.overload("java.net.SocketAddress", "int").call(this, endPoint, tmout);
}

// Socket.getInetAddress()
socket.getInetAddress.implementation = function(){
    ret = sock.getInetAddress.call(this);
    agPacket({ret: ret.toString()}).send();
    return ret;
}

// Socket.getInputStream()
socket.getInputStream.implementation = function(){
    agPacket({}).send();
    return this.getInputStream.call(this);
}

// Socket.getOutputStream()
socket.getOutputStream.implementation = function(){
    agPacket({}).send();
    return this.getOutputStream.call(this);
}

var WebSocketClient = tryGetClass('org.java_websocket.client.WebSocketClient');
if (WebSocketClient) {
    WebSocketClient.$init.overloads[0].implementation = function(uri){
        agPacket({uri: uri}).send();
        return this.$init(uri);
    }

    WebSocketClient.$init.overloads[1].implementation = function(uri,draft){
        agPacket({uri: uri}).send();
        return this.$init(uri,draft);
    }

    WebSocketClient.$init.overloads[2].implementation = function(uri,headers){
        agPacket({uri: uri}).send();
        return this.$init(uri,headers);
    }

    WebSocketClient.$init.overloads[3].implementation = function(uri,draft,headers){
        agPacket({uri: uri}).send();
        return this.$init(uri,draft,headers);
    }

    WebSocketClient.$init.overloads[4].implementation = function(uri,draft,headers,connecttimeout){
        agPacket({uri: uri}).send();
        return this.$init(uri,draft,headers,connecttimeout);
    }

    WebSocketClient.send.overloads[0].implementation = function(byteArray) {
        agPacket({data: byteArrayToString(byteArray)}).send();
        this.send(byteArray);
    }

    WebSocketClient.send.overloads[0].implementation = function(byteBuffers){
        agPacket({data: byteBuffers}).send();
        this.send(byteBuffers);
    }

    WebSocketClient.send.overloads[0].implementation = function(str){
        agPacket({uri: his.getURI(), data: str}).send();
        this.send(str);
    }
}
