---
title: bibiman.toml
section: 5
header: User Manual bibiman.toml config file
footer: bibiman 0.19.1
date: 2025-12-26
---

# NAME

bibiman.toml - Configuration file for bibiman

# SYNOPSIS

`$XDG_CONFIG_HOME/bibiman/bibiman.toml`

`$HOME/.config/bibiman/bibiman.toml`

# DESCRIPTION

bibiman.toml is the configuration file for bibiman, a TUI for interacting with
BibLaTeX databases. The file uses TOML format and allows customization of
general behavior, file paths, and color schemes.

# FILE LOCATION

The configuration file is searched in the following order:

> 1. Path specified with **--config-file** command line option
>
> 2. $XDG_CONFIG_HOME/bibiman/bibiman.toml
>
> 3. $HOME/.config/bibiman/bibiman.toml

If none exists, bibiman will offer to create a default configuration file.

# SECTIONS

## [general] Section

Contains general configuration options.

**bibfiles** = ARRAY

: Array of default files/directories to load on startup. Use absolute paths (~
  for HOME works).

**editor** = STRING|ARRAY

: Default editor to use when editing files. Arguments are possible and have to
  be passed as array, e.g. "editor = { command = "vim", args = [ "-y" ] }". If
  not set, uses VISUAL and EDITOR environment variables, falling back to "vi".

**pdf_opener** = STRING

: Default application to open PDFs/Epubs files.

**url_opener** = STRING

: Default application to open URLs/DOIs.

**file_prefix** = PATH

: Prefix prepended to filepaths from the \`file\` field in bib entries. Use
  absolute paths (~ for HOME works).

**pdf_path** = PATH

: Path to folder (with subfolders) containing PDF files with the basename format
  "citekey.pdf". Use absolute paths (~ for HOME works).

**note_path** = PATH

: Path to folder containing note files with the basename "citekey.extension".
  Use absolute paths (~ for HOME works).

**note_extensions** = ARRAY

: Array of valid file extensions for note files.

**file_symbol** = CHAR|STRING

: Symbol to show if entry has attached file.

**link_symbol** = CHAR|STRING

: Symbol to show if entry has URL/DOI link.

**note_symbol** = CHAR|STRING

: Symbol to show if entry has note file.

**custom_column** = STRING

: Select a custom column beside standard `author`, `title` and `year`. Possible
  values:

>  * journaltitle: Lists the title of the journal
>  * organization: Name of the organization
>  * institution: Name of the institution
>  * series: Title of the book series
>  * publisher: Name of the publisher
>  * pubtype: BibLaTex pubtype (article, book, incollection, etc.)

**formatter** = STRING|ARRAY

: External command to format entries added via DOI. Arguments are possible and
  have to be passed as array, e.g. "editor = { command = "tex-fmt", args = [
  "--stdin", "--tabsize=8" ] }". The command must read from stdin and print to
  stdout.

**clipboard** = STRING|COMMAND

: Explicitly choose the used clipboard. Possible values:

>  * wayland
>  * x-clip
>  * x-sel
>  * pasteboard
>  * tmux
>  * win32-yank

### [general.clipboard.custom] subsection

**paste = STRING|ARRAY**

: Set a custom clipboard command. "paste" key here means pasting to the clipboard. Thus, the copy-command of the clipboard binary is needed. As example:

> **paste = { command = "wl-copy", args = [ "--type", "text/plain"] }**

## [colors] Section

Contains color configuration for the TUI. Colors can be set using:

> - ANSI color names (e.g., "darkgray", "light_black")
>
> - 256-color indices (e.g., "237")
>
> - HEX codes (e.g., "#3a3a3a")

**main_text_color** = 250
: Main text color

**highlight_text_color** = 254
: Highlighted text color

**entry_color** = 36
: Entry list color

**keyword_color** = 101
: Keyword color

**info_color** = 99
: Info window color

**confirm_color** = 47
: Confirmation message color

**warn_color** = 124
: Warning message color

**bar_bg_color** = 234
: Status bar background color

**popup_fg_color** = 43
: Popup foreground color

**popup_bg_color** = 234
: Popup background color

**selected_row_bg_color** = 237
: Selected row background color

**note_color** = 123
: Note file color

**file_color** = 209
: PDF file color

**link_color** = 27
: URL/DOI link color

**author_color** = 38
: Author column color

**title_color** = 37
: Title column color

**year_color** = 135
: Year column color

## [citekey_formatter] Section

**fields** = ARRAY
: The main aspect for generating citekeys are the field patterns. They can be
  set through an array in the config file where every array-item represents a
  single BibLaTeX field to be used for generating a part of the citekey. Every
  field pattern consists of the following five parts separated by semicolons.
  The general pattern looks like this (every subfield is explained below):
  *biblatex field name* **;** *max word count* **;** *max char count* **;**
  *inner delimiter* **;** *trailing delimiter* For example, to use the `title`
  field, print maximal three words and of those only the first five chars,
  single words separated by underscore and the whole field separated by equal
  sign, insert the following pattern field into the `fields` array:
  `title;3;5;_;=`

### Ignore Lists and Char Case

Beside the field patterns there are some other options to define how citekeys
should be built.

**ascii_only** = BOOL
: If set to `true`, which is the default, non-ascii chars are mapped to their
  ascii equivalent. For example, the German `ä` would be mapped to `a`. The
  Turkish `ş` or Greek `σ`/`ς` would be mapped to `s`. If set to `false` all are
  kept as they are. But this could lead to errors running LaTeX on the file.

**case** = STRING
: If used, sets the case of the chars in the citekey. Valid values are
  `uppercase`, `lowercase` or `camelcase`. Both first should be clear, the
  latter means typical camel case also beginning the *first word* with an
  uppercase letter; also referenced as upper camel case or Pascal case.

**ignored_chars** = ARRAY
: Defines chars which should be ignored during parsing (meaning not print them).
  The default list contains 33 special chars and is part of the default config
  file (in out-commented state). Be aware, setting this key will completely
  overwrite the default list!

**ignored_words** = ARRAY
: A list of words which should be ignored parsing field values. The default list
  contains about 20 very commonly used words in English and German; like
  articles, pronouns or connector words. Like with `ignored_chars` setting this
  key will completely overwrite the default list!

# EXAMPLES

A minimal configuration file:

```
[general]
bibfiles = ["~/Documents/biblio/main.bib"]
editor = "nvim"
pdf_opener = "zathura"
url_opener = "firefox"
```

A full configuration with custom colors:

```
[general]
bibfiles = ["~/papers/bibliography", "~/refs/important.bib"]
editor = "emacs -nw"
pdf_opener = "mupdf"
url_opener = "qutebrowser"
file_prefix = "~/Documents/literature"
pdf_path = "~/papers/pdfs"
note_path = "~/papers/notes"
note_extensions = ["md", "txt", "org"]
file_symbol = ""
link_symbol = ""
note_symbol = ""
custom_column = "journaltitle"

[colors]
main_text_color = "#ffffff"
highlight_text_color = "#ffff00"
entry_color = "cyan"
selected_row_bg_color = "#444444"

[citekey_formatter]
fields = [
  "shorthand;;;;+",
  "entrytype;;;;:",
  "author;2;;-;_",
  "title;3;6;=;_",
  "year",
  "publisher;;5;#;"
]
case = "lowercase"
ascii_only = true
```

# SEE ALSO

**bibiman**(1)

# AUTHOR

Lukeflo \<lukeflo\_git@posteo.de>
