import * as React from 'react';
import { Simplify } from '@mui/types';
import Popper, { PopperProps } from '../Popper';
import { PolymorphicProps, SlotComponentProps } from '../utils';
import { UseMenuListboxSlotProps } from '../useMenu';
import { ListAction } from '../useList';
export interface MenuRootSlotPropsOverrides {
}
export interface MenuListboxSlotPropsOverrides {
}
export interface MenuActions {
    /**
     * Dispatches an action that can cause a change to the menu's internal state.
     */
    dispatch: (action: ListAction<string>) => void;
    /**
     * Resets the highlighted item.
     */
    resetHighlight: () => void;
}
export interface MenuOwnProps {
    /**
     * A ref with imperative actions that can be performed on the menu.
     */
    actions?: React.Ref<MenuActions>;
    /**
     * An HTML element, [virtualElement](https://popper.js.org/docs/v2/virtual-elements/),
     * or a function that returns either.
     * It's used to set the position of the popper.
     */
    anchorEl?: PopperProps['anchorEl'];
    children?: React.ReactNode;
    className?: string;
    defaultOpen?: boolean;
    listboxId?: string;
    /**
     * Function called when the items displayed in the menu change.
     */
    onItemsChange?: (items: string[]) => void;
    /**
     * Triggered when focus leaves the menu and the menu should close.
     */
    onOpenChange?: (open: boolean) => void;
    /**
     * Controls whether the menu is displayed.
     * @default false
     */
    open?: boolean;
    /**
     * The props used for each slot inside the Menu.
     * @default {}
     */
    slotProps?: {
        root?: SlotComponentProps<typeof Popper, MenuRootSlotPropsOverrides, MenuOwnerState>;
        listbox?: SlotComponentProps<'ul', MenuListboxSlotPropsOverrides, MenuOwnerState>;
    };
    /**
     * The components used for each slot inside the Menu.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    slots?: MenuSlots;
}
export interface MenuSlots {
    /**
     * The component that renders the root.
     * @default Popper
     */
    root?: React.ElementType;
    /**
     * The component that renders the listbox.
     * @default 'ul'
     */
    listbox?: React.ElementType;
}
export interface MenuTypeMap<AdditionalProps = {}, RootComponentType extends React.ElementType = 'ul'> {
    props: MenuOwnProps & AdditionalProps;
    defaultComponent: RootComponentType;
}
export type MenuProps<RootComponentType extends React.ElementType = MenuTypeMap['defaultComponent']> = PolymorphicProps<MenuTypeMap<{}, RootComponentType>, RootComponentType>;
export type MenuOwnerState = Simplify<MenuOwnProps & {
    open: boolean;
}>;
export type MenuRootSlotProps = {
    anchorEl: PopperProps['anchorEl'];
    children?: React.ReactNode;
    className?: string;
    keepMounted: PopperProps['keepMounted'];
    open: boolean;
    ownerState: MenuOwnerState;
    ref: React.Ref<any>;
};
export type MenuListboxSlotProps = UseMenuListboxSlotProps & {
    className: string | undefined;
    ownerState: MenuOwnerState;
};
