"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reactiveOptionKeys = exports.positionOldToNew = exports.positionNewToOld = exports.positionColumnOldToNew = exports.positionColumnNewToOld = exports.isObject = exports.isNumber = exports.isLineColumnPosition = exports.isLineColumnAbsolutePosition = exports.isInteger = exports.isAbsolutePosition = exports.defaultOptions = exports.defaultLineNumberFormatter = exports.defaultAutocompleteTriggerStrings = exports.createEventHandlers = exports.THEME_LIGHT = exports.THEME_DARK = exports.THEME_AUTO = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
const _excluded = ["line", "column"],
  _excluded2 = ["line", "column"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
const THEME_LIGHT = "light";
exports.THEME_LIGHT = THEME_LIGHT;
const THEME_DARK = "dark";
exports.THEME_DARK = THEME_DARK;
const THEME_AUTO = "auto";
exports.THEME_AUTO = THEME_AUTO;
const defaultLineNumberFormatter = (line, lineCount) => {
  if (lineCount === 1) {
    return "$";
  } else {
    return line;
  }
};
exports.defaultLineNumberFormatter = defaultLineNumberFormatter;
const defaultAutocompleteTriggerStrings = [".", ":", "[]", "()", "{}", "[", "(", "{", "$"];
exports.defaultAutocompleteTriggerStrings = defaultAutocompleteTriggerStrings;
const defaultOptions = {
  autocomplete: true,
  autocompleteCloseOnBlur: true,
  autocompleteOpen: false,
  autocompleteTriggerStrings: defaultAutocompleteTriggerStrings,
  autofocus: true,
  autofocusProps: ["cursorWide", "position", "readOnly", "selection", "value"],
  bracketMatching: true,
  clearHistoryProps: ["cypherLanguage"],
  closeBrackets: true,
  cursorWide: true,
  cypherLanguage: true,
  history: true,
  indentUnit: "  ",
  lineNumberFormatter: defaultLineNumberFormatter,
  lineNumbers: true,
  lineWrapping: false,
  lint: false,
  parseOnSetValue: true,
  placeholder: undefined,
  position: undefined,
  readOnly: false,
  readOnlyCursor: false,
  schema: undefined,
  search: true,
  searchMatches: 0,
  searchOpen: false,
  searchText: "",
  searchTop: false,
  selection: undefined,
  tabKey: true,
  theme: THEME_LIGHT,
  tooltipAbsolute: true,
  value: "",
  preExtensions: [],
  postExtensions: []
};
exports.defaultOptions = defaultOptions;
const reactiveOptionKeys = ["autocomplete", "autocompleteCloseOnBlur", "autocompleteOpen", "autocompleteTriggerStrings", "bracketMatching", "closeBrackets", "cursorWide", "cypherLanguage",
// "autofocus",
"history", "indentUnit", "lineNumberFormatter", "lineNumbers", "lineWrapping", "lint", "placeholder", "position", "readOnly", "readOnlyCursor", "schema", "search", "searchMatches", "searchOpen", "searchText", "searchTop", "selection", "tabKey", "theme", "tooltipAbsolute",
// "parseOnSetValue",
"value", "preExtensions", "postExtensions"];
exports.reactiveOptionKeys = reactiveOptionKeys;
const isNumber = v => v !== undefined && (typeof v === "number" || v instanceof Number) && isFinite(v);
exports.isNumber = isNumber;
const isInteger = v => isNumber(v) && v % 1 === 0;
exports.isInteger = isInteger;
const isObject = v => typeof v === "object" && v !== null;
exports.isObject = isObject;
const isAbsolutePosition = v => isInteger(v) && v >= 0;
exports.isAbsolutePosition = isAbsolutePosition;
const isLineColumnPosition = v => isObject(v) && isInteger(v.line) && v.line >= 1 && isInteger(v.column) && v.column >= 0;
exports.isLineColumnPosition = isLineColumnPosition;
const isLineColumnAbsolutePosition = v => isObject(v) && isInteger(v.position) && v.position >= 0;
exports.isLineColumnAbsolutePosition = isLineColumnAbsolutePosition;
const positionColumnNewToOld = _ref => {
  let {
      line,
      column
    } = _ref,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return _objectSpread({
    line,
    column: column - 1
  }, rest);
};
exports.positionColumnNewToOld = positionColumnNewToOld;
const positionColumnOldToNew = _ref2 => {
  let {
      line,
      column
    } = _ref2,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  return _objectSpread({
    line,
    column: column + 1
  }, rest);
};
exports.positionColumnOldToNew = positionColumnOldToNew;
const positionNewToOld = positionValue => isLineColumnPosition(positionValue) ? positionColumnNewToOld(positionValue) : positionValue;
exports.positionNewToOld = positionNewToOld;
const positionOldToNew = positionValue => isLineColumnPosition(positionValue) ? positionColumnOldToNew(positionValue) : positionValue;
exports.positionOldToNew = positionOldToNew;
const createEventHandlers = () => {
  const listeners = [];
  const off = listener => {
    const index = listeners.findIndex(l => l === listener);
    if (index >= 0) {
      listeners.splice(index, 1);
      return true;
    }
    return false;
  };
  const on = listener => {
    listeners.push(listener);
    return () => {
      off(listener);
    };
  };
  const fire = (...args) => {
    for (let listener of listeners) {
      listener(...args);
    }
  };
  const count = () => {
    return listeners.length;
  };
  return {
    on,
    off,
    listeners,
    fire,
    count
  };
};
exports.createEventHandlers = createEventHandlers;