"use strict";
exports.el = void 0;
var _index = require("./el/_lib/formatDistance.js");
var _index2 = require("./el/_lib/formatLong.js");
var _index3 = require("./el/_lib/formatRelative.js");
var _index4 = require("./el/_lib/localize.js");
var _index5 = require("./el/_lib/match.js");

/**
 * @category Locales
 * @summary Greek locale.
 * @language Greek
 * @iso-639-2 ell
 * @author Fanis Katsimpas [@fanixk](https://github.com/fanixk)
 * @author Theodoros Orfanidis [@teoulas](https://github.com/teoulas)
 */
const el = (exports.el = {
  code: "el",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
