-- Copyright 2026 Specter Ops, Inc.
--
-- Licensed under the Apache License, Version 2.0
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--
-- SPDX-License-Identifier: Apache-2.0
-- Code generated by Cuelang code gen. DO NOT EDIT!
-- Cuelang source: github.com/specterops/bloodhound/-/tree/main/packages/cue/schemas/
CREATE OR REPLACE FUNCTION genscript_upsert_kind(node_kind_name TEXT) RETURNS void AS $$
BEGIN
    IF NOT EXISTS (SELECT id FROM kind WHERE kind.name = node_kind_name) THEN
        INSERT INTO kind (name) VALUES (node_kind_name);
    END IF;
END $$ LANGUAGE plpgsql;
	
CREATE OR REPLACE FUNCTION genscript_upsert_source_kind(kind_name TEXT) RETURNS void AS $$
DECLARE
	retrieved_kind_id SMALLINT;
BEGIN
	SELECT k.id INTO retrieved_kind_id FROM kind k WHERE k.name = kind_name;
	IF retrieved_kind_id IS NULL THEN
		INSERT INTO kind (name) VALUES (kind_name)
		RETURNING id INTO retrieved_kind_id;
	END IF;
    IF NOT EXISTS (SELECT sk.id FROM source_kinds sk WHERE sk.kind_id = retrieved_kind_id) THEN
        INSERT INTO source_kinds (kind_id) VALUES (retrieved_kind_id);
    END IF;
END $$ LANGUAGE plpgsql;
	
CREATE OR REPLACE FUNCTION genscript_upsert_schema_node_kind(v_extension_id INT, v_kind_name VARCHAR(256), v_display_name TEXT, v_description TEXT, v_is_display_kind BOOLEAN, v_icon TEXT, v_icon_color TEXT) RETURNS void AS $$
DECLARE
	retrieved_kind_id SMALLINT;
BEGIN
	SELECT id INTO retrieved_kind_id FROM kind WHERE name = v_kind_name;
	IF retrieved_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT id FROM schema_node_kinds nk WHERE nk.kind_id = retrieved_kind_id) THEN
		INSERT INTO schema_node_kinds (schema_extension_id, kind_id, display_name, description, is_display_kind, icon, icon_color) VALUES (v_extension_id, retrieved_kind_id, v_display_name, v_description, v_is_display_kind, v_icon, v_icon_color);
	ELSE
		UPDATE schema_node_kinds SET display_name = v_display_name, description = v_description, is_display_kind = v_is_display_kind, icon = v_icon, icon_color = v_icon_color WHERE kind_id = retrieved_kind_id;
	END IF;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION genscript_upsert_schema_relationship_kind(v_extension_id INT, v_kind_name VARCHAR(256), v_description TEXT, v_is_traversable BOOLEAN) RETURNS void AS $$
DECLARE
	retrieved_kind_id SMALLINT;
BEGIN
	SELECT id INTO retrieved_kind_id FROM kind WHERE name = v_kind_name;
	IF retrieved_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT id FROM schema_relationship_kinds ek WHERE ek.kind_id = retrieved_kind_id) THEN
		INSERT INTO schema_relationship_kinds (schema_extension_id, kind_id, description, is_traversable) VALUES (v_extension_id, retrieved_kind_id, v_description, v_is_traversable);
	ELSE
		UPDATE schema_relationship_kinds SET description = v_description, is_traversable = v_is_traversable WHERE kind_id = retrieved_kind_id;
	END IF;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION genscript_upsert_schema_environments(v_extension_id INT, v_environment_kind_name VARCHAR(256), v_source_kind_name VARCHAR(256)) RETURNS INTEGER AS $$
DECLARE
	retrieved_environment_kind_id SMALLINT;
	retrieved_source_kind_id SMALLINT;
	schema_environment_id INTEGER;
BEGIN
	SELECT id INTO retrieved_environment_kind_id FROM kind WHERE name = v_environment_kind_name;
	IF retrieved_environment_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;

	SELECT sk.id INTO retrieved_source_kind_id FROM source_kinds sk JOIN kind k ON sk.kind_id = k.id WHERE k.name = v_source_kind_name;
	IF retrieved_source_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT id FROM schema_environments se WHERE se.schema_extension_id = v_extension_id) THEN
		INSERT INTO schema_environments (schema_extension_id, environment_kind_id, source_kind_id) VALUES (v_extension_id, retrieved_environment_kind_id, retrieved_source_kind_id) RETURNING id INTO schema_environment_id;
	ELSE
		UPDATE schema_environments SET environment_kind_id = retrieved_environment_kind_id, source_kind_id = retrieved_source_kind_id WHERE schema_extension_id = v_extension_id RETURNING id INTO schema_environment_id;
	END IF;

	RETURN schema_environment_id;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION genscript_upsert_schema_environments_principal_kinds(v_environment_id INT, v_principal_kind_name VARCHAR(256)) RETURNS void AS $$
DECLARE
	retrieved_kind_id SMALLINT;
BEGIN
	SELECT id INTO retrieved_kind_id FROM kind WHERE name = v_principal_kind_name;
	IF retrieved_kind_id IS NULL THEN
		RAISE EXCEPTION 'couldn''t find matching kind_id';
	END IF;
	
	IF NOT EXISTS (SELECT 1 FROM schema_environments_principal_kinds pk WHERE pk.principal_kind = retrieved_kind_id) THEN
		INSERT INTO schema_environments_principal_kinds (environment_id, principal_kind) VALUES (v_environment_id, retrieved_kind_id);
	END IF;
END;
$$ LANGUAGE plpgsql;

DO $$
DECLARE
	extension_id INT;
	environment_id INT;
BEGIN
	LOCK schema_extensions, schema_node_kinds, schema_relationship_kinds, kind;

	IF NOT EXISTS (SELECT id FROM schema_extensions WHERE name = 'AD') THEN
		INSERT INTO schema_extensions (name, display_name, version, is_builtin, namespace) VALUES ('AD', 'Active Directory', 'v0.0.1', true, 'AD') RETURNING id INTO extension_id;
	ELSE
		UPDATE schema_extensions SET display_name = 'Active Directory', version = 'v0.0.1', namespace = 'AD' WHERE name = 'AD' RETURNING id INTO extension_id;
	END IF;

	-- Insert Node Kinds
	PERFORM genscript_upsert_kind('Base');
	PERFORM genscript_upsert_kind('User');
	PERFORM genscript_upsert_kind('Computer');
	PERFORM genscript_upsert_kind('Group');
	PERFORM genscript_upsert_kind('GPO');
	PERFORM genscript_upsert_kind('OU');
	PERFORM genscript_upsert_kind('Container');
	PERFORM genscript_upsert_kind('Domain');
	PERFORM genscript_upsert_kind('ADLocalGroup');
	PERFORM genscript_upsert_kind('ADLocalUser');
	PERFORM genscript_upsert_kind('AIACA');
	PERFORM genscript_upsert_kind('RootCA');
	PERFORM genscript_upsert_kind('EnterpriseCA');
	PERFORM genscript_upsert_kind('NTAuthStore');
	PERFORM genscript_upsert_kind('CertTemplate');
	PERFORM genscript_upsert_kind('IssuancePolicy');

	-- Insert Relationship Kinds
	PERFORM genscript_upsert_kind('Owns');
	PERFORM genscript_upsert_kind('GenericAll');
	PERFORM genscript_upsert_kind('GenericWrite');
	PERFORM genscript_upsert_kind('WriteOwner');
	PERFORM genscript_upsert_kind('WriteDacl');
	PERFORM genscript_upsert_kind('MemberOf');
	PERFORM genscript_upsert_kind('ForceChangePassword');
	PERFORM genscript_upsert_kind('AllExtendedRights');
	PERFORM genscript_upsert_kind('AddMember');
	PERFORM genscript_upsert_kind('HasSession');
	PERFORM genscript_upsert_kind('Contains');
	PERFORM genscript_upsert_kind('GPLink');
	PERFORM genscript_upsert_kind('AllowedToDelegate');
	PERFORM genscript_upsert_kind('CoerceToTGT');
	PERFORM genscript_upsert_kind('GetChanges');
	PERFORM genscript_upsert_kind('GetChangesAll');
	PERFORM genscript_upsert_kind('GetChangesInFilteredSet');
	PERFORM genscript_upsert_kind('CrossForestTrust');
	PERFORM genscript_upsert_kind('SameForestTrust');
	PERFORM genscript_upsert_kind('SpoofSIDHistory');
	PERFORM genscript_upsert_kind('AbuseTGTDelegation');
	PERFORM genscript_upsert_kind('AllowedToAct');
	PERFORM genscript_upsert_kind('AdminTo');
	PERFORM genscript_upsert_kind('CanPSRemote');
	PERFORM genscript_upsert_kind('CanRDP');
	PERFORM genscript_upsert_kind('ExecuteDCOM');
	PERFORM genscript_upsert_kind('HasSIDHistory');
	PERFORM genscript_upsert_kind('AddSelf');
	PERFORM genscript_upsert_kind('DCSync');
	PERFORM genscript_upsert_kind('ReadLAPSPassword');
	PERFORM genscript_upsert_kind('ReadGMSAPassword');
	PERFORM genscript_upsert_kind('DumpSMSAPassword');
	PERFORM genscript_upsert_kind('SQLAdmin');
	PERFORM genscript_upsert_kind('AddAllowedToAct');
	PERFORM genscript_upsert_kind('WriteSPN');
	PERFORM genscript_upsert_kind('AddKeyCredentialLink');
	PERFORM genscript_upsert_kind('LocalToComputer');
	PERFORM genscript_upsert_kind('MemberOfLocalGroup');
	PERFORM genscript_upsert_kind('RemoteInteractiveLogonRight');
	PERFORM genscript_upsert_kind('SyncLAPSPassword');
	PERFORM genscript_upsert_kind('WriteAccountRestrictions');
	PERFORM genscript_upsert_kind('WriteGPLink');
	PERFORM genscript_upsert_kind('RootCAFor');
	PERFORM genscript_upsert_kind('DCFor');
	PERFORM genscript_upsert_kind('PublishedTo');
	PERFORM genscript_upsert_kind('ManageCertificates');
	PERFORM genscript_upsert_kind('ManageCA');
	PERFORM genscript_upsert_kind('DelegatedEnrollmentAgent');
	PERFORM genscript_upsert_kind('Enroll');
	PERFORM genscript_upsert_kind('HostsCAService');
	PERFORM genscript_upsert_kind('WritePKIEnrollmentFlag');
	PERFORM genscript_upsert_kind('WritePKINameFlag');
	PERFORM genscript_upsert_kind('NTAuthStoreFor');
	PERFORM genscript_upsert_kind('TrustedForNTAuth');
	PERFORM genscript_upsert_kind('EnterpriseCAFor');
	PERFORM genscript_upsert_kind('IssuedSignedBy');
	PERFORM genscript_upsert_kind('GoldenCert');
	PERFORM genscript_upsert_kind('EnrollOnBehalfOf');
	PERFORM genscript_upsert_kind('OIDGroupLink');
	PERFORM genscript_upsert_kind('ExtendedByPolicy');
	PERFORM genscript_upsert_kind('ADCSESC1');
	PERFORM genscript_upsert_kind('ADCSESC3');
	PERFORM genscript_upsert_kind('ADCSESC4');
	PERFORM genscript_upsert_kind('ADCSESC6a');
	PERFORM genscript_upsert_kind('ADCSESC6b');
	PERFORM genscript_upsert_kind('ADCSESC9a');
	PERFORM genscript_upsert_kind('ADCSESC9b');
	PERFORM genscript_upsert_kind('ADCSESC10a');
	PERFORM genscript_upsert_kind('ADCSESC10b');
	PERFORM genscript_upsert_kind('ADCSESC13');
	PERFORM genscript_upsert_kind('SyncedToEntraUser');
	PERFORM genscript_upsert_kind('CoerceAndRelayNTLMToSMB');
	PERFORM genscript_upsert_kind('CoerceAndRelayNTLMToADCS');
	PERFORM genscript_upsert_kind('WriteOwnerLimitedRights');
	PERFORM genscript_upsert_kind('WriteOwnerRaw');
	PERFORM genscript_upsert_kind('OwnsLimitedRights');
	PERFORM genscript_upsert_kind('OwnsRaw');
	PERFORM genscript_upsert_kind('ClaimSpecialIdentity');
	PERFORM genscript_upsert_kind('CoerceAndRelayNTLMToLDAP');
	PERFORM genscript_upsert_kind('CoerceAndRelayNTLMToLDAPS');
	PERFORM genscript_upsert_kind('ContainsIdentity');
	PERFORM genscript_upsert_kind('PropagatesACEsTo');
	PERFORM genscript_upsert_kind('GPOAppliesTo');
	PERFORM genscript_upsert_kind('CanApplyGPO');
	PERFORM genscript_upsert_kind('HasTrustKeys');
	PERFORM genscript_upsert_kind('ProtectAdminGroups');

	PERFORM genscript_upsert_schema_node_kind(extension_id, 'Base', 'Base', '', false, '', '');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'User', 'User', '', true, 'fa-user', '#17E625');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'Computer', 'Computer', '', true, 'fa-desktop', '#E67873');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'Group', 'Group', '', true, 'fa-users', '#DBE617');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'GPO', 'GPO', '', true, 'fa-list', '#998EFD');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'OU', 'OU', '', true, 'fa-sitemap', '#FFAA00');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'Container', 'Container', '', true, 'fa-box', '#F79A78');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'Domain', 'Domain', '', true, 'fa-globe', '#17E6B9');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'ADLocalGroup', 'ADLocalGroup', '', false, '', '');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'ADLocalUser', 'ADLocalUser', '', false, '', '');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'AIACA', 'AIACA', '', true, 'fa-arrows-left-right-to-line', '#9769F0');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'RootCA', 'RootCA', '', true, 'fa-landmark', '#6968E8');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'EnterpriseCA', 'EnterpriseCA', '', true, 'fa-building', '#4696E9');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'NTAuthStore', 'NTAuthStore', '', true, 'fa-store', '#D575F5');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'CertTemplate', 'CertTemplate', '', true, 'fa-id-card', '#B153F3');
	PERFORM genscript_upsert_schema_node_kind(extension_id, 'IssuancePolicy', 'IssuancePolicy', '', true, 'fa-clipboard-check', '#99B2DD');

	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'Owns', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GenericAll', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GenericWrite', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteOwner', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteDacl', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'MemberOf', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ForceChangePassword', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AllExtendedRights', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AddMember', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'HasSession', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'Contains', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GPLink', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AllowedToDelegate', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CoerceToTGT', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GetChanges', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GetChangesAll', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GetChangesInFilteredSet', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CrossForestTrust', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'SameForestTrust', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'SpoofSIDHistory', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AbuseTGTDelegation', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AllowedToAct', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AdminTo', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CanPSRemote', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CanRDP', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ExecuteDCOM', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'HasSIDHistory', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AddSelf', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'DCSync', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ReadLAPSPassword', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ReadGMSAPassword', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'DumpSMSAPassword', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'SQLAdmin', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AddAllowedToAct', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteSPN', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'AddKeyCredentialLink', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'LocalToComputer', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'MemberOfLocalGroup', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'RemoteInteractiveLogonRight', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'SyncLAPSPassword', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteAccountRestrictions', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteGPLink', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'RootCAFor', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'DCFor', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'PublishedTo', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ManageCertificates', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ManageCA', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'DelegatedEnrollmentAgent', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'Enroll', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'HostsCAService', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WritePKIEnrollmentFlag', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WritePKINameFlag', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'NTAuthStoreFor', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'TrustedForNTAuth', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'EnterpriseCAFor', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'IssuedSignedBy', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GoldenCert', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'EnrollOnBehalfOf', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'OIDGroupLink', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ExtendedByPolicy', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC1', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC3', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC4', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC6a', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC6b', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC9a', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC9b', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC10a', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC10b', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ADCSESC13', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'SyncedToEntraUser', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CoerceAndRelayNTLMToSMB', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CoerceAndRelayNTLMToADCS', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteOwnerLimitedRights', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'WriteOwnerRaw', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'OwnsLimitedRights', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'OwnsRaw', '', false);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ClaimSpecialIdentity', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CoerceAndRelayNTLMToLDAP', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CoerceAndRelayNTLMToLDAPS', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ContainsIdentity', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'PropagatesACEsTo', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'GPOAppliesTo', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'CanApplyGPO', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'HasTrustKeys', '', true);
	PERFORM genscript_upsert_schema_relationship_kind(extension_id, 'ProtectAdminGroups', '', false);

	PERFORM genscript_upsert_source_kind('Base');
	PERFORM genscript_upsert_kind('Domain');
	SELECT genscript_upsert_schema_environments(extension_id, 'Domain', 'Base') INTO environment_id;
	PERFORM genscript_upsert_schema_environments_principal_kinds(environment_id, 'User');
	PERFORM genscript_upsert_schema_environments_principal_kinds(environment_id, 'Computer');
END $$;

DROP FUNCTION IF EXISTS genscript_upsert_kind;
DROP FUNCTION IF EXISTS genscript_upsert_source_kind;
DROP FUNCTION IF EXISTS genscript_upsert_schema_node_kind;
DROP FUNCTION IF EXISTS genscript_upsert_schema_relationship_kind;
DROP FUNCTION IF EXISTS genscript_upsert_schema_environments;
DROP FUNCTION IF EXISTS genscript_upsert_schema_environments_principal_kinds;
