// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

import { HTMLProps } from 'react';

export const groupSpecialFormat = (sourceType: string | undefined, sourceName: string | undefined) => {
    if (!sourceType || !sourceName) return 'This entity has';
    if (sourceType === 'Group') {
        return `The members of the ${typeFormat(sourceType)} ${sourceName} have`;
    } else {
        return `The ${typeFormat(sourceType)} ${sourceName} has`;
    }
};

export const typeFormat = (type: string | undefined): string => {
    if (!type) return '';
    if (type === 'GPO' || type === 'OU') {
        return type;
    } else if (type === 'CertTemplate') {
        return 'certificate template';
    } else if (type === 'EnterpriseCA') {
        return 'enterprise CA';
    } else if (type === 'RootCA') {
        return 'root CA';
    } else if (type === 'NTAuthStore') {
        return 'NTAuth store';
    } else if (type === 'AIACA') {
        return 'AIA CA';
    } else {
        return type.toLowerCase();
    }
};

export const hasChildCodeElementsClasses: HTMLProps<HTMLElement>['className'] =
    '[&_code]:bg-neutral-3 [&_code]:py-[2px] [&_code]:px-[0.5ch] [&_code]:font-normal [&_code]:text-sm [&_code]:rounded [&_code]:inline [&_code]:break-words [&_code]:whitespace-pre-wrap';
