/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.synchronize;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;

public class FastSyncInfoFilter
extends SyncInfoFilter {
    public static FastSyncInfoFilter getDirectionAndChangeFilter(int direction, int change) {
        return new AndSyncInfoFilter(new FastSyncInfoFilter[]{new SyncInfoDirectionFilter(direction), new SyncInfoChangeTypeFilter(change)});
    }

    public boolean select(SyncInfo info) {
        return info.getKind() != 0;
    }

    @Override
    public final boolean select(SyncInfo info, IProgressMonitor monitor) {
        return this.select(info);
    }

    public static class AndSyncInfoFilter
    extends CompoundSyncInfoFilter {
        public AndSyncInfoFilter(FastSyncInfoFilter[] filters) {
            super(filters);
        }

        @Override
        public boolean select(SyncInfo info) {
            FastSyncInfoFilter[] fastSyncInfoFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                FastSyncInfoFilter filter = fastSyncInfoFilterArray[n2];
                if (!filter.select(info)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public static class AutomergableFilter
    extends FastSyncInfoFilter {
        @Override
        public boolean select(SyncInfo info) {
            return (info.getKind() & 0x20) != 0;
        }
    }

    public static abstract class CompoundSyncInfoFilter
    extends FastSyncInfoFilter {
        protected FastSyncInfoFilter[] filters;

        protected CompoundSyncInfoFilter(FastSyncInfoFilter[] filters) {
            this.filters = filters;
        }
    }

    public static class OrSyncInfoFilter
    extends CompoundSyncInfoFilter {
        public OrSyncInfoFilter(FastSyncInfoFilter[] filters) {
            super(filters);
        }

        @Override
        public boolean select(SyncInfo info) {
            FastSyncInfoFilter[] fastSyncInfoFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                FastSyncInfoFilter filter = fastSyncInfoFilterArray[n2];
                if (filter.select(info)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class PseudoConflictFilter
    extends FastSyncInfoFilter {
        @Override
        public boolean select(SyncInfo info) {
            return info.getKind() != 0 && (info.getKind() & 0x10) == 0;
        }
    }

    public static class SyncInfoChangeTypeFilter
    extends FastSyncInfoFilter {
        private int[] changeFilters = new int[]{1, 2, 3};

        public SyncInfoChangeTypeFilter(int[] changeFilters) {
            this.changeFilters = changeFilters;
        }

        public SyncInfoChangeTypeFilter(int change) {
            this(new int[]{change});
        }

        @Override
        public boolean select(SyncInfo info) {
            int syncKind = info.getKind();
            int[] nArray = this.changeFilters;
            int n = this.changeFilters.length;
            int n2 = 0;
            while (n2 < n) {
                int filter = nArray[n2];
                if ((syncKind & 3) == filter) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class SyncInfoDirectionFilter
    extends FastSyncInfoFilter {
        int[] directionFilters = new int[]{4, 8, 12};

        public SyncInfoDirectionFilter(int[] directionFilters) {
            this.directionFilters = directionFilters;
        }

        public SyncInfoDirectionFilter(int direction) {
            this(new int[]{direction});
        }

        @Override
        public boolean select(SyncInfo info) {
            int syncKind = info.getKind();
            int[] nArray = this.directionFilters;
            int n = this.directionFilters.length;
            int n2 = 0;
            while (n2 < n) {
                int filter = nArray[n2];
                if ((syncKind & 0xC) == filter) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

