/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceExportPage1;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FileSystemExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private WizardFileSystemResourceExportPage1 mainPage;

    public FileSystemExportWizard() {
        IDialogSettings workbenchSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(WorkbenchPlugin.class)).getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("FileSystemExportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("FileSystemExportWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardFileSystemResourceExportPage1(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        Object selectedResource;
        IEditorPart currentEditor;
        IWorkbenchPage page;
        this.selection = currentSelection;
        List<IResource> selectedResources = IDE.computeSelectedResources(currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        if (this.selection.isEmpty() && workbench.getActiveWorkbenchWindow() != null && (page = workbench.getActiveWorkbenchWindow().getActivePage()) != null && (currentEditor = page.getActiveEditor()) != null && (selectedResource = Adapters.adapt((Object)currentEditor.getEditorInput(), IResource.class)) != null) {
            this.selection = new StructuredSelection(selectedResource);
        }
        this.setWindowTitle(DataTransferMessages.DataTransfer_export);
        this.setDefaultPageImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/exportdir_wiz.svg"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        return this.mainPage.finish();
    }
}

