/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.JDBCType;

public enum AltibaseDataTypeDomain {
    CHAR(JDBCType.CHAR),
    VARCHAR(JDBCType.VARCHAR),
    NCHAR(JDBCType.NCHAR.getName(), -9),
    NVARCHAR(JDBCType.NVARCHAR),
    INTEGER(JDBCType.INTEGER),
    SMALLINT(JDBCType.SMALLINT),
    BIGINT(JDBCType.BIGINT),
    REAL(JDBCType.REAL),
    NUMBER("NUMBER", 2),
    NUMERIC(JDBCType.NUMERIC),
    DOUBLE(JDBCType.DOUBLE),
    FLOAT(JDBCType.FLOAT),
    DATE(JDBCType.DATE.getName(), 93),
    BIT(JDBCType.BIT),
    VARBIT("VARBIT", -7),
    BYTE("BYTE", -2),
    VARBYTE("VARBYTE", -2),
    NIBBLE("NIBBLE", 12),
    BINARY(JDBCType.BINARY),
    CLOB(JDBCType.CLOB),
    BLOB(JDBCType.BLOB),
    GEOMETRY("GEOMETRY", -2);

    private final String name;
    private final int jdbcTypeID;

    private AltibaseDataTypeDomain(JDBCType jdbcType) {
        this.name = jdbcType.getName();
        this.jdbcTypeID = jdbcType.getVendorTypeNumber();
    }

    private AltibaseDataTypeDomain(String name, int jdbcType) {
        this.name = name;
        this.jdbcTypeID = jdbcType;
    }

    public int getValueType() {
        return this.jdbcTypeID;
    }

    public String getTypeName() {
        return this.name;
    }

    public static AltibaseDataTypeDomain getByTypeName(String typeName) {
        for (AltibaseDataTypeDomain ft : AltibaseDataTypeDomain.values()) {
            if (!ft.name.equalsIgnoreCase(typeName)) continue;
            return ft;
        }
        return null;
    }
}

