/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.hana.model.HANATable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class HANASchema
extends GenericSchema
implements DBPQualifiedObject,
DBPObjectStatisticsCollector {
    @NotNull
    private String schemaName;
    private boolean hasStatistics;

    public HANASchema(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) {
        super(dataSource, catalog, schemaName);
        this.schemaName = schemaName;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.schemaName;
    }

    public void setName(@NotNull String schemaName) {
        this.schemaName = schemaName;
    }

    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return HANATable.class;
    }

    public boolean hasOnlySynonyms() {
        return "PUBLIC".equals(this.getName());
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.hasStatistics = false;
        return super.refreshObject(monitor);
    }

    void resetStatistics() {
        this.hasStatistics = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics || forceRefresh) {
            return;
        }
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read relation statistics");){
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT TABLE_NAME, DISK_SIZE\nFROM SYS.M_TABLE_PERSISTENCE_STATISTICS\nWHERE SCHEMA_NAME = ?\nORDER BY TABLE_NAME");){
                dbStat.setString(1, this.getName());
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        String tableName = dbResult.getString("TABLE_NAME");
                        GenericTableBase table = this.getTable(monitor, tableName);
                        if (!(table instanceof HANATable)) continue;
                        ((HANATable)table).fetchStatistics(dbResult);
                    }
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading schema relation statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }
}

