/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.hana.model.HANAProcedure;
import org.jkiss.dbeaver.ext.hana.model.HANASchema;
import org.jkiss.dbeaver.ext.hana.model.HANASynonym;
import org.jkiss.dbeaver.ext.hana.model.HANAView;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum HANAObjectType implements DBSObjectType
{
    PROCEDURE("PROCEDURE", "HANA procedure", HANAProcedure.class, (DBPImage)DBIcon.TREE_PROCEDURE),
    SYNONYM("SYNONYM", "HANA synonym", HANASynonym.class, (DBPImage)DBIcon.TREE_SYNONYM),
    TABLE("TABLE", "HANA table", GenericTable.class, (DBPImage)DBIcon.TREE_TABLE),
    VIEW("VIEW", "HANA view", HANAView.class, (DBPImage)DBIcon.TREE_VIEW),
    SCHEMA("SCHEMA", "HANA schema", HANASchema.class, (DBPImage)DBIcon.TREE_SCHEMA);

    private final String type;
    private final String description;
    private final Class<? extends DBSObject> theClass;
    private final DBPImage icon;
    private static final Log log;

    private HANAObjectType(String type, String description, Class<? extends DBSObject> theClass, DBPImage icon) {
        this.type = type;
        this.description = description;
        this.theClass = theClass;
        this.icon = icon;
    }

    public String getTypeName() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getImage() {
        return this.icon;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.theClass;
    }

    public String toString() {
        return this.type;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, GenericObjectContainer schema, String objectName) throws DBException {
        if (schema == null) {
            log.debug((Object)("Null schema in table " + objectName + " search (" + objectName + ")"));
            return null;
        }
        if (GenericTable.class.isAssignableFrom(this.theClass) || HANAView.class.isAssignableFrom(this.theClass)) {
            return schema.getChild(monitor, objectName);
        }
        if (HANAProcedure.class.isAssignableFrom(this.theClass)) {
            return schema.getProcedure(monitor, objectName);
        }
        if (HANASynonym.class.isAssignableFrom(this.theClass)) {
            return schema.getSynonym(monitor, objectName);
        }
        log.debug((Object)("Unsupported object for SQL Server search: " + this.name()));
        return null;
    }

    static {
        log = Log.getLog(HANAObjectType.class);
    }
}

