# Vendoring dependencies

```bash
# Run this from project root directory
go mod vendor -v

# Download the dependencies that are not available in Debian, are unlikely to
# ever be in Debian as independent separate packages, and thus need to be
# vendored in this package
MODULES=(
  "github.com/pingcap/log"
)

# Loop through each module
for MODULE in "${MODULES[@]}"
do
  mkdir -p debian/vendor/"$MODULE"
  cp --archive --update --verbose vendor/"$MODULE"/* debian/vendor/"$MODULE"/
done
```
