/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AsyncSemaphore;
import org.xbill.DNS.DohResolverCommon;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.Type;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DohResolver
extends DohResolverCommon {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DohResolver.class);
    private static final String APPLICATION_DNS_MESSAGE = "application/dns-message";
    private static final Map<Executor, HttpClient> httpClients = Collections.synchronizedMap(new WeakHashMap());
    private static final HttpRequest.Builder defaultHttpRequestBuilder = HttpRequest.newBuilder();
    private final AsyncSemaphore initialRequestLock = new AsyncSemaphore(1, "initial request");
    private final Duration idleConnectionTimeout;

    public DohResolver(String uriTemplate) {
        this(uriTemplate, 100, Duration.ofMinutes(2L));
    }

    public DohResolver(String uriTemplate, int maxConcurrentRequests, Duration idleConnectionTimeout) {
        super(uriTemplate, maxConcurrentRequests);
        log.debug("Using Java 11+ implementation");
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    private HttpClient getHttpClient(Executor executor) {
        return httpClients.computeIfAbsent(executor, key -> {
            try {
                return HttpClient.newBuilder().connectTimeout(this.timeout).executor(executor).build();
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not create a HttpClient for Executor {}", key, (Object)e);
                return null;
            }
        });
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
        httpClients.clear();
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        super.setEDNS(version, payloadSize, flags, options);
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query) {
        return this.sendAsync(query, this.defaultExecutor);
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query, Executor executor) {
        Duration remainingTimeout;
        long startTime = this.getNanoTime();
        byte[] queryBytes = this.prepareQuery(query).toWire();
        String url = this.getUrl(queryBytes);
        HttpRequest.Builder requestBuilder = defaultHttpRequestBuilder.copy();
        requestBuilder.uri(URI.create(url));
        if (this.usePost) {
            requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(queryBytes));
        }
        if ((remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS)).toMillis() <= 0L) {
            return this.timeoutFailedFuture(query, "no time left to acquire lock for first request", null);
        }
        return this.initialRequestLock.acquire(remainingTimeout, query.getHeader().getID(), executor).handle((initialRequestPermit, initialRequestEx) -> {
            if (initialRequestEx != null) {
                return this.timeoutFailedFuture(query, (Throwable)initialRequestEx);
            }
            return this.sendAsyncWithInitialRequestPermit(query, executor, startTime, requestBuilder, (AsyncSemaphore.Permit)initialRequestPermit);
        }).thenCompose(Function.identity());
    }

    private CompletionStage<Message> sendAsyncWithInitialRequestPermit(Message query, Executor executor, long startTime, HttpRequest.Builder requestBuilder, AsyncSemaphore.Permit initialRequestPermit) {
        Duration remainingTimeout;
        boolean isInitialRequest;
        int queryId = query.getHeader().getID();
        long lastRequestTime = this.lastRequest.get();
        long requestDeltaNanos = this.getNanoTime() - lastRequestTime;
        boolean bl = isInitialRequest = lastRequestTime == 0L || this.idleConnectionTimeout.toNanos() < requestDeltaNanos;
        if (!isInitialRequest) {
            initialRequestPermit.release(queryId, executor);
        }
        if ((remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS)).toMillis() <= 0L) {
            if (isInitialRequest) {
                initialRequestPermit.release(queryId, executor);
            }
            return this.timeoutFailedFuture(query, "no time left to acquire lock for concurrent request", null);
        }
        return this.maxConcurrentRequests.acquire(remainingTimeout, queryId, executor).handle((maxConcurrentRequestPermit, maxConcurrentRequestEx) -> {
            if (maxConcurrentRequestEx != null) {
                if (isInitialRequest) {
                    initialRequestPermit.release(queryId, executor);
                }
                return this.timeoutFailedFuture(query, "timed out waiting for a concurrent request lease", (Throwable)maxConcurrentRequestEx);
            }
            return this.sendAsyncWithConcurrentRequestPermit(query, executor, startTime, requestBuilder, initialRequestPermit, isInitialRequest, (AsyncSemaphore.Permit)maxConcurrentRequestPermit);
        }).thenCompose(Function.identity());
    }

    private CompletionStage<Message> sendAsyncWithConcurrentRequestPermit(Message query, Executor executor, long startTime, HttpRequest.Builder requestBuilder, AsyncSemaphore.Permit initialRequestPermit, boolean isInitialRequest, AsyncSemaphore.Permit maxConcurrentRequestPermit) {
        int queryId = query.getHeader().getID();
        Duration remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS);
        if (remainingTimeout.toMillis() <= 0L) {
            if (isInitialRequest) {
                initialRequestPermit.release(queryId, executor);
            }
            maxConcurrentRequestPermit.release(queryId, executor);
            return this.timeoutFailedFuture(query, "no time left to acquire lock for concurrent request", null);
        }
        HttpRequest httpRequest = requestBuilder.timeout(remainingTimeout).build();
        HttpResponse.BodyHandler<byte[]> bodyHandler = HttpResponse.BodyHandlers.ofByteArray();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getHttpClient(executor).sendAsync(httpRequest, bodyHandler).whenComplete((result, ex) -> {
            if (ex == null) {
                this.lastRequest.set(startTime);
            }
            maxConcurrentRequestPermit.release(queryId, executor);
            if (isInitialRequest) {
                initialRequestPermit.release(queryId, executor);
            }
        })).handleAsync((response, ex) -> {
            if (ex != null) {
                if (ex instanceof HttpTimeoutException) {
                    return this.timeoutFailedFuture(query, "http request did not complete", ex.getCause());
                }
                return CompletableFuture.failedFuture(ex);
            }
            try {
                Message responseMessage;
                int rc = response.statusCode();
                if (rc >= 200 && rc < 300) {
                    byte[] responseBytes = (byte[])response.body();
                    responseMessage = new Message(responseBytes);
                    this.verifyTSIG(query, responseMessage, responseBytes, this.tsig);
                } else {
                    responseMessage = new Message();
                    responseMessage.getHeader().setRcode(2);
                }
                responseMessage.setResolver(this);
                return CompletableFuture.completedFuture(responseMessage);
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
        }, executor)).thenCompose(Function.identity())).orTimeout(remainingTimeout.toMillis(), TimeUnit.MILLISECONDS).exceptionally(ex -> {
            if (ex instanceof TimeoutException) {
                throw new CompletionException(new TimeoutException("Query " + query.getHeader().getID() + " for " + String.valueOf(query.getQuestion().getName()) + "/" + Type.string(query.getQuestion().getType()) + " timed out in remaining " + remainingTimeout.toMillis() + "ms"));
            }
            if (ex instanceof CompletionException) {
                throw (CompletionException)ex;
            }
            throw new CompletionException((Throwable)ex);
        });
    }

    @Override
    protected <T> CompletableFuture<T> failedFuture(Throwable e) {
        return CompletableFuture.failedFuture(e);
    }

    static {
        defaultHttpRequestBuilder.version(HttpClient.Version.HTTP_2);
        defaultHttpRequestBuilder.header("Content-Type", APPLICATION_DNS_MESSAGE);
        defaultHttpRequestBuilder.header("Accept", APPLICATION_DNS_MESSAGE);
    }
}

