/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing;

import com.jsql.model.InjectionModel;
import com.jsql.util.GitUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.subscriber.SubscriberView;
import com.jsql.view.swing.action.HotkeyUtil;
import com.jsql.view.swing.menubar.AppMenubar;
import com.jsql.view.swing.panel.PanelAddressBar;
import com.jsql.view.swing.panel.split.SplitNS;
import com.jsql.view.swing.tab.TabManagers;
import com.jsql.view.swing.terminal.AbstractExploit;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFrameView
extends JFrame {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Map<UUID, AbstractExploit> mapUuidShell = new HashMap<UUID, AbstractExploit>();
    private final transient SubscriberView subscriberView = new SubscriberView();
    private TabManagers tabManagers;
    private boolean isMaximized = false;
    private final InjectionModel injectionModel;
    private SplitNS splitNS;

    public JFrameView(InjectionModel injectionModel) {
        super("jSQL Injection");
        this.injectionModel = injectionModel;
        MediatorHelper.register(this);
        UiUtil.prepareGUI();
        this.initPaneComponents();
        this.initWindow();
        this.initShortcuts();
        this.displayVersion();
        I18nUtil.checkCurrentLanguage();
        this.check4K();
        SwingUtilities.invokeLater(() -> {
            AppMenubar.applyTheme(injectionModel.getMediatorUtils().preferencesUtil().getThemeFlatLafName());
            if (injectionModel.getMediatorUtils().proxyUtil().isNotLive(GitUtil.ShowOnConsole.YES)) {
                return;
            }
            if (injectionModel.getMediatorUtils().preferencesUtil().isCheckingUpdate()) {
                injectionModel.getMediatorUtils().gitUtil().checkUpdate(GitUtil.ShowOnConsole.NO);
            }
            if (injectionModel.getMediatorUtils().preferencesUtil().isShowNews()) {
                injectionModel.getMediatorUtils().gitUtil().showNews();
            }
            this.setVisible(true);
            MediatorHelper.panelAddressBar().getTextFieldAddress().requestFocusInWindow();
        });
    }

    private void initPaneComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.tabManagers = new TabManagers();
        this.add(this.tabManagers);
        AppMenubar menubar = new AppMenubar();
        this.setJMenuBar(menubar);
        MediatorHelper.register(menubar);
        PanelAddressBar panelAddressBar = new PanelAddressBar();
        MediatorHelper.register(panelAddressBar);
        this.add(panelAddressBar);
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.splitNS = new SplitNS();
        mainPanel.add(this.splitNS);
        this.add(mainPanel);
        menubar.getMenuWindows().switchLocaleFromPreferences();
    }

    private void initWindow() {
        this.setIconImages(UiUtil.getIcons());
        final Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        this.addWindowStateListener(e -> {
            this.isMaximized = (e.getNewState() & 6) == 6;
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                double nsProportion = preferences.getDouble("horizontalSplitter", 0.75);
                double ewProportion = preferences.getDouble("verticalSplitter", 0.33);
                if (preferences.getBoolean("is_maximized", false)) {
                    JFrameView.this.setExtendedState(6);
                }
                SwingUtilities.invokeLater(() -> {
                    JFrameView.this.splitNS.setDividerLocation(Math.clamp(nsProportion, 0.0, 1.0));
                    JFrameView.this.splitNS.getSplitEW().setDividerLocation(Math.clamp(ewProportion, 0.0, 1.0));
                    MediatorHelper.panelConsoles().getNetworkSplitPane().setDividerLocation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()).isLeftToRight() ? 0.33 : 0.66);
                });
            }

            @Override
            public void windowClosing(WindowEvent e) {
                preferences.putBoolean("is_maximized", JFrameView.this.isMaximized);
                int ewDividerLocation = JFrameView.this.splitNS.getSplitEW().getDividerLocation();
                int ewHeight = JFrameView.this.splitNS.getSplitEW().getWidth();
                double ewProportion = 100.0 * (double)ewDividerLocation / (double)ewHeight;
                double ewLocationProportionCapped = Math.clamp(ewProportion / 100.0, 0.0, 1.0);
                int nsDividerLocation = JFrameView.this.splitNS.getDividerLocation();
                int nsHeight = JFrameView.this.splitNS.getHeight();
                double nsProportion = 100.0 * (double)nsDividerLocation / (double)nsHeight;
                double nsLocationProportionCapped = Math.clamp(nsProportion / 100.0, 0.0, 1.0);
                preferences.putDouble("horizontalSplitter", nsLocationProportionCapped);
                preferences.putDouble("verticalSplitter", ewLocationProportionCapped);
                preferences.putBoolean("binary_visible", false);
                preferences.putBoolean("chunk_visible", false);
                preferences.putBoolean("header_visible", false);
                preferences.putBoolean("java_visible", false);
                for (int i = 0; i < MediatorHelper.tabConsoles().getTabCount(); ++i) {
                    if ("CONSOLE_BINARY_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("binary_visible", true);
                        continue;
                    }
                    if ("CONSOLE_CHUNK_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("chunk_visible", true);
                        continue;
                    }
                    if ("CONSOLE_NETWORK_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("header_visible", true);
                        continue;
                    }
                    if (!"CONSOLE_JAVA_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) continue;
                    preferences.putBoolean("java_visible", true);
                }
            }
        });
        this.setSize(1024, 768);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private void initShortcuts() {
        HotkeyUtil.addShortcut(this.getRootPane(), MediatorHelper.tabResults());
        HotkeyUtil.addTextFieldShortcutSelectAll();
    }

    public void resetInterface() {
        this.mapUuidShell.clear();
        MediatorHelper.panelAddressBar().getPanelTrailingAddress().reset();
        MediatorHelper.panelConsoles().reset();
        MediatorHelper.treeDatabase().reset();
        for (int i = 0; i < MediatorHelper.tabConsoles().getTabCount(); ++i) {
            Component tabComponent = MediatorHelper.tabConsoles().getTabComponentAt(i);
            if (tabComponent == null) continue;
            tabComponent.setFont(tabComponent.getFont().deriveFont(0));
        }
        Stream.of(MediatorHelper.managerFile(), MediatorHelper.managerExploit()).forEach(managerList -> {
            managerList.setButtonEnable(false);
            managerList.changePrivilegeIcon(UiUtil.SQUARE.getIcon());
        });
    }

    private void displayVersion() {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} v{} on Java {}-{}-{}", () -> "jSQL Injection", () -> this.injectionModel.getPropertiesUtil().getVersionJsql(), () -> SystemUtils.JAVA_VERSION, () -> SystemUtils.OS_ARCH, () -> SystemUtils.USER_LANGUAGE);
    }

    private void check4K() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screenSize.getWidth();
        if (width >= 3840 && !this.injectionModel.getMediatorUtils().preferencesUtil().is4K()) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Screen compatible with resolution 4K, enable high-definition in Preferences");
        }
    }

    public final Map<UUID, AbstractExploit> getMapUuidShell() {
        return this.mapUuidShell;
    }

    public SubscriberView getSubscriberView() {
        return this.subscriberView;
    }

    public SplitNS getSplitNS() {
        return this.splitNS;
    }

    public TabManagers getTabManagers() {
        return this.tabManagers;
    }
}

