/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.model.injection.engine.model.Engine;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.view.swing.util.MediatorHelper;
import java.util.NoSuchElementException;

public class BeanInjection {
    private final String url;
    private String request = "";
    private String header = "";
    private String requestType;
    private AbstractMethodInjection method;
    private Engine engine;

    public BeanInjection(String url) {
        this.url = url;
        this.method = MediatorHelper.model().getMediatorMethod().getQuery();
        this.engine = MediatorHelper.model().getMediatorEngine().getAuto();
        this.requestType = "GET";
    }

    public BeanInjection(String url, String request, String header, String nameMethod, String engine, String requestType) {
        this(url);
        this.request = request;
        this.header = header;
        try {
            this.method = MediatorHelper.model().getMediatorMethod().getMethods().stream().filter(m -> m.name().equalsIgnoreCase(nameMethod)).findAny().orElse(MediatorHelper.model().getMediatorMethod().getQuery());
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            this.method = MediatorHelper.model().getMediatorMethod().getQuery();
        }
        try {
            this.engine = MediatorHelper.model().getMediatorEngine().getEngines().stream().filter(v -> v.toString().equals(engine)).findAny().orElse(MediatorHelper.model().getMediatorEngine().getAuto());
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            this.engine = MediatorHelper.model().getMediatorEngine().getAuto();
        }
        this.requestType = requestType.isEmpty() ? "GET" : requestType;
    }

    public String getMethod() {
        return this.method.name();
    }

    public String getEngine() {
        return this.engine.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getRequest() {
        return this.request;
    }

    public String getHeader() {
        return this.header;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public AbstractMethodInjection getMethodInstance() {
        return this.method;
    }
}

