/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.consoles;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import com.jsql.view.swing.panel.util.HTMLEditorKitTextPaneWrap;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.JPopupTextComponent;
import com.jsql.view.swing.text.JTextPanePlaceholder;
import com.jsql.view.swing.text.SyntaxTextArea;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class TabbedPaneNetworkTab
extends TabbedPaneWheeled {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final RSyntaxTextArea textAreaUrl = new SyntaxTextArea(I18nUtil.valueByKey("NETWORK_LINE_PLACEHOLDER_URL"));
    private final RSyntaxTextArea textAreaResponse = new SyntaxTextArea(I18nUtil.valueByKey("NETWORK_LINE_PLACEHOLDER_RESPONSE"));
    private final RSyntaxTextArea textAreaSource = new SyntaxTextArea(I18nUtil.valueByKey("NETWORK_LINE_PLACEHOLDER_SOURCE"));
    private final JTextPane textPanePreview = (JTextPane)new JPopupTextComponent<1>(new JTextPanePlaceholder(I18nUtil.valueByKey("NETWORK_LINE_PLACEHOLDER_PREVIEW")){

        @Override
        public boolean isEditable() {
            return false;
        }
    }).getProxy();
    private final RSyntaxTextArea textAreaHeader = new SyntaxTextArea(I18nUtil.valueByKey("NETWORK_LINE_PLACEHOLDER_HEADERS"));
    private final RSyntaxTextArea textAreaRequest = new SyntaxTextArea(I18nUtil.valueByKey("NETWORK_LINE_PLACEHOLDER_REQUEST"));
    private final JCheckBox checkBoxDecode = new JCheckBox("Decode", MediatorHelper.model().getMediatorUtils().preferencesUtil().isUrlDecodeNetworkTab());

    public TabbedPaneNetworkTab() {
        this.setName("tabNetwork");
        JPanel panelDecode = new JPanel(new BorderLayout());
        panelDecode.add((Component)this.checkBoxDecode, "After");
        this.putClientProperty("JTabbedPane.trailingComponent", panelDecode);
        I18nViewUtil.addComponentForKey("NETWORK_LINE_PLACEHOLDER_URL", this.textAreaUrl);
        I18nViewUtil.addComponentForKey("NETWORK_LINE_PLACEHOLDER_RESPONSE", this.textAreaResponse);
        I18nViewUtil.addComponentForKey("NETWORK_LINE_PLACEHOLDER_SOURCE", this.textAreaSource);
        I18nViewUtil.addComponentForKey("NETWORK_LINE_PLACEHOLDER_PREVIEW", this.textPanePreview);
        I18nViewUtil.addComponentForKey("NETWORK_LINE_PLACEHOLDER_HEADERS", this.textAreaHeader);
        I18nViewUtil.addComponentForKey("NETWORK_LINE_PLACEHOLDER_REQUEST", this.textAreaRequest);
        Stream.of(new AbstractMap.SimpleEntry<String, RSyntaxTextArea>("NETWORK_TAB_URL_LABEL", this.textAreaUrl), new AbstractMap.SimpleEntry<String, RSyntaxTextArea>("NETWORK_TAB_HEADERS_LABEL", this.textAreaHeader), new AbstractMap.SimpleEntry<String, RSyntaxTextArea>("NETWORK_TAB_PARAMS_LABEL", this.textAreaRequest), new AbstractMap.SimpleEntry<String, RSyntaxTextArea>("NETWORK_TAB_RESPONSE_LABEL", this.textAreaResponse), new AbstractMap.SimpleEntry<String, RSyntaxTextArea>("NETWORK_TAB_SOURCE_LABEL", this.textAreaSource), new AbstractMap.SimpleEntry<String, JTextPane>("NETWORK_TAB_PREVIEW_LABEL", this.textPanePreview)).forEach(entry -> {
            this.addTab(I18nUtil.valueByKey((String)entry.getKey()), entry.getValue() == this.textAreaSource ? new RTextScrollPane((Component)entry.getValue(), false) : new JScrollPane((Component)entry.getValue()));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            label.setName("label" + (String)entry.getKey());
            this.setTabComponentAt(this.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
            ((JTextComponent)entry.getValue()).setName("text" + (String)entry.getKey());
            DefaultCaret caret = (DefaultCaret)((JTextComponent)entry.getValue()).getCaret();
            caret.setUpdatePolicy(1);
        });
        Arrays.asList(this.textAreaUrl, this.textAreaHeader, this.textAreaRequest, this.textAreaResponse, this.textAreaSource).forEach(entry -> {
            entry.setEditable(false);
            entry.setLineWrap(true);
        });
        this.textAreaResponse.setSyntaxEditingStyle("text/html");
        this.textAreaSource.setSyntaxEditingStyle("text/html");
        this.textAreaSource.setHighlightSecondaryLanguages(true);
        this.applyTheme();
        this.textPanePreview.setEditorKit(new HTMLEditorKitTextPaneWrap());
        this.textPanePreview.setContentType("text/html");
        this.textPanePreview.setEditable(false);
        this.textPanePreview.getCaret().setBlinkRate(0);
        this.textPanePreview.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TabbedPaneNetworkTab.this.textPanePreview.getCaret().setVisible(true);
                TabbedPaneNetworkTab.this.textPanePreview.getCaret().setSelectionVisible(true);
            }
        });
    }

    public void changeTextNetwork(Seal.MessageHeader networkData) {
        this.textAreaRequest.setText(this.getDecodedValue(this.checkBoxDecode.isSelected(), networkData.post()));
        this.textAreaUrl.setText(this.getDecodedValue(this.checkBoxDecode.isSelected(), networkData.url()));
        this.updateTextArea(this.textAreaHeader, networkData.header());
        this.updateTextArea(this.textAreaResponse, networkData.response());
        try {
            this.textAreaSource.setText(StringUtil.detectUtf8(networkData.source()).replaceAll("a{5,}", "a*").trim());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.textPanePreview.getEditorKit().createDefaultDocument();
        try {
            this.textPanePreview.setText(Jsoup.clean(String.format("<html>%s</html>", StringUtil.detectUtf8(networkData.source())).replaceAll("<img[^>]*>", "").replaceAll("<input[^>]*type=\"?hidden\"?.*>", "").replaceAll("<input[^>]*type=\"?(submit|button)\"?.*>", "<div style=\"background-color:#eeeeee;text-align:center;border:1px solid black;width:100px;\">button</div>").replaceAll("<input[^>]*>", "<div style=\"text-align:center;border:1px solid black;width:100px;\">input</div>"), Safelist.relaxed().addTags("center", "div", "span").addAttributes(":all", "style")));
        }
        catch (Exception | ExceptionInInitializerError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, e);
        }
    }

    private void updateTextArea(JTextArea textArea, Map<String, String> httpData) {
        textArea.setText("");
        if (httpData != null) {
            httpData.forEach((key, value) -> {
                String decodedValue = this.getDecodedValue(this.checkBoxDecode.isSelected(), (String)value);
                textArea.append(key + ": " + decodedValue + "\n");
            });
        }
    }

    private String getDecodedValue(boolean isSelected, String value) {
        try {
            return isSelected ? StringUtil.fromUrl(value) : value;
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "Decoding failure: {}", (Object)e.getMessage());
            return value;
        }
    }

    public void reset() {
        this.textAreaUrl.setText("");
        this.textAreaHeader.setText("");
        this.textAreaRequest.setText("");
        this.textAreaResponse.setText("");
        try {
            this.textAreaSource.setText("");
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        try {
            this.textPanePreview.setText("");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void applyTheme() {
        Arrays.asList(this.textAreaUrl, this.textAreaHeader, this.textAreaRequest, this.textAreaResponse, this.textAreaSource).forEach(UiUtil::applySyntaxTheme);
    }

    public JCheckBox getCheckBoxDecode() {
        return this.checkBoxDecode;
    }
}

