/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree.model;

import com.jsql.model.bean.database.Database;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.tree.custom.JPopupMenuCustomExtract;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeModelDatabase
extends AbstractNodeModel {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public NodeModelDatabase(Database database) {
        super(database);
    }

    @Override
    protected Icon getLeafIcon(boolean leaf) {
        if (leaf) {
            return UiUtil.DATABASE_LINEAR.getIcon();
        }
        return UiUtil.DATABASE_BOLD.getIcon();
    }

    @Override
    public void runAction() {
        if (this.isRunning()) {
            return;
        }
        MediatorHelper.treeDatabase().getTreeNodeModels().get(this.getElementDatabase()).removeAllChildren();
        DefaultTreeModel treeModel = (DefaultTreeModel)MediatorHelper.treeDatabase().getModel();
        try {
            treeModel.reload(MediatorHelper.treeDatabase().getTreeNodeModels().get(this.getElementDatabase()));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Thread.currentThread().setName("SwingWorkerNodeModelDatabase");
                Database selectedDatabase = (Database)NodeModelDatabase.this.getElementDatabase();
                return MediatorHelper.model().getDataAccess().listTables(selectedDatabase);
            }
        }.execute();
        this.setRunning(true);
    }

    @Override
    public boolean isPopupDisplayable() {
        return this.isLoaded() || !this.isLoaded() && this.isRunning();
    }

    @Override
    protected void buildMenu(JPopupMenuCustomExtract tablePopupMenu, TreePath path) {
    }
}

