// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Sunuwar`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x011BC0, 0x011BE1],
    [0x011BF0, 0x011BF9]
  ]
});
testPropertyEscapes(
  /^\p{Script=Sunuwar}+$/u,
  matchSymbols,
  "\\p{Script=Sunuwar}"
);
testPropertyEscapes(
  /^\p{Script=Sunu}+$/u,
  matchSymbols,
  "\\p{Script=Sunu}"
);
testPropertyEscapes(
  /^\p{sc=Sunuwar}+$/u,
  matchSymbols,
  "\\p{sc=Sunuwar}"
);
testPropertyEscapes(
  /^\p{sc=Sunu}+$/u,
  matchSymbols,
  "\\p{sc=Sunu}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x011BBF],
    [0x011BE2, 0x011BEF],
    [0x011BFA, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Sunuwar}+$/u,
  nonMatchSymbols,
  "\\P{Script=Sunuwar}"
);
testPropertyEscapes(
  /^\P{Script=Sunu}+$/u,
  nonMatchSymbols,
  "\\P{Script=Sunu}"
);
testPropertyEscapes(
  /^\P{sc=Sunuwar}+$/u,
  nonMatchSymbols,
  "\\P{sc=Sunuwar}"
);
testPropertyEscapes(
  /^\P{sc=Sunu}+$/u,
  nonMatchSymbols,
  "\\P{sc=Sunu}"
);

reportCompare(0, 0);
